/*
 * The MIT License
 *
 * Copyright 2016 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.http.download;


import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Синхронный счетчик
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class IntCounter 
        extends Counter<Integer>
        implements 
            ResetCounter,
            SetCounter<Integer>
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static final Logger logger = Logger.getLogger(IntCounter.class.getName());
    private static final Level logLevel = logger.getLevel();
    
    private static final boolean isLogSevere = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.SEVERE.intValue();
    
    private static final boolean isLogWarning = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.WARNING.intValue();
    
    private static final boolean isLogInfo = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.INFO.intValue();
    
    private static final boolean isLogFine = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINE.intValue();
    
    private static final boolean isLogFiner = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINER.intValue();
    
    private static final boolean isLogFinest = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINEST.intValue();

    private static void logFine(String message,Object ... args){
        logger.log(Level.FINE, message, args);
    }
    
    private static void logFiner(String message,Object ... args){
        logger.log(Level.FINER, message, args);
    }
    
    private static void logFinest(String message,Object ... args){
        logger.log(Level.FINEST, message, args);
    }
    
    private static void logInfo(String message,Object ... args){
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        logger.log(Level.WARNING, message, args);
    }
    
    private static void logSevere(String message,Object ... args){
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        logger.log(Level.SEVERE, null, ex);
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="Конструкторы">
    /**
     * Значение по умолчанию = 0.
     */
    public IntCounter(){
        super();
        this.value = 0;
    }
    
    /**
     * Конструктор
     * @param cnt Начальное значение
     */
    public IntCounter(int cnt){
        super();
        this.value = cnt;
    }
    
    /**
     * Значение по умолчанию = 0.
     * @param lock Блокировка
     */
    public IntCounter(Lock lock){
        super(lock);
        this.value = 0;
    }
    
    /**
     * Конструктор
     * @param cnt начальное значение
     * @param lock блокировка
     */
    public IntCounter(int cnt,Lock lock){
        super(cnt,lock);
    }
    
    /**
     * Конструктор копирования
     * @param src образец для копирования
     */
    public IntCounter(IntCounter src){
        super(src);
        if( src==null ){
            value = 0;
        }
    }
    
    /**
     * Конструктор копирования
     * @param src образец для копирования
     * @param lock блокировка
     */
    public IntCounter(IntCounter src, Lock lock){
        super(src, lock);
        if( src==null ){
            value = 0;
        }
    }
//</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="clone()">
    /**
     * Создание клона
     * @return клон
     */
    @Override
    public IntCounter clone(){
        try{
            lock.lock();
            return new IntCounter(this);
        }finally{
            lock.unlock();
        }
    }
    
    /**
     * Создание клона
     * @param lock блокировка для клона
     * @return клон
     */
    @Override
    public IntCounter clone(Lock lock){
        try {
            this.lock.lock();
            return new IntCounter(this,lock);
        }
        finally {
            this.lock.unlock();
        }
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="getType()">
    /**
     * Возвращает тип значения счетчика
     * @return тип значения счетчик
     */
    @Override
    public Class<Integer> getType() {
        return Integer.class;
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="reset()">
    /**
     * Сброс счетчика
     */
    @Override
    public void reset() {
        try {
            lock.lock();
            value = 0;
        }
        finally {
            lock.unlock();
        }
    }
//</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="increment()">
    /**
     * Увеличивает счечик и возвращает его значение
     * @return значение (клон)
     */
    public IntCounter increment(){
        try {
            lock.lock();
            value++;
            return clone();
        }
        finally {
            lock.unlock();
        }
    }
    //</editor-fold>
}
