/*
 * The MIT License
 *
 * Copyright 2015 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.http.web;


import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.fs.UnixPath;

/**
 *
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class FollowLink {
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static void logFine(String message,Object ... args){
        Logger.getLogger(FollowLink.class.getName()).log(Level.FINE, message, args);
    }
    
    private static void logFiner(String message,Object ... args){
        Logger.getLogger(FollowLink.class.getName()).log(Level.FINER, message, args);
    }
    
    private static void logFinest(String message,Object ... args){
        Logger.getLogger(FollowLink.class.getName()).log(Level.FINEST, message, args);
    }
    
    private static void logInfo(String message,Object ... args){
        Logger.getLogger(FollowLink.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        Logger.getLogger(FollowLink.class.getName()).log(Level.WARNING, message, args);
    }
    
    private static void logSevere(String message,Object ... args){
        Logger.getLogger(FollowLink.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        Logger.getLogger(FollowLink.class.getName()).log(Level.SEVERE, null, ex);
    }
    //</editor-fold>

    /**
     * откуда ссылка - базовая ссылка
     */
    public final URL from;

    /**
     * ссылка - целевая ссылка
     */
    public final URL link;

    /**
     * атрибут href
     */
    public final String href;

    /**
     * текст ссылки
     */
    public final String text;

    /**
     * Атрибуты
     */
    public final Map<String,String> attributes;
    
    /**
     * Целевая ссылка начинается также как базовая
     */
    public final boolean linkStartAsFrom;
    
    /**
     * Ссылка на этот же хост
     */
    public final boolean sameHost;

    /**
     * Ссылка на этот же порт
     */
    public final boolean samePort;

    /**
     * Ссылка (путь) является дочерней по отношению к базовой
     */
    public final boolean isChildPath;

    public FollowLink(URL from, URL link,String href){
        this(from, link,null,null);
    }

    public FollowLink(URL from, URL link,String href,String text){
        this(from, link, href, text,null);
    }

    public FollowLink(URL from, URL link,String text,String href, Map<String,String> attrs){
        if( href==null )throw new IllegalArgumentException( "href==null" );
        if( link==null )throw new IllegalArgumentException( "link==null" );
        if( from==null )throw new IllegalArgumentException( "from==null" );
        this.link = link;
        this.from = from;
        this.href = href;
        this.text = text==null ? "" : text;
        this.attributes = attrs == null ? new LinkedHashMap<String, String>() : attrs;
        
        sameHost = link.getHost().equals(from.getHost());
        samePort = link.getPort() == from.getPort();
        linkStartAsFrom = link.toString().startsWith(from.toString());
        isChildPath = isChildPath(from, link);
    }

    protected static boolean isSiblingPath( URL parent, URL child ){
        String parentPathStr = parent.getPath();
        String childPathStr = child.getPath();
        
        if( parentPathStr!=null && parentPathStr.length()>0 &&
            childPathStr!=null && childPathStr.length()>0 ){
            
            UnixPath parentPath = new UnixPath(parentPathStr);
            parentPath = parentPath.getCanonical();
            
            UnixPath childPath = new UnixPath(childPathStr);
            childPath = childPath.getCanonical();
            
            if( parentPath.isAbsolute() && childPath.isAbsolute() ){
                if( parentPath.compareTo(childPath)==0 ){
//                    samelink = true;
                }else{
                    String[] parentComponents = parentPath.getComponents();
                    String[] childComponents = childPath.getComponents();
                    ArrayList<String> common = new ArrayList<String>();
                    
                    int minIdx = parentComponents.length > childComponents.length 
                        ? childComponents.length - 1
                        : parentComponents.length;
                    
                    for( int i=0; i<=minIdx; i++ ){
                        String c1 = parentComponents[i];
                        String c2 = childComponents[i];
                        if( c1.equals(c2) ){
                            common.add(c1);
                        }else{
                            break;
                        }
                    }
                    
                    if( common.size() < parentComponents.length && 
                        common.size() < childComponents.length ){
                            return true;
                    }
                }
            }
        }

        return false;
    }
    
    protected static boolean isChildPath( URL parent, URL child ){
        String parentPathStr = parent.getPath();
        String childPathStr = child.getPath();
        
        if( (parentPathStr==null || parentPathStr.length()==0) &&
            (childPathStr!=null && childPathStr.length()>0) ){
            return true;
        }
        
        if( parentPathStr!=null && parentPathStr.length()>0 &&
            childPathStr!=null && childPathStr.length()>0 ){
            
            UnixPath parentPath = new UnixPath(parentPathStr);
            parentPath = parentPath.getCanonical();
            
            UnixPath childPath = new UnixPath(childPathStr);
            childPath = childPath.getCanonical();
            
            if( parentPath.isAbsolute() && childPath.isAbsolute() ){
                if( parentPath.compareTo(childPath)==0 ){
//                    samelink = true;
                }else{
                    String[] parentComponents = parentPath.getComponents();
                    String[] childComponents = childPath.getComponents();
                    ArrayList<String> common = new ArrayList<String>();
                    
                    int minIdx = parentComponents.length > childComponents.length 
                        ? childComponents.length - 1
                        : parentComponents.length - 1;
                    
                    for( int i=0; i<=minIdx; i++ ){
                        String c1 = parentComponents[i];
                        String c2 = childComponents[i];
                        if( c1.equals(c2) ){
                            common.add(c1);
                        }else{
                            break;
                        }
                    }
                    
                    if( common.size() == parentComponents.length ){
                        if( childComponents.length > parentComponents.length ){
                            return true;
                        }
                    }
                }
            }
        }

        return false;
    }
}
