/*
 * The MIT License
 *
 * Copyright 2015 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.http.web;


import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.w3c.dom.NodeList;
import xyz.cofe.http.HttpResponse;
import xyz.cofe.xml.XMLUtil;

/**
 * Страница html
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class HtmlPage {
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static void logFine(String message,Object ... args){
        Logger.getLogger(HtmlPage.class.getName()).log(Level.FINE, message, args);
    }
    
    private static void logFiner(String message,Object ... args){
        Logger.getLogger(HtmlPage.class.getName()).log(Level.FINER, message, args);
    }
    
    private static void logFinest(String message,Object ... args){
        Logger.getLogger(HtmlPage.class.getName()).log(Level.FINEST, message, args);
    }
    
    private static void logInfo(String message,Object ... args){
        Logger.getLogger(HtmlPage.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        Logger.getLogger(HtmlPage.class.getName()).log(Level.WARNING, message, args);
    }
    
    private static void logSevere(String message,Object ... args){
        Logger.getLogger(HtmlPage.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        Logger.getLogger(HtmlPage.class.getName()).log(Level.SEVERE, null, ex);
    }
    //</editor-fold>

//    private final org.jsoup.nodes.Document jsoupDocument;
    
    public final URL url;
    public final String html;
    public final org.w3c.dom.Document document;

    public HtmlPage(String html,URL url){
        if( html==null )throw new IllegalArgumentException( "html==null" );
        if( url==null )throw new IllegalArgumentException( "url==null" );

        this.url = url;
        this.html = html;
        
        Document doc = Jsoup.parse(this.html);
        
        org.jsoup.helper.W3CDom w3cdom = new org.jsoup.helper.W3CDom();
        this.document = w3cdom.fromJsoup(doc);
    }

//    public HtmlPage(org.jsoup.nodes.Document document,URL url){
//        if( document==null )throw new IllegalArgumentException( "document==null" );
//        if( url==null )throw new IllegalArgumentException( "url==null" );
//
//        this.jsoupDocument = document;
//        this.url = url;
//
//        this.html = document.html();
//        
//        org.jsoup.helper.W3CDom w3cdom = new org.jsoup.helper.W3CDom();
//        this.document = w3cdom.fromJsoup(jsoupDocument);
//    }

    public HtmlPage(HttpResponse response){
        if( response==null )throw new IllegalArgumentException( "response==null" );

        this.url = response.getCurrentRequest().getUrl();
        this.html = response.getText();

        Document doc = Jsoup.parse(this.html);
//        this.jsoupDocument = doc;
        
        org.jsoup.helper.W3CDom w3cdom = new org.jsoup.helper.W3CDom();
        this.document = w3cdom.fromJsoup(doc);
    }

    /**
     * Возвращает список ссылок
     * @return ссылки
     */
    public List<FollowLink> getFollowLinks(){
        return getFollowLinks_xpath();
    }

    /**
     * Возвращает список ссылок
     * @return ссылки
     */
    private List<FollowLink> getFollowLinks_xpath(){
        List<FollowLink> links = new ArrayList<FollowLink>();
        NodeList nl = XMLUtil.xpathNodeSet("//a", document);
        
        if( nl!=null ){
            for( int i=0; i<nl.getLength(); i++ ){
                org.w3c.dom.Node n = nl.item(i);
                if( n instanceof org.w3c.dom.Element ){
                    org.w3c.dom.Element el = (org.w3c.dom.Element)n;
                    
                    String href = el.getAttribute("href");
                    String text = XMLUtil.getText(n);
                    Map<String,String> attrs = new LinkedHashMap<String, String>();
                    
                    org.w3c.dom.NamedNodeMap nnm = el.getAttributes();
                    if( nnm!=null ){
                        for( int ai=0; ai<nnm.getLength(); ai++ ){
                            org.w3c.dom.Node na = (org.w3c.dom.Node)nnm.item(ai);
                            if( na instanceof org.w3c.dom.Attr ){
                                org.w3c.dom.Attr attr = (org.w3c.dom.Attr)na;
                                String name = attr.getName();
                                String val = attr.getValue();
                                if( name!=null && val!=null ){
                                    attrs.put(name, val);
                                }
                            }
                        }
                    }
                    
                    if( href!=null ){
                        try {
                            // resolve href
                            URI baseAddr = url.toURI();
                            URI toAddr = baseAddr.resolve(href);
                            
                            FollowLink flink = new FollowLink(
                                url,
                                toAddr.toURL(),
                                text,
                                href,
                                attrs);
                            
                            links.add(flink);
                        } catch (URISyntaxException ex) {
                            Logger.getLogger(HtmlPage.class.getName()).log(Level.SEVERE, null, ex);
                        } catch (MalformedURLException ex) {
                            Logger.getLogger(HtmlPage.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            }
        }
        
        return links;
    }
    
//    /**
//     * Возвращает список ссылок
//     * @return ссылки
//     */
//    private List<FollowLink> getFollowLinks_jsoup(){
//        List<FollowLink> links = new ArrayList<FollowLink>();
//        
//        Elements els = jsoupDocument.getElementsByTag("a");
//
//        for( Element el : els ){
//            try {
//                String text = el.text();
//                String href = el.attr("href");
//
//                Map<String,String> attrs = new LinkedHashMap<String, String>();
//                for( Attribute attr : el.attributes() ){
//                    attrs.put(attr.getKey(),attr.getValue());
//                }
//
//                // resolve href
//                URI baseAddr = url.toURI();
//                URI toAddr = baseAddr.resolve(href);
//
//                FollowLink flink = new FollowLink(
//                    url,
//                    toAddr.toURL(), 
//                    text, 
//                    href, 
//                    attrs);
//
//                links.add(flink);
//            } catch (URISyntaxException ex) {
//                Logger.getLogger(HtmlPage.class.getName()).log(Level.SEVERE, null, ex);
//            } catch (MalformedURLException ex) {
//                Logger.getLogger(HtmlPage.class.getName()).log(Level.SEVERE, null, ex);
//            }
//        }
//
//        return links;
//    }
}
