/*
 * The MIT License
 *
 * Copyright 2015 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.http.web;


import java.net.URL;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Pair;

/**
 * Web ресурс
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class Resource {
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static void logFine(String message,Object ... args){
        Logger.getLogger(Resource.class.getName()).log(Level.FINE, message, args);
    }
    
    private static void logFiner(String message,Object ... args){
        Logger.getLogger(Resource.class.getName()).log(Level.FINER, message, args);
    }
    
    private static void logFinest(String message,Object ... args){
        Logger.getLogger(Resource.class.getName()).log(Level.FINEST, message, args);
    }
    
    private static void logInfo(String message,Object ... args){
        Logger.getLogger(Resource.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        Logger.getLogger(Resource.class.getName()).log(Level.WARNING, message, args);
    }
    
    private static void logSevere(String message,Object ... args){
        Logger.getLogger(Resource.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        Logger.getLogger(Resource.class.getName()).log(Level.SEVERE, null, ex);
    }
    //</editor-fold>

    public final Lock lock = new ReentrantLock();

    //<editor-fold defaultstate="collapsed" desc="url">
    private URL url = null;
    
    public URL getUrl() {
        try{
            lock.lock();
            return url;
        }finally{
            lock.unlock();
        }
    }
    
    public void setUrl(URL url) {
        try{
            lock.lock();
            this.url = url;
        }finally{
            lock.unlock();
        }
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="statusCode">
    private int statusCode = -2;
    
    public int getStatusCode() {
        try{
            lock.lock();
            return statusCode;
        }finally{
            lock.unlock();
        }
    }
    
    public void setStatusCode(int statusCode) {
        try{
            lock.lock();
            this.statusCode = statusCode;
        }finally{
            lock.unlock();
        }
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="statusMessage">
    private String statusMessage = null;
    
    public String getStatusMessage() {
        try{
            lock.lock();
            return statusMessage;
        }finally{
            lock.unlock();
        }
    }
    
    public void setStatusMessage(String statusMessage) {
        try{
            lock.lock();
            this.statusMessage = statusMessage;
        }finally{
            lock.unlock();
        }
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="contentType">
    private String contentType = null;
    
    public String getContentType() {
        try{
            lock.lock();
            return contentType;
        }finally{
            lock.unlock();
        }
    }
    
    public void setContentType(String contentType) {
        try{
            lock.lock();
            this.contentType = contentType;
        }finally{
            lock.unlock();
        }
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="contentLength">
    private long contentLength = -1;
    
    public long getContentLength() {
        try{
            lock.lock();
            return contentLength;
        }finally{
            lock.unlock();
        }
    }
    
    public void setContentLength(long contentLength) {
        try{
            lock.lock();
            this.contentLength = contentLength;
        }finally{
            lock.unlock();
        }
    }
//</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="redirects">
    private List<Pair<URL,URL>> redirects = null;
    
    public List<Pair<URL, URL>> getRedirects() {
        try{
            lock.lock();
            return redirects;
        }finally{
            lock.unlock();
        }
    }
    
    public void setRedirects(List<Pair<URL, URL>> redirects) {
        try{
            lock.lock();
            this.redirects = redirects;
        }finally{
            lock.unlock();
        }
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="lastRedirect">
    private URL lastRedirect = null;
    
    public URL getLastRedirect() {
        try{
            lock.lock();
            return lastRedirect;
        }finally{
            lock.unlock();
        }
    }
    
    public void setLastRedirect(URL lastRedirect) {
        try{
            lock.lock();
            this.lastRedirect = lastRedirect;
        }finally{
            lock.unlock();
        }
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="partialContentSupport">
    private boolean partialContentSupport = false;
    
    public boolean isPartialContentSupport() {
        try{
            lock.lock();
            return partialContentSupport;
        }finally{
            lock.unlock();
        }
    }
    
    public void setPartialContentSupport(boolean partialContentSupport) {
        try{
            lock.lock();
            this.partialContentSupport = partialContentSupport;
        }finally{
            lock.unlock();
        }
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="htmlPage">
    private HtmlPage htmlPage = null;
    
    public HtmlPage getHtmlPage() {
        try{
            lock.lock();
            return htmlPage;
        }finally{
            lock.unlock();
        }
    }
    
    public void setHtmlPage(HtmlPage htmlPage) {
        try{
            lock.lock();
            this.htmlPage = htmlPage;
        }finally{
            lock.unlock();
        }
    }
//</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="currentUrl">
    public URL getCurrentUrl(){
        URL u = getUrl();
        URL lu = getLastRedirect();
        List<Pair<URL,URL>> lr = getRedirects();
        if( lr!=null && !lr.isEmpty() ){
            return lr.get(lr.size()-1).B();
        }
        if( lu!=null ){
            return lu;
        }
        return u;
    }
//</editor-fold>

    public Resource(){
//        children = Collections.synchronizedList(new ArrayList<Resource>());
    }
}
