/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.common;

import java.io.Closeable;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func2;
import xyz.cofe.common.ImmutableFragment;
import xyz.cofe.common.ListenersHelper;
import xyz.cofe.xml.XmlCoder;

public class Fragment
extends ImmutableFragment {
    protected ListenersHelper<Listener, Event> listeners = null;
    protected Lock lock = null;
    protected Lock listenerLock = null;
    protected Queue<Event> eventQu = new LinkedBlockingQueue<Event>();
    protected final AtomicBoolean syncFirePropertyListeners = new AtomicBoolean(true);

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(Fragment.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(Fragment.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(Fragment.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(Fragment.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(Fragment.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(Fragment.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(Fragment.class.getName()).log(Level.SEVERE, null, ex);
    }

    protected ListenersHelper<Listener, Event> listeners() {
        if (this.listeners != null) {
            return this.listeners;
        }
        this.listeners = new ListenersHelper((Func2)new Func2<Object, Listener, Event>(){

            public Object apply(Listener lst, Event e) {
                lst.fragmentEvent(e);
                return null;
            }
        }, this.listenerLock);
        return this.listeners;
    }

    public Set<Listener> getListeners() {
        return this.listeners().getListeners();
    }

    public Closeable addListener(Listener listener) {
        return this.listeners().addListener((Object)listener);
    }

    public Closeable addListener(Listener listener, boolean weakLink) {
        return this.listeners().addListener((Object)listener, weakLink);
    }

    public void removeListener(Listener listener) {
        this.listeners().removeListener((Object)listener);
    }

    public void fireEvent(Event event) {
        this.listeners().fireEvent((Object)event);
    }

    public Fragment(long begin, long end, Lock lock) {
        this.lock = lock;
        this.listenerLock = lock;
        this.init(begin, end);
    }

    public Fragment(long begin, long end) {
        this.listenerLock = this.lock = this.createLock();
        this.init(begin, end);
    }

    public Fragment(Fragment source) {
        this.listenerLock = this.lock = this.createLock();
        this.init(source);
    }

    protected Lock createLock() {
        return new ReentrantLock();
    }

    @Override
    public Fragment clone() {
        return new Fragment(this);
    }

    protected void fireEventQu() {
        Event e;
        while ((e = this.eventQu.poll()) != null) {
            this.fireEvent(e);
        }
    }

    protected void syncUpdateProperties(Runnable code) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        try {
            this.syncFirePropertyListeners.set(false);
            code.run();
        }
        finally {
            this.syncFirePropertyListeners.set(true);
        }
        this.fireEventQu();
    }

    public void setBegin(final long begin) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Fragment.this.begin = begin;
            }
        };
        this.syncUpdateProperties(r);
    }

    public void setEnd(final long end) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Fragment.this.end = end;
            }
        };
        this.syncUpdateProperties(r);
    }

    public void setRange(final long begin, final long end) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                long e = end;
                long b = begin;
                if (e < b) {
                    long t = b;
                    b = e;
                    e = t;
                }
                Fragment.this.begin = b;
                Fragment.this.end = e;
            }
        };
        this.syncUpdateProperties(r);
    }

    @XmlCoder.Ignore
    public void setSize(final long newSize) {
        if (newSize < 0L) {
            throw new IllegalArgumentException("newsize<0");
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                long e;
                long b = Fragment.this.getBegin();
                Fragment.this.end = e = b + newSize;
            }
        };
        this.syncUpdateProperties(r);
    }

    @Override
    public Fragment union(ImmutableFragment fragment) {
        ImmutableFragment f = super.union(fragment);
        if (f instanceof Fragment) {
            return (Fragment)f;
        }
        return new Fragment(f.getBegin(), f.getEnd());
    }

    public static interface Listener {
        public void fragmentEvent(Event var1);
    }

    public class Event {
        protected Fragment source = null;

        public Event(Fragment source) {
            this.source = source;
        }

        public Fragment getSource() {
            return this.source;
        }
    }
}

