/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.common;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.Predicate;
import xyz.cofe.collection.list.IndexEventList;
import xyz.cofe.common.Fragment;
import xyz.cofe.common.ImmutableFragment;
import xyz.cofe.common.ListenersHelper;

public class Fragments
implements Iterable<Fragment>,
List<Fragment> {
    protected final Lock lock;
    protected final Lock listenersLock;
    protected ListenersHelper<Listener, Event> listeners = null;
    protected Queue<Event> eventQu = new LinkedBlockingQueue<Event>();
    protected final AtomicBoolean syncFireListeners = new AtomicBoolean(true);
    private IndexEventList<Fragment> fragments = null;
    protected static final Comparator<Fragment> sorterByBegin = new Comparator<Fragment>(){

        @Override
        public int compare(Fragment o1, Fragment o2) {
            long l2;
            long l1 = o1.getBegin();
            return l1 == (l2 = o2.getBegin()) ? 0 : (l1 < l2 ? -1 : 1);
        }
    };
    protected static final Comparator<Fragment> sorterBySize = new Comparator<Fragment>(){

        @Override
        public int compare(Fragment o1, Fragment o2) {
            long s2;
            long s1 = o1.getSize();
            return s1 == (s2 = o2.getSize()) ? 0 : (s1 < s2 ? -1 : 1);
        }
    };
    protected static final Comparator<Fragment> sorterByInstanceID = new Comparator<Fragment>(){

        @Override
        public int compare(Fragment o1, Fragment o2) {
            long s1 = o1.instanceID;
            long s2 = o2.instanceID;
            return s1 == s2 ? 0 : (s1 < s2 ? -1 : 1);
        }
    };
    protected static final Comparator<Fragment> defSorter = new Comparator<Fragment>(){

        @Override
        public int compare(Fragment o1, Fragment o2) {
            int cBegin = sorterByBegin.compare(o1, o2);
            int cSize = sorterBySize.compare(o1, o2);
            int cID = sorterByInstanceID.compare(o1, o2);
            int cmp = cBegin * 10 + cSize * 5 + cID;
            return cmp;
        }
    };
    protected Func2<Fragment, Long, Long> defCreateFragment = new Func2<Fragment, Long, Long>(){

        public Fragment apply(Long begin, Long end) {
            return Fragments.this.createFagment(begin, end);
        }
    };
    public final Func2<List<Fragment>, Fragment, Fragment> unionIntersecResolver = new Func2<List<Fragment>, Fragment, Fragment>(){

        public List<Fragment> apply(Fragment f1, Fragment f2) {
            if (f1 == null) {
                throw new IllegalArgumentException("f1==null");
            }
            if (f2 == null) {
                throw new IllegalArgumentException("f2==null");
            }
            if (!f1.hasIntersection(f2)) {
                throw new IllegalArgumentException("no intersection");
            }
            ArrayList<Fragment> fs = new ArrayList<Fragment>();
            Fragment fu = f1.union(f2);
            fs.add(fu);
            return fs;
        }
    };
    protected final Func2<List<Fragment>, Fragment, Fragment> defIntersecResolver = this.unionIntersecResolver;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(Fragments.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(Fragments.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(Fragments.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(Fragments.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(Fragments.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(Fragments.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(Fragments.class.getName()).log(Level.SEVERE, null, ex);
    }

    public Fragments() {
        this.lock = null;
        this.listenersLock = null;
    }

    public Fragments(Lock lock, Lock listenersLock) {
        this.lock = lock;
        this.listenersLock = listenersLock;
    }

    public Fragments(Iterable<Fragment> source) {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        this.lock = null;
        this.listenersLock = null;
        for (Fragment f : source) {
            if (f == null) continue;
            this.getFragments().add(f);
        }
    }

    public Fragments(Iterable<Fragment> source, Lock lock, Lock listenersLock) {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        this.lock = lock;
        this.listenersLock = listenersLock;
        for (Fragment f : source) {
            if (f == null) continue;
            this.getFragments().add(f);
        }
    }

    public Fragments(Fragments source, Lock lock, Lock listenersLock) {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        this.lock = lock;
        this.listenersLock = listenersLock;
        for (Fragment f : source) {
            if (f == null) continue;
            this.getFragments().add(f.clone());
        }
    }

    public Fragments clone() {
        return new Fragments(this, this.lock, this.listenersLock);
    }

    public Lock getLock() {
        return this.lock;
    }

    protected ListenersHelper<Listener, Event> listeners() {
        if (this.listeners != null) {
            return this.listeners;
        }
        this.listeners = new ListenersHelper((Func2)new Func2<Object, Listener, Event>(){

            public Object apply(Listener lst, Event e) {
                lst.fragmentEvent(e);
                return null;
            }
        }, this.listenersLock);
        return this.listeners;
    }

    public Set<Listener> getListeners() {
        return this.listeners().getListeners();
    }

    public Closeable addListener(Listener listener) {
        return this.listeners().addListener((Object)listener);
    }

    public Closeable addListener(Listener listener, boolean weakLink) {
        return this.listeners().addListener((Object)listener, weakLink);
    }

    public void removeListener(Listener listener) {
        this.listeners().removeListener((Object)listener);
    }

    public void fireEvent(Event event) {
        this.listeners().fireEvent((Object)event);
    }

    protected void fireEventQu() {
        this.fireEventQu0();
    }

    private void fireEventQu0() {
        Event e;
        while ((e = this.eventQu.poll()) != null) {
            this.fireEvent(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T syncRun(Func0<T> code) {
        Object res;
        block8: {
            if (code == null) {
                throw new IllegalArgumentException("code==null");
            }
            res = null;
            try {
                this.syncFireListeners.set(false);
                if (this.lock != null) {
                    this.lock.lock();
                    try {
                        res = code.apply();
                        break block8;
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                res = code.apply();
            }
            finally {
                this.syncFireListeners.set(true);
            }
        }
        this.fireEventQu();
        return (T)res;
    }

    private final List<Fragment> getFragments() {
        if (this.fragments != null) {
            return this.fragments;
        }
        if (this.lock != null) {
            this.lock.lock();
            try {
                IndexEventList evList;
                ArrayList lfragments = new ArrayList();
                this.fragments = evList = new IndexEventList(lfragments);
            }
            finally {
                this.lock.unlock();
            }
        } else {
            IndexEventList evList;
            ArrayList lfragments = new ArrayList();
            this.fragments = evList = new IndexEventList(lfragments);
        }
        return this.fragments;
    }

    @Override
    public Iterator<Fragment> iterator() {
        ArrayList<Fragment> l = new ArrayList<Fragment>();
        if (this.lock != null) {
            this.lock.lock();
            try {
                l.addAll(this.getFragments());
            }
            finally {
                this.lock.unlock();
            }
        } else {
            l.addAll(this.getFragments());
        }
        return l.iterator();
    }

    @Override
    public ListIterator<Fragment> listIterator() {
        return this.syncRun(new Func0<ListIterator<Fragment>>(){

            public ListIterator<Fragment> apply() {
                return Fragments.this.getFragments().listIterator();
            }
        });
    }

    @Override
    public ListIterator<Fragment> listIterator(final int index) {
        return this.syncRun(new Func0<ListIterator<Fragment>>(){

            public ListIterator<Fragment> apply() {
                return Fragments.this.getFragments().listIterator(index);
            }
        });
    }

    @Override
    public int indexOf(final Object o) {
        return this.syncRun(new Func0<Integer>(){

            public Integer apply() {
                return Fragments.this.getFragments().indexOf(o);
            }
        });
    }

    @Override
    public List<Fragment> subList(final int fromIndex, final int toIndexExclusive) {
        return this.syncRun(new Func0<List<Fragment>>(){

            public List<Fragment> apply() {
                return Fragments.this.getFragments().subList(fromIndex, toIndexExclusive);
            }
        });
    }

    @Override
    public boolean add(final Fragment e) {
        return this.syncRun(new Func0<Boolean>(){

            public Boolean apply() {
                return Fragments.this.getFragments().add(e);
            }
        });
    }

    @Override
    public boolean remove(final Object o) {
        return this.syncRun(new Func0<Boolean>(){

            public Boolean apply() {
                return Fragments.this.getFragments().remove(o);
            }
        });
    }

    @Override
    public void add(final int index, final Fragment element) {
        this.syncRun(new Func0<Object>(){

            public Integer apply() {
                Fragments.this.getFragments().add(index, element);
                return null;
            }
        });
    }

    @Override
    public boolean addAll(final Collection<? extends Fragment> c) {
        return this.syncRun(new Func0<Boolean>(){

            public Boolean apply() {
                return Fragments.this.getFragments().addAll(c);
            }
        });
    }

    @Override
    public boolean addAll(final int index, final Collection<? extends Fragment> c) {
        return this.syncRun(new Func0<Boolean>(){

            public Boolean apply() {
                return Fragments.this.getFragments().addAll(index, c);
            }
        });
    }

    @Override
    public void clear() {
        this.syncRun(new Func0<Integer>(){

            public Integer apply() {
                Fragments.this.getFragments().clear();
                return -1;
            }
        });
    }

    @Override
    public Fragment remove(final int index) {
        return this.syncRun(new Func0<Fragment>(){

            public Fragment apply() {
                return (Fragment)Fragments.this.getFragments().remove(index);
            }
        });
    }

    @Override
    public boolean removeAll(final Collection<?> c) {
        return this.syncRun(new Func0<Boolean>(){

            public Boolean apply() {
                return Fragments.this.getFragments().removeAll(c);
            }
        });
    }

    @Override
    public boolean retainAll(final Collection<?> c) {
        return this.syncRun(new Func0<Boolean>(){

            public Boolean apply() {
                return Fragments.this.getFragments().retainAll(c);
            }
        });
    }

    @Override
    public Fragment set(final int index, final Fragment element) {
        return this.syncRun(new Func0<Fragment>(){

            public Fragment apply() {
                return Fragments.this.getFragments().set(index, element);
            }
        });
    }

    @Override
    public boolean contains(final Object o) {
        return this.syncRun(new Func0<Boolean>(){

            public Boolean apply() {
                return Fragments.this.getFragments().contains(o);
            }
        });
    }

    @Override
    public boolean containsAll(final Collection<?> c) {
        return this.syncRun(new Func0<Boolean>(){

            public Boolean apply() {
                return Fragments.this.getFragments().containsAll(c);
            }
        });
    }

    @Override
    public Fragment get(final int index) {
        return this.syncRun(new Func0<Fragment>(){

            public Fragment apply() {
                return (Fragment)Fragments.this.getFragments().get(index);
            }
        });
    }

    @Override
    public boolean isEmpty() {
        return this.syncRun(new Func0<Boolean>(){

            public Boolean apply() {
                return Fragments.this.getFragments().isEmpty();
            }
        });
    }

    @Override
    public int lastIndexOf(final Object o) {
        return this.syncRun(new Func0<Integer>(){

            public Integer apply() {
                return Fragments.this.getFragments().lastIndexOf(o);
            }
        });
    }

    @Override
    public int size() {
        return this.syncRun(new Func0<Integer>(){

            public Integer apply() {
                return Fragments.this.getFragments().size();
            }
        });
    }

    @Override
    public Object[] toArray() {
        return this.syncRun(new Func0<Object[]>(){

            public Object[] apply() {
                return Fragments.this.getFragments().toArray();
            }
        });
    }

    @Override
    public <T> T[] toArray(T[] a) {
        final Object[] b = a;
        T[] res = this.syncRun(new Func0<T[]>(){

            public T[] apply() {
                return Fragments.this.getFragments().toArray(b);
            }
        });
        return res;
    }

    public void removeSameRange(final Fragment fragment) {
        this.syncRun(new Func0(){

            public Object apply() {
                if (fragment == null) {
                    throw new IllegalArgumentException("fragment==null");
                }
                for (Fragment f : Fragments.this) {
                    if (!f.equalsRange(fragment)) continue;
                    Fragments.this.remove(f);
                }
                return null;
            }
        });
    }

    public String toString() {
        return (String)this.syncRun(new Func0(){

            public Object apply() {
                StringBuilder s = new StringBuilder();
                int i = -1;
                for (Fragment f : Fragments.this) {
                    s.append(++i).append(". ").append(f.toString()).append("\n");
                }
                return s.toString();
            }
        });
    }

    public static Predicate<Fragment> sizeEqualsPredicate(final long size) {
        return new Predicate<Fragment>(){

            public boolean validate(Fragment f) {
                return f != null && f.getSize() == size;
            }
        };
    }

    public static Predicate<Fragment> rangePredicate(final long begin, final long end) {
        return new Predicate<Fragment>(){
            protected ImmutableFragment r;
            {
                this.r = new ImmutableFragment(begin, end);
            }

            public boolean validate(Fragment f) {
                return f != null && f.equalsRange(this.r);
            }
        };
    }

    public List<Fragment> find(final Predicate<Fragment> p) {
        return (List)this.syncRun(new Func0(){

            public Object apply() {
                ArrayList<Fragment> l = new ArrayList<Fragment>();
                for (Fragment f : Fragments.this) {
                    if (!p.validate((Object)f)) continue;
                    l.add(f);
                }
                return l;
            }
        });
    }

    public void sort() {
        this.syncRun(new Func0(){

            public Object apply() {
                Collections.sort(Fragments.this.getFragments(), defSorter);
                return null;
            }
        });
    }

    public List<Fragment> findZeroSize() {
        return this.find(Fragments.sizeEqualsPredicate(0L));
    }

    protected Fragment createFagment(long begin, long end) {
        return new Fragment(begin, end);
    }

    protected boolean isEquals(Fragment f1, Fragment f2) {
        if (f1 == null) {
            throw new IllegalArgumentException("f1==null");
        }
        if (f2 == null) {
            throw new IllegalArgumentException("f2==null");
        }
        return f1.equals(f2);
    }

    public void visitEachEachWithoutPosition(final Func2<Object, Fragment, Fragment> visitor, final Func2<Boolean, Fragment, Fragment> equals) {
        this.syncRun(new Func0(){

            public Object apply() {
                if (visitor == null) {
                    throw new IllegalArgumentException("visitor==null");
                }
                if (equals == null) {
                    throw new IllegalArgumentException("equals==null");
                }
                Fragments fs = new Fragments(Fragments.this);
                for (Fragment f1 : Fragments.this) {
                    for (Fragment f2 : fs) {
                        boolean eq = (Boolean)equals.apply((Object)f1, (Object)f2);
                        if (eq) continue;
                        visitor.apply((Object)f1, (Object)f2);
                    }
                    fs.remove(f1);
                }
                return null;
            }
        });
    }

    public Map<Fragment, Set<Fragment>> findIntersections() {
        return (Map)this.syncRun(new Func0(){

            public Object apply() {
                final LinkedHashMap m = new LinkedHashMap();
                Fragments.this.visitEachEachWithoutPosition(new Func2<Object, Fragment, Fragment>(){

                    public Object apply(Fragment f1, Fragment f2) {
                        if (f1.hasIntersection(f2)) {
                            LinkedHashSet<Fragment> s = (LinkedHashSet<Fragment>)m.get(f1);
                            if (s == null) {
                                s = new LinkedHashSet<Fragment>();
                                m.put(f1, s);
                            }
                            s.add(f2);
                        }
                        return null;
                    }
                }, new Func2<Boolean, Fragment, Fragment>(){

                    public Boolean apply(Fragment arg1, Fragment arg2) {
                        return Fragments.this.isEquals(arg1, arg2);
                    }
                });
                return m;
            }
        });
    }

    public List<Fragment> findHoles(long begin, long end) {
        return this.findHoles(begin, end, this.defCreateFragment);
    }

    public List<Fragment> findHoles(final long fbegin, final long fend, final Func2<Fragment, Long, Long> fcreateFragment) {
        return (List)this.syncRun(new Func0(){

            public Object apply() {
                Func2<Fragment, Long, Long> createFragment = fcreateFragment == null ? Fragments.this.defCreateFragment : fcreateFragment;
                long begin = fbegin;
                long end = fend;
                if (begin > end) {
                    long t = begin;
                    begin = end;
                    end = t;
                }
                ArrayList<Fragment> holes = new ArrayList<Fragment>();
                long ptr = begin;
                Fragments fragments = new Fragments(Fragments.this);
                fragments.removeAll(fragments.findZeroSize());
                fragments.sort();
                int i = -1;
                int count = fragments.size();
                for (Fragment f : fragments) {
                    Fragment fHole;
                    boolean last = ++i == count - 1;
                    long b = f.getBegin();
                    long e = f.getEnd();
                    if (!last) {
                        if (ptr < b) {
                            fHole = (Fragment)createFragment.apply((Object)ptr, (Object)b);
                            holes.add(fHole);
                            ptr = e;
                            continue;
                        }
                        ptr = e;
                        continue;
                    }
                    if (ptr < b) {
                        fHole = (Fragment)createFragment.apply((Object)ptr, (Object)b);
                        holes.add(fHole);
                        ptr = e;
                    } else {
                        ptr = e;
                    }
                    if (ptr >= end) continue;
                    fHole = (Fragment)createFragment.apply((Object)ptr, (Object)end);
                    holes.add(fHole);
                }
                return holes;
            }
        });
    }

    public void removeIntersections() {
        this.removeIntersections(this.defIntersecResolver);
    }

    public void removeIntersections(final Func2<List<Fragment>, Fragment, Fragment> fintersecResolver) {
        this.syncRun(new Func0(){

            /*
             * Exception decompiling
             */
            public Object apply() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[DOLOOP]], but top level block is 2[UNCONDITIONALDOLOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
    }

    public class Event {
        protected Fragments source = null;

        public Event(Fragments source) {
            this.source = source;
        }

        public Fragments getSource() {
            return this.source;
        }
    }

    public static interface Listener {
        public void fragmentEvent(Event var1);
    }
}

