/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.common;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import xyz.cofe.collection.Predicate;
import xyz.cofe.common.Fragment;
import xyz.cofe.common.Fragments;
import xyz.cofe.typeconv.BaseCastGraph;
import xyz.cofe.typeconv.TypeCastGraph;
import xyz.cofe.xml.FormatXMLWriter;
import xyz.cofe.xml.XMLUtil;

public class FragmentsXmlDom {
    private static void logFine(String message, Object ... args) {
        Logger.getLogger(FragmentsXmlDom.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(FragmentsXmlDom.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(FragmentsXmlDom.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(FragmentsXmlDom.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(FragmentsXmlDom.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(FragmentsXmlDom.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(FragmentsXmlDom.class.getName()).log(Level.SEVERE, null, ex);
    }

    protected Store createStore(Document doc) {
        if (doc == null) {
            throw new IllegalArgumentException("doc==null");
        }
        return new Store(doc);
    }

    protected Restore createRestore() {
        return new Restore();
    }

    public void write(Writer writer, Fragments fragments) throws IOException {
        try {
            if (writer == null) {
                throw new IllegalArgumentException("writer==null");
            }
            if (fragments == null) {
                throw new IllegalArgumentException("fragments==null");
            }
            Document doc = XMLUtil.createDocument();
            Store store = this.createStore(doc);
            Element el = store.createElementOf(fragments);
            doc.appendChild(el);
            FormatXMLWriter fxmlwr = new FormatXMLWriter(writer);
            fxmlwr.setWriteOutline(true);
            XMLUtil.write((XMLStreamWriter)fxmlwr, (Node)doc);
            fxmlwr.flush();
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(FragmentsXmlDom.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Element xmlElementOf(Fragments fragments) throws IOException {
        if (fragments == null) {
            throw new IllegalArgumentException("fragments==null");
        }
        return this.xmlElementOf(fragments, null);
    }

    public Element xmlElementOf(Fragments fragments, Document doc) throws IOException {
        if (fragments == null) {
            throw new IllegalArgumentException("fragments==null");
        }
        doc = doc == null ? XMLUtil.createDocument() : doc;
        Store store = this.createStore(doc);
        Element el = store.createElementOf(fragments);
        return el;
    }

    public Fragments readFragments(Reader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException("reader==null");
        }
        try {
            Document doc = XMLUtil.parseXML((Reader)reader);
            NodeList nl = doc.getElementsByTagName("fragments");
            if (nl == null || nl.getLength() == 0) {
                return null;
            }
            Node n = nl.item(0);
            if (!(n instanceof Element)) {
                return null;
            }
            Element el = (Element)n;
            Restore restore = this.createRestore();
            return restore.createFragmentsFrom(el);
        }
        catch (SAXException ex) {
            Logger.getLogger(FragmentsXmlDom.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Fragments readFragments(Node n) throws IOException {
        if (!(n instanceof Element)) {
            return null;
        }
        Element el = (Element)n;
        Restore restore = this.createRestore();
        return restore.createFragmentsFrom(el);
    }

    public Fragments readFragments(Element el) throws IOException {
        if (el == null) {
            throw new IllegalArgumentException("el==null");
        }
        Restore restore = this.createRestore();
        return restore.createFragmentsFrom(el);
    }

    public static class Restore {
        protected TypeCastGraph typeCast = new BaseCastGraph();

        public Restore() {
        }

        public Restore(TypeCastGraph typeCast) {
            if (typeCast == null) {
                throw new IllegalArgumentException("typeCast==null");
            }
            this.typeCast = typeCast;
        }

        public Fragments createFragmentsFrom(Element fragmentsElement) {
            if (fragmentsElement == null) {
                throw new IllegalArgumentException("fragmentsElement==null");
            }
            String javaType = fragmentsElement.getAttribute("javaType");
            Fragments fragments = this.createFragments(javaType);
            for (Element fragmentEl : XMLUtil.elements((Node)fragmentsElement, (Predicate)XMLUtil.Predicates.nodeName((String)"fragment", (boolean)true))) {
                Fragment f;
                if (fragmentEl == null || (f = this.createFragmentFrom(fragmentEl)) == null) continue;
                fragments.add(f);
            }
            return fragments;
        }

        protected Fragments createFragments(String javaType) {
            return new Fragments();
        }

        public Fragment createFragmentFrom(Element fragmentElement) {
            if (fragmentElement == null) {
                throw new IllegalArgumentException("fragmentElement==null");
            }
            String javaType = fragmentElement.getAttribute("javaType");
            String beginStr = fragmentElement.getAttribute("begin");
            if (beginStr == null || beginStr.length() == 0) {
                return null;
            }
            String endStr = fragmentElement.getAttribute("end");
            if (endStr == null || endStr.length() == 0) {
                return null;
            }
            Fragment fragment = this.createFragment(javaType, (Long)this.typeCast.cast((Object)beginStr, Long.class), (Long)this.typeCast.cast((Object)endStr, Long.class));
            if (fragment == null) {
                return null;
            }
            for (Element propertiesEl : XMLUtil.elements((Node)fragmentElement, (Predicate)XMLUtil.Predicates.nodeName((String)"properties", (boolean)true))) {
                if (propertiesEl == null) continue;
                for (Element propertyEl : XMLUtil.elements((Node)propertiesEl, (Predicate)XMLUtil.Predicates.nodeName((String)"property", (boolean)true))) {
                    if (propertyEl == null) continue;
                    String propName = propertyEl.getAttribute("name");
                    String valueStr = propertyEl.getAttribute("value");
                    String valueType = propertyEl.getAttribute("valueType");
                    if ((propName == null || valueStr != null || valueType != null || propName.length() <= 0) && propName != null && valueStr != null && valueType != null && valueStr.length() > 0 && valueType.length() > 0 && propName.length() <= 0) continue;
                }
            }
            return fragment;
        }

        protected Fragment createFragment(String javaType, long begin, long end) {
            return new Fragment(begin, end);
        }
    }

    public static class Store {
        protected Document xdoc = null;
        protected TypeCastGraph typeCast = new BaseCastGraph();

        public Store(TypeCastGraph typeCast, Document xdoc) {
            if (xdoc == null) {
                throw new IllegalArgumentException("xdoc==null");
            }
            if (typeCast == null) {
                throw new IllegalArgumentException("typeCast==null");
            }
            this.xdoc = xdoc;
            this.typeCast = typeCast;
        }

        public Store(Document xdoc) {
            if (xdoc == null) {
                throw new IllegalArgumentException("xdoc==null");
            }
            this.xdoc = xdoc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Element createElementOf(Fragments fragments) {
            if (fragments == null) {
                throw new IllegalArgumentException("fragments==null");
            }
            if (this.xdoc == null) {
                throw new IllegalArgumentException("xdoc==null");
            }
            Lock lock = fragments.getLock();
            if (lock != null) {
                lock.lock();
                try {
                    Element element = this.createElementOf0(fragments);
                    return element;
                }
                finally {
                    return this.createElementOf0(fragments);
                }
            }
            return this.createElementOf0(fragments);
        }

        private Element createElementOf0(Fragments fragments) {
            Element fragmentsEl = this.xdoc.createElement("fragments");
            fragmentsEl.setAttribute("javaType", fragments.getClass().getName());
            for (Fragment f : fragments) {
                Element el;
                if (f == null || (el = this.createElementOf(f)) == null) continue;
                fragmentsEl.appendChild(el);
            }
            return fragmentsEl;
        }

        public Element createElementOf(Fragment fragment) {
            if (fragment == null) {
                throw new IllegalArgumentException("fragment==null");
            }
            if (this.xdoc == null) {
                throw new IllegalArgumentException("xdoc==null");
            }
            Element fragmentEl = this.xdoc.createElement("fragment");
            fragmentEl.setAttribute("javaType", fragment.getClass().getName());
            fragmentEl.setAttribute("begin", (String)this.typeCast.cast((Object)fragment.getBegin(), String.class));
            fragmentEl.setAttribute("end", (String)this.typeCast.cast((Object)fragment.getEnd(), String.class));
            Element propertiesEl = this.xdoc.createElement("properties");
            fragmentEl.appendChild(propertiesEl);
            return fragmentEl;
        }
    }
}

