/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cbuffer.ContentBuffer;
import xyz.cofe.common.ImmutableFragment;
import xyz.cofe.text.Text;

public class Hash {
    protected final Lock lock;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(Hash.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(Hash.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(Hash.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(Hash.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(Hash.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(Hash.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(Hash.class.getName()).log(Level.SEVERE, null, ex);
    }

    public Hash() {
        this.lock = new ReentrantLock();
    }

    public Hash(Lock lock) {
        if (lock == null) {
            throw new IllegalArgumentException("lock==null");
        }
        this.lock = lock;
    }

    public Lock getLock() {
        return this.lock;
    }

    public byte[] toBytes(String hash) {
        if (hash == null) {
            throw new IllegalArgumentException("hash==null");
        }
        return Text.decodeHex((String)hash);
    }

    public String toString(byte[] hash) {
        if (hash == null) {
            throw new IllegalArgumentException("hash==null");
        }
        return Text.encodeHex((byte[])hash);
    }

    public boolean isEquals(byte[] hash1, byte[] hash2) {
        if (hash1 == null) {
            throw new IllegalArgumentException("hash1==null");
        }
        if (hash2 == null) {
            throw new IllegalArgumentException("hash2==null");
        }
        if (hash1.length != hash2.length) {
            return false;
        }
        for (int i = 0; i < hash1.length; ++i) {
            if (hash1[i] == hash2[i]) continue;
            return false;
        }
        return true;
    }

    public byte[] sha1(InputStream data, long beginIndex, long endIndex, int buffsize) throws IOException {
        return this.hash("SHA-1", data, beginIndex, endIndex, buffsize);
    }

    public byte[] sha1(ContentBuffer buffer, ImmutableFragment fragment, int blockSize) {
        return this.sha1(buffer, fragment.getBegin(), fragment.getEnd(), blockSize);
    }

    public byte[] sha1(ContentBuffer buffer, long beginIndex, long endIndex, int buffsize) {
        return this.hash("SHA-1", buffer, beginIndex, endIndex, buffsize);
    }

    public byte[] sha1(File buffer, int buffsize) {
        try {
            return this.hash("SHA-1", buffer, buffsize);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public byte[] sha1(File buffer) {
        try {
            return this.hash("SHA-1", buffer);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public byte[] sha1(byte[] data, int beginIndex, int endIndex) {
        return this.hash("SHA-1", data, beginIndex, endIndex);
    }

    public byte[] sha1(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        return this.hash("SHA-1", data, 0, data.length);
    }

    public byte[] md5(ContentBuffer buffer, ImmutableFragment fragment, int blockSize) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer==null");
        }
        if (fragment == null) {
            throw new IllegalArgumentException("fragment==null");
        }
        if (blockSize <= 0) {
            throw new IllegalArgumentException("blockSize <= 0");
        }
        return this.md5(buffer, fragment.getBegin(), fragment.getEnd(), blockSize);
    }

    public byte[] md5(ContentBuffer buffer, long beginIndex, long endIndex, int buffsize) {
        return this.hash("MD5", buffer, beginIndex, endIndex, buffsize);
    }

    public byte[] md5(InputStream data, long beginIndex, long endIndex, int buffsize) throws IOException {
        return this.hash("MD5", data, beginIndex, endIndex, buffsize);
    }

    public byte[] md5(byte[] data, int beginIndex, int endIndex) {
        return this.hash("MD5", data, beginIndex, endIndex);
    }

    public byte[] md5(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        return this.hash("MD5", data, 0, data.length);
    }

    public byte[] md5(File data, int buffsize) {
        try {
            return this.hash("MD5", data, buffsize);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public byte[] md5(File data) {
        try {
            return this.hash("MD5", data);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] hash(String alg, ContentBuffer buffer, long beginIndex, long endIndex, int buffsize) {
        this.lock.lock();
        try {
            MessageDigest md;
            if (alg == null) {
                throw new IllegalArgumentException("alg==null");
            }
            if (buffer == null) {
                throw new IllegalArgumentException("buffer==null");
            }
            if (beginIndex < 0L) {
                throw new IllegalArgumentException("beginIndex<0");
            }
            if (endIndex < beginIndex) {
                throw new IllegalArgumentException("endIndex<beginIndex");
            }
            if (buffsize <= 0) {
                throw new IllegalArgumentException("buffsize<=0");
            }
            try {
                md = MessageDigest.getInstance(alg);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new Error("NoSuchAlgorithmException " + alg, ex);
            }
            md.reset();
            long count = endIndex - beginIndex;
            long ptr = beginIndex;
            byte[] buff = null;
            for (long totReaded = 0L; totReaded < count; totReaded += (long)buff.length) {
                long diff = count - totReaded;
                int readsize = -1;
                readsize = diff >= (long)buffsize ? buffsize : (int)diff;
                buff = buffer.get(ptr, readsize);
                ptr += (long)buff.length;
                md.update(buff);
            }
            byte[] byArray = md.digest();
            return byArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    public byte[] hash(String alg, byte[] data, int beginIndex, int endIndex) {
        MessageDigest md;
        if (alg == null) {
            throw new IllegalArgumentException("alg==null");
        }
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        if (beginIndex < 0) {
            throw new IllegalArgumentException("beginIndex<0");
        }
        if (endIndex < beginIndex) {
            throw new IllegalArgumentException("endIndex<beginIndex");
        }
        int count = endIndex - beginIndex;
        try {
            md = MessageDigest.getInstance(alg);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new Error("NoSuchAlgorithmException " + alg, ex);
        }
        md.reset();
        md.update(data, beginIndex, count);
        return md.digest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] hash(String alg, InputStream data, long beginIndex, long endIndex, int buffsize) throws IOException {
        this.lock.lock();
        try {
            int readed;
            int needRead;
            int readed2;
            long diff;
            MessageDigest md;
            if (alg == null) {
                throw new IllegalArgumentException("alg==null");
            }
            if (data == null) {
                throw new IllegalArgumentException("data==null");
            }
            if (beginIndex < 0L) {
                throw new IllegalArgumentException("beginIndex<0");
            }
            if (endIndex < beginIndex) {
                throw new IllegalArgumentException("endIndex<beginIndex");
            }
            long count = endIndex - beginIndex;
            if (buffsize <= 0) {
                throw new IllegalArgumentException("buffsize<=0");
            }
            try {
                md = MessageDigest.getInstance(alg);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new Error("NoSuchAlgorithmException " + alg, ex);
            }
            md.reset();
            byte[] buff = new byte[buffsize];
            if (beginIndex > 0L) {
                long ptr = 0L;
                while ((diff = beginIndex - ptr) > 0L) {
                    if (diff >= (long)buffsize) {
                        readed2 = data.read(buff);
                        if (readed2 < 0) {
                            throw new IOException("end of file");
                        }
                        if (readed2 <= 0) continue;
                        ptr += (long)readed2;
                        continue;
                    }
                    needRead = buffsize - (int)diff;
                    readed = data.read(buff, 0, needRead);
                    if (readed < 0) {
                        throw new IOException("end of file");
                    }
                    if (readed <= 0) continue;
                    ptr += (long)readed;
                }
            }
            long totalReaded = 0L;
            while ((diff = count - totalReaded) > 0L) {
                if (diff >= (long)buffsize) {
                    readed2 = data.read(buff);
                    if (readed2 < 0) {
                        throw new IOException("end of file");
                    }
                    if (readed2 <= 0) continue;
                    totalReaded += (long)readed2;
                    md.update(buff, 0, readed2);
                    continue;
                }
                needRead = buffsize - (int)diff;
                readed = data.read(buff, 0, needRead);
                if (readed < 0) {
                    throw new IOException("end of file");
                }
                if (readed <= 0) continue;
                totalReaded += (long)readed;
                md.update(buff, 0, readed);
            }
            byte[] byArray = md.digest();
            return byArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] hash(String alg, File file, int buffSize) throws IOException {
        if (alg == null) {
            throw new IllegalArgumentException("alg==null");
        }
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        if (buffSize < 1) {
            throw new IllegalArgumentException("buffSize<1");
        }
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            byte[] byArray = this.hash(alg, fin, 0L, file.length(), buffSize);
            return byArray;
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
    }

    public byte[] hash(String alg, File file) throws IOException {
        if (alg == null) {
            throw new IllegalArgumentException("alg==null");
        }
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        return this.hash(alg, file, 8192);
    }
}

