/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.common;

import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.xml.XmlCoder;

public class ImmutableFragment {
    public static final AtomicLong sequneceID = new AtomicLong();
    public final long instanceID = sequneceID.incrementAndGet();
    protected volatile long begin;
    protected volatile long end;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(ImmutableFragment.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(ImmutableFragment.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(ImmutableFragment.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(ImmutableFragment.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(ImmutableFragment.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(ImmutableFragment.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(ImmutableFragment.class.getName()).log(Level.SEVERE, null, ex);
    }

    public ImmutableFragment(long begin, long end) {
        this.init(begin, end);
    }

    protected ImmutableFragment() {
    }

    protected void init(long begin, long end) {
        if (end < begin) {
            long t = begin;
            begin = end;
            end = t;
        }
        this.begin = begin;
        this.end = end;
    }

    public ImmutableFragment(ImmutableFragment source) {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        this.init(source);
    }

    protected void init(ImmutableFragment source) {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        this.begin = source.begin;
        this.end = source.end;
    }

    public ImmutableFragment clone() {
        return new ImmutableFragment(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        long b = this.getBegin();
        long e = this.getEnd();
        long s = this.getSize();
        sb.append("[").append(b).append(" -> ").append(e).append("/").append(s);
        sb.append("]");
        return sb.toString();
    }

    public long getBegin() {
        return this.begin;
    }

    public long getEnd() {
        return this.end;
    }

    @XmlCoder.Ignore
    public long getSize() {
        long v = this.getEnd() - this.getBegin();
        return v < 0L ? -v : v;
    }

    public ImmutableFragment range(long begin, long end) {
        if (end < begin) {
            long t = begin;
            begin = end;
            end = t;
        }
        ImmutableFragment f = this.clone();
        f.begin = begin;
        f.end = end;
        return f;
    }

    public ImmutableFragment size(long newSize) {
        long e;
        if (newSize < 0L) {
            throw new IllegalArgumentException("newsize<0");
        }
        ImmutableFragment f = this.clone();
        long b = f.getBegin();
        f.end = e = b + newSize;
        return f;
    }

    public ImmutableFragment intersection(ImmutableFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException("fragment==null");
        }
        long b1 = this.getBegin();
        long e1 = this.getEnd();
        long b2 = fragment.getBegin();
        long e2 = fragment.getEnd();
        if (b2 < b1) {
            long t = b1;
            b1 = b2;
            b2 = t;
            t = e1;
            e1 = e2;
            e2 = t;
        }
        if (b2 >= b1 && b2 < e1) {
            if (e2 > e1) {
                return this.range(b2, e1);
            }
            return this.range(b2, e2);
        }
        return null;
    }

    public boolean hasIntersection(ImmutableFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException("fragment==null");
        }
        long b1 = this.getBegin();
        long e1 = this.getEnd();
        long b2 = fragment.getBegin();
        long e2 = fragment.getEnd();
        if (b2 < b1) {
            long t = b1;
            b1 = b2;
            b2 = t;
            t = e1;
            e1 = e2;
            e2 = t;
        }
        return b2 >= b1 && b2 < e1;
    }

    public boolean follow(ImmutableFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException("fragment==null");
        }
        long b1 = this.getBegin();
        long e1 = this.getEnd();
        long b2 = fragment.getBegin();
        long e2 = fragment.getEnd();
        return b1 == e2;
    }

    public boolean follower(ImmutableFragment fragment) {
        return fragment.follow(this);
    }

    public ImmutableFragment union(ImmutableFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException("fragment==null");
        }
        if (this.follow(fragment) || this.follower(fragment)) {
            long b1 = this.getBegin();
            long e1 = this.getEnd();
            long b2 = fragment.getBegin();
            long e2 = fragment.getEnd();
            long minb = b1 > b2 ? b2 : b1;
            long maxe = e1 < e2 ? e2 : e1;
            return this.range(minb, maxe);
        }
        if (!this.hasIntersection(fragment)) {
            return null;
        }
        long b1 = this.getBegin();
        long e1 = this.getEnd();
        long b2 = fragment.getBegin();
        long e2 = fragment.getEnd();
        long minb = b1 > b2 ? b2 : b1;
        long maxe = e1 < e2 ? e2 : e1;
        return this.range(minb, maxe);
    }

    public boolean include(ImmutableFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException("fragment==null");
        }
        long b1 = this.getBegin();
        long e1 = this.getEnd();
        long b2 = fragment.getBegin();
        long e2 = fragment.getEnd();
        return b2 >= b1 && e2 <= e1;
    }

    public boolean equalsRange(ImmutableFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException("fragment==null");
        }
        long b1 = this.getBegin();
        long e1 = this.getEnd();
        long b2 = fragment.getBegin();
        long e2 = fragment.getEnd();
        return b1 == b2 && e1 == e2;
    }

    public ImmutableFragment[] substract(ImmutableFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException("fragment==null");
        }
        if (fragment.include(this)) {
            return new ImmutableFragment[]{this.size(0L)};
        }
        if (this.equalsRange(fragment)) {
            return new ImmutableFragment[]{this.size(0L)};
        }
        if (!this.hasIntersection(fragment)) {
            return new ImmutableFragment[]{this.clone()};
        }
        long b1 = this.getBegin();
        long e1 = this.getEnd();
        long b2 = fragment.getBegin();
        long e2 = fragment.getEnd();
        if (this.include(fragment)) {
            return new ImmutableFragment[]{this.range(b1, b2), this.range(e1, e2)};
        }
        if (b1 < b2) {
            return new ImmutableFragment[]{this.range(b1, b2)};
        }
        return new ImmutableFragment[]{this.range(e2, e1)};
    }

    public Long distance(ImmutableFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException("fragment==null");
        }
        if (this.hasIntersection(fragment)) {
            return null;
        }
        long b1 = this.getBegin();
        long e1 = this.getEnd();
        long b2 = fragment.getBegin();
        long e2 = fragment.getEnd();
        if (b1 < b2) {
            return e1 - b2;
        }
        return b1 - e2;
    }
}

