/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BuildInfo {
    private static final Logger logger = Logger.getLogger(BuildInfo.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected Properties props = null;
    public static final BuildInfo instance;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    protected BuildInfo() {
        URL u = BuildInfo.class.getResource("build-info.properties");
        if (u == null) {
            this.props = new Properties();
            return;
        }
        try {
            this.props = new Properties();
            InputStream instr = u.openStream();
            this.props.load(instr);
            instr.close();
        }
        catch (IOException ex) {
            Logger.getLogger(BuildInfo.class.getName()).log(Level.SEVERE, null, ex);
            this.props = new Properties();
        }
    }

    public static Properties getProperties() {
        return BuildInfo.instance.props;
    }

    public static Date getBuildDate() {
        String v = BuildInfo.instance.props.getProperty("build.time");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (v == null) {
            v = "2000-01-01 01:01:01";
        }
        try {
            return sdf.parse(v);
        }
        catch (ParseException ex) {
            Logger.getLogger(BuildInfo.class.getName()).log(Level.SEVERE, null, ex);
            return new Date(0L);
        }
    }

    public static String getArtifactID() {
        return BuildInfo.instance.props.getProperty("project.artifactId", "http-base");
    }

    public static String getGroupID() {
        return BuildInfo.instance.props.getProperty("project.groupId", "xyz.cofe");
    }

    public static String getVersion() {
        return BuildInfo.instance.props.getProperty("project.version", "0.1-SNAPSHOT-BadBuildInfo");
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
        instance = new BuildInfo();
    }
}

