/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http;

import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.common.Fragment;

public class ContentFragment
extends Fragment {
    protected String md5;
    protected long downloadedSize;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(ContentFragment.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(ContentFragment.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(ContentFragment.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(ContentFragment.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(ContentFragment.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(ContentFragment.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(ContentFragment.class.getName()).log(Level.SEVERE, null, ex);
    }

    public ContentFragment() {
        super(0L, 0L);
    }

    public ContentFragment(long begin, long end, Lock lock) {
        super(begin, end, lock);
    }

    public ContentFragment(long begin, long end) {
        super(begin, end);
    }

    public ContentFragment(Fragment source) {
        super(source);
    }

    public ContentFragment(ContentFragment source) {
        super(source);
        this.downloadedSize = source.downloadedSize;
        this.md5 = source.md5;
    }

    @Override
    public ContentFragment clone() {
        return new ContentFragment(this);
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(final String newmd5) {
        this.syncUpdateProperties(new Runnable(){

            @Override
            public void run() {
                ContentFragment.this.md5 = newmd5;
            }
        });
    }

    public long getDownloadedSize() {
        return this.downloadedSize;
    }

    public void setDownloadedSize(final long size) {
        this.syncUpdateProperties(new Runnable(){

            @Override
            public void run() {
                ContentFragment.this.downloadedSize = size;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFullDownloaded() {
        try {
            long fragmentSize;
            long downloaded;
            if (this.lock != null) {
                this.lock.lock();
            }
            boolean bl = (downloaded = this.getDownloadedSize()) >= (fragmentSize = this.getSize());
            return bl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        long b = this.getBegin();
        long e = this.getEnd();
        long s = this.getSize();
        sb.append("[").append(b).append(" -> ").append(e).append("/").append(s);
        sb.append(", ").append("downloadedSize=").append(this.downloadedSize);
        sb.append(", ").append("md5=").append(this.md5);
        sb.append("]");
        return sb.toString();
    }
}

