/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http;

import java.io.BufferedInputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.Func2;
import xyz.cofe.common.Fragment;
import xyz.cofe.common.Fragments;
import xyz.cofe.common.Hash;
import xyz.cofe.fs.File;
import xyz.cofe.http.ContentFragment;

public class ContentFragments
extends Fragments {
    private static void logFine(String message, Object ... args) {
        Logger.getLogger(ContentFragments.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(ContentFragments.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(ContentFragments.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(ContentFragments.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(ContentFragments.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(ContentFragments.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(ContentFragments.class.getName()).log(Level.SEVERE, null, ex);
    }

    public ContentFragments() {
    }

    public ContentFragments(Lock lock) {
        super(lock, lock);
    }

    public ContentFragments(Iterable<Fragment> source) {
        super(source);
    }

    public ContentFragments(Iterable<Fragment> source, Lock lock) {
        super(source, lock, lock);
    }

    public ContentFragments(ContentFragments source, Lock lock) {
        super(source, lock, lock);
    }

    @Override
    public ContentFragments clone() {
        return new ContentFragments(this, null);
    }

    @Override
    protected Fragment createFagment(long begin, long end) {
        return new ContentFragment(begin, end, this.getLock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalDownloadedSize() {
        try {
            if (this.lock != null) {
                this.lock.lock();
            }
            long tot = 0L;
            for (Fragment f : this) {
                if (!(f instanceof ContentFragment)) continue;
                ContentFragment cf = (ContentFragment)f;
                tot += cf.getDownloadedSize();
            }
            long l = tot;
            return l;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalSize() {
        try {
            if (this.lock != null) {
                this.lock.lock();
            }
            long tot = 0L;
            for (Fragment f : this) {
                if (f == null) continue;
                tot += f.getSize();
            }
            long l = tot;
            return l;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ContentFragment> getNotDownloaded() {
        try {
            if (this.lock != null) {
                this.lock.lock();
            }
            ArrayList<ContentFragment> l = new ArrayList<ContentFragment>();
            for (Fragment f : this) {
                ContentFragment cf;
                if (!(f instanceof ContentFragment) || (cf = (ContentFragment)f).isFullDownloaded()) continue;
                l.add(cf);
            }
            ArrayList<ContentFragment> arrayList = l;
            return arrayList;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    private static ContentFragment getMD5(byte[] buff, int buffBegin, int buffEndExc, long fileoffset) {
        if (buff == null) {
            return null;
        }
        if (buff.length < 1) {
            return null;
        }
        if (buffBegin > buffEndExc) {
            return null;
        }
        if (buffEndExc - buffBegin <= 0) {
            return null;
        }
        Hash h = new Hash();
        byte[] hash = h.md5(buff, buffBegin, buffEndExc);
        String dataMd5str = h.toString(hash);
        int dataLen = buffEndExc - buffBegin;
        ContentFragment cf = new ContentFragment(fileoffset, fileoffset + (long)dataLen);
        cf.setMd5(dataMd5str);
        return cf;
    }

    public static ContentFragments createMd5(final File sourceFile, int fragmentSize, final Func2<Object, Long, Long> progress) {
        if (fragmentSize < 1) {
            throw new IllegalArgumentException("fragmentSize<1");
        }
        if (sourceFile == null) {
            throw new IllegalArgumentException("sourceFile==null");
        }
        try {
            long fileSize = sourceFile.getLength();
            BufferedInputStream fin = sourceFile.openRead();
            ContentFragments cfs = ContentFragments.createMd5(fin, fragmentSize, new Func1<Object, Long>(){

                public Object apply(Long offset) {
                    if (progress != null) {
                        try {
                            long fsize = sourceFile.getLength();
                            progress.apply((Object)offset, (Object)fsize);
                        }
                        catch (Throwable err) {
                            ContentFragments.logException(err);
                        }
                    }
                    return null;
                }
            });
            ((InputStream)fin).close();
            return cfs;
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public static ContentFragments createMd5(InputStream data, int fragmentSize, Func1<Object, Long> progress) throws IOException {
        if (fragmentSize < 1) {
            throw new IllegalArgumentException("fragmentSize<1");
        }
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        ContentFragments cfs = new ContentFragments();
        if (fragmentSize < 1) {
            return null;
        }
        byte[] buff = new byte[fragmentSize];
        int bptr = 0;
        long fileoffset = 0L;
        int zeroreaded = 0;
        while (!Thread.currentThread().isInterrupted()) {
            int readed;
            if (bptr >= buff.length) {
                ContentFragment cf = ContentFragments.getMD5(buff, 0, bptr, fileoffset);
                if (cf != null) {
                    cfs.add(cf);
                }
                fileoffset += (long)bptr;
                bptr = 0;
                if (progress != null) {
                    progress.apply((Object)fileoffset);
                }
            }
            if ((readed = data.read(buff, bptr, buff.length - bptr)) < 0) break;
            if (readed == 0) {
                if (++zeroreaded >= 10) break;
                continue;
            }
            zeroreaded = 0;
            bptr += readed;
        }
        if (bptr > 0) {
            ContentFragment cf = ContentFragments.getMD5(buff, 0, bptr, fileoffset);
            if (cf != null) {
                cfs.add(cf);
            }
            if (progress != null) {
                progress.apply((Object)cf.getEnd());
            }
        }
        return cfs;
    }
}

