/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xyz.cofe.text.template.ctx.DateVar;

public class DateTime {
    private static final Logger logger = Logger.getLogger(DateTime.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private static final Pattern rfc1123Pattern;
    private static final Pattern rfc850Pattern;
    private static final Pattern asctimePattern;
    private static final String[] wkday;
    private static final String[] weekday;
    private static final String[] month;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public Date parse(String s) {
        if (s == null) {
            throw new IllegalArgumentException("s==null");
        }
        return this.parse(s, false);
    }

    public Date parse(String s, boolean returnGMT) {
        Date dasctime;
        Date d850;
        if (s == null) {
            throw new IllegalArgumentException("s==null");
        }
        Date d = null;
        Date d1123 = this.parse_RFC_1123(s);
        d = d1123 == null ? ((d850 = this.parse_RFC_850(s)) == null ? (dasctime = this.parse_asctime(s)) : d850) : d1123;
        if (d == null) {
            return null;
        }
        if (returnGMT) {
            return d;
        }
        int off = TimeZone.getDefault().getRawOffset();
        d = new Date(d.getTime() + (long)off);
        return d;
    }

    public String toDate(Date date, boolean isGMT) {
        if (date == null) {
            throw new IllegalArgumentException("date==null");
        }
        return this.toDateRFC1123(date, isGMT);
    }

    public String toDate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("date==null");
        }
        return this.toDateRFC1123(date, false);
    }

    public String toDateRFC1123(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("date==null");
        }
        return this.toDateRFC1123(date, false);
    }

    public String toDateRFC1123(Date date, boolean isGMT) {
        if (date == null) {
            throw new IllegalArgumentException("date==null");
        }
        if (!isGMT) {
            int off = TimeZone.getDefault().getRawOffset();
            date = new Date(date.getTime() - (long)off);
        }
        GregorianCalendar gcal = new GregorianCalendar(Locale.ENGLISH);
        gcal.setTime(date);
        int wd_0 = gcal.get(7);
        int wd = -1;
        if (wd_0 == 2) {
            wd = 0;
        } else if (wd_0 == 3) {
            wd = 1;
        } else if (wd_0 == 4) {
            wd = 2;
        } else if (wd_0 == 5) {
            wd = 3;
        } else if (wd_0 == 6) {
            wd = 4;
        } else if (wd_0 == 7) {
            wd = 5;
        } else if (wd_0 == 1) {
            wd = 6;
        } else {
            throw new Error("!! GregorianCalendar is wrong: day of week=" + wd_0 + " for " + new DateVar(date));
        }
        String wdString = wkday[wd];
        int day_of_month = gcal.get(5);
        String day_of_month_String = day_of_month < 10 ? "0" + day_of_month : Integer.toString(day_of_month);
        int mon = gcal.get(2);
        String monString = month[mon];
        int year = gcal.get(1);
        String yearString = year < 10 ? "000" + year : (year < 100 ? "00" + year : (year < 1000 ? "0" + year : Integer.toString(year)));
        String date1String = day_of_month_String + " " + monString + " " + yearString;
        int hour = gcal.get(11);
        String hourString = hour < 10 ? "0" + hour : Integer.toString(hour);
        int minute = gcal.get(12);
        String minuteString = minute < 10 ? "0" + minute : Integer.toString(minute);
        int sec = gcal.get(13);
        String secString = sec < 10 ? "0" + sec : Integer.toString(sec);
        String time = hourString + ":" + minuteString + ":" + secString;
        return wdString + ", " + date1String + " " + time + " GMT";
    }

    private Date parse_RFC_1123(String str) {
        if (str == null) {
            return null;
        }
        Matcher m = rfc1123Pattern.matcher(str.trim());
        if (!m.matches()) {
            return null;
        }
        String wdString = m.group(1);
        String dateString = m.group(2);
        String monString = m.group(3);
        String yearString = m.group(4);
        String hourString = m.group(5);
        String minString = m.group(6);
        String secString = m.group(7);
        GregorianCalendar gcal = new GregorianCalendar(Locale.ENGLISH);
        gcal.set(1, Integer.parseInt(yearString));
        gcal.set(2, DateTime.indexOfMonth(monString));
        gcal.set(5, Integer.parseInt(dateString));
        gcal.set(11, Integer.parseInt(hourString));
        gcal.set(12, Integer.parseInt(minString));
        gcal.set(13, Integer.parseInt(secString));
        return gcal.getTime();
    }

    private Date parse_RFC_850(String str) {
        if (str == null) {
            return null;
        }
        Matcher m = rfc850Pattern.matcher(str.trim());
        if (!m.matches()) {
            return null;
        }
        String wdString = m.group(1);
        String dateString = m.group(2);
        String monString = m.group(3);
        String yearString = m.group(4);
        String hourString = m.group(5);
        String minString = m.group(6);
        String secString = m.group(7);
        GregorianCalendar gcal = new GregorianCalendar(Locale.ENGLISH);
        int year = Integer.parseInt(yearString);
        if (yearString.length() == 2) {
            if (year >= 75) {
                gcal.set(1, year + 1900);
            } else {
                gcal.set(1, year + 2000);
            }
        } else {
            gcal.set(1, year);
        }
        gcal.set(2, DateTime.indexOfMonth(monString));
        gcal.set(5, Integer.parseInt(dateString));
        gcal.set(11, Integer.parseInt(hourString));
        gcal.set(12, Integer.parseInt(minString));
        gcal.set(13, Integer.parseInt(secString));
        return gcal.getTime();
    }

    private Date parse_asctime(String str) {
        if (str == null) {
            return null;
        }
        Matcher m = rfc1123Pattern.matcher(str.trim());
        if (!m.matches()) {
            return null;
        }
        String wdString = m.group(1);
        String dateString = m.group(3);
        String monString = m.group(2);
        String yearString = m.group(7);
        String hourString = m.group(4);
        String minString = m.group(5);
        String secString = m.group(6);
        GregorianCalendar gcal = new GregorianCalendar(Locale.ENGLISH);
        gcal.set(1, Integer.parseInt(yearString));
        gcal.set(2, DateTime.indexOfMonth(monString));
        gcal.set(5, Integer.parseInt(dateString));
        gcal.set(11, Integer.parseInt(hourString));
        gcal.set(12, Integer.parseInt(minString));
        gcal.set(13, Integer.parseInt(secString));
        return gcal.getTime();
    }

    private static int indexOfWkday(String s) {
        if (s == null) {
            return -1;
        }
        for (int i = 0; i < wkday.length; ++i) {
            String wd = wkday[i];
            if (!s.equalsIgnoreCase(wd)) continue;
            return i;
        }
        return -1;
    }

    private static int indexOfWeekday(String s) {
        if (s == null) {
            return -1;
        }
        for (int i = 0; i < weekday.length; ++i) {
            String wd = weekday[i];
            if (!s.equalsIgnoreCase(wd)) continue;
            return i;
        }
        return -1;
    }

    private static int indexOfMonth(String s) {
        if (s == null) {
            return -1;
        }
        for (int i = 0; i < month.length; ++i) {
            String m = month[i];
            if (!s.equalsIgnoreCase(m)) continue;
            return i;
        }
        return -1;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
        rfc1123Pattern = Pattern.compile("(?is)^(Mon|Tue|Wed|Thu|Fri|Sat|Sun),\\s+(\\d{2})\\s+(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\\s+(\\d{4})\\s+(\\d{2}):(\\d{2}):(\\d{2})\\s+GMT.*");
        rfc850Pattern = Pattern.compile("(?is)^(Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|Sunday),\\s+(\\d{2})-(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)-(\\d{2})\\s+(\\d{2}):(\\d{2}):(\\d{2})\\s+GMT.*");
        asctimePattern = Pattern.compile("(?is)^(Mon|Tue|Wed|Thu|Fri|Sat|Sun)\\s+(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\\s+(\\d{1,2})\\s+(\\d{2}):(\\d{2}):(\\d{2})\\s+(\\d{4}).*");
        wkday = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
        weekday = new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
        month = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    }
}

