/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64OutputStream;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.map.LockEventMap;
import xyz.cofe.common.LazyValue;
import xyz.cofe.http.FormUrlencodedMap;
import xyz.cofe.io.IOFun;
import xyz.cofe.typeconv.ExtendedCastGraph;
import xyz.cofe.typeconv.TypeCastGraph;

public class FormMultipartData
implements Map<String, Object>,
Func1<Object, URLConnection> {
    private static final Logger logger = Logger.getLogger(FormMultipartData.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final Lock lock;
    private final Map<String, Object> map;
    public static final AtomicLong partIdSequence;
    public static final String CRLF = "\r\n";
    private String boundary;
    private TypeCastGraph typeCast;
    private Charset charset;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public FormMultipartData() {
        LockEventMap evmap;
        this.lock = new ReentrantLock();
        this.map = evmap = new LockEventMap(new LinkedHashMap(), this.lock);
    }

    public FormMultipartData(Map<String, Object> sourcemap) {
        LockEventMap evmap;
        this.lock = new ReentrantLock();
        this.map = evmap = sourcemap == null ? new LockEventMap(new LinkedHashMap(), this.lock) : new LockEventMap(sourcemap, this.lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormMultipartData(FormMultipartData source) {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        try {
            source.lock.lock();
            this.lock = new ReentrantLock();
            LockEventMap evmap = new LockEventMap(new LinkedHashMap(), this.lock);
            for (Map.Entry<String, Object> en : source.map.entrySet()) {
                if (en == null) continue;
                String k = en.getKey();
                Object v = en.getValue();
                if (k == null) continue;
                evmap.put((Object)k, v);
            }
            this.map = evmap;
            this.boundary = source.boundary;
            this.typeCast = source.typeCast;
            this.charset = source.charset;
        }
        finally {
            source.lock.unlock();
        }
    }

    public static final String generateBoundary() {
        return "------------------------" + Long.toHexString(System.currentTimeMillis() + partIdSequence.incrementAndGet());
    }

    public void write(OutputStream out, Charset cs, String bound, Iterable<Part> parts) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("out==null");
        }
        if (parts == null) {
            throw new IllegalArgumentException("parts==null");
        }
        if (cs == null) {
            cs = Charset.forName("utf-8");
        }
        if (bound == null) {
            bound = FormMultipartData.generateBoundary();
        }
        OutputStreamWriter writer = new OutputStreamWriter(out, cs);
        for (Part part : parts) {
            if (part == null) continue;
            writer.append("--").append(bound).append(CRLF).flush();
            if (part instanceof SetCharset) {
                ((SetCharset)((Object)part)).setCharset(cs);
            }
            part.write(out);
            out.flush();
        }
        writer.append("--").append(bound).append("--").append(CRLF).flush();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.map.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    public String getBoundary() {
        try {
            this.lock.lock();
            if (this.boundary == null) {
                this.boundary = FormMultipartData.generateBoundary();
            }
            String string = this.boundary;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setBoundary(String boundary) {
        try {
            this.lock.lock();
            this.boundary = boundary;
        }
        finally {
            this.lock.unlock();
        }
    }

    public TypeCastGraph getTypeCast() {
        try {
            this.lock.lock();
            if (this.typeCast == null) {
                this.typeCast = new ExtendedCastGraph();
            }
            TypeCastGraph typeCastGraph = this.typeCast;
            return typeCastGraph;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setTypeCast(TypeCastGraph typeCast) {
        try {
            this.lock.lock();
            this.typeCast = typeCast;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void write(OutputStream out) {
        if (out == null) {
            throw new IllegalArgumentException("out==null");
        }
        this.write(out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream out, Charset cs) {
        if (out == null) {
            throw new IllegalArgumentException("out==null");
        }
        if (cs == null) {
            cs = Charset.forName("utf-8");
        }
        try {
            this.lock.lock();
            ArrayList<Part> parts = new ArrayList<Part>();
            for (Map.Entry<String, Object> en : this.entrySet()) {
                BinaryPart bpart;
                BinaryPart bpart2;
                File f;
                String k = en.getKey();
                Object v = en.getValue();
                if (k == null || k.length() < 1 || v == null) continue;
                if (v instanceof LazyValue) {
                    v = ((LazyValue)v).evaluate();
                }
                if (v == null) continue;
                if (v instanceof Part) {
                    parts.add((Part)v);
                    continue;
                }
                if (v instanceof File) {
                    f = (File)v;
                    bpart2 = new BinaryPart();
                    bpart2.setName(k);
                    bpart2.setFileName(f.getName());
                    bpart2.setValue(f);
                    bpart2.setCharset(cs);
                    parts.add(bpart2);
                    continue;
                }
                if (v instanceof xyz.cofe.fs.File) {
                    f = (xyz.cofe.fs.File)v;
                    bpart2 = new BinaryPart();
                    bpart2.setName(k);
                    bpart2.setFileName(f.getName());
                    bpart2.setValue(f);
                    bpart2.setCharset(cs);
                    parts.add(bpart2);
                    continue;
                }
                if (v instanceof byte[]) {
                    bpart = new BinaryPart();
                    bpart.setName(k);
                    bpart.setValue(v);
                    bpart.setCharset(cs);
                    parts.add(bpart);
                    continue;
                }
                if (v instanceof InputStream) {
                    bpart = new BinaryPart();
                    bpart.setName(k);
                    bpart.setValue(v);
                    bpart.setCharset(cs);
                    parts.add(bpart);
                    continue;
                }
                TextPart tpart = new TextPart();
                tpart.setName(k);
                tpart.setValue(v);
                tpart.setCharset(cs);
                tpart.setTypeCast(this.typeCast);
                parts.add(tpart);
            }
            String bound = this.getBoundary();
            bound = bound == null ? FormMultipartData.generateBoundary() : bound;
            try {
                this.write(out, cs, bound, parts);
            }
            catch (IOException ex) {
                throw new IOError(ex);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public Charset getCharset() {
        try {
            this.lock.lock();
            Charset charset = this.charset;
            return charset;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setCharset(Charset charset) {
        try {
            this.lock.lock();
            this.charset = charset;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object apply(URLConnection conn) {
        if (conn == null) {
            throw new IllegalArgumentException("conn==null");
        }
        try {
            this.lock.lock();
            Charset cs = this.getCharset();
            cs = cs == null ? Charset.forName("utf-8") : cs;
            conn.setDoOutput(true);
            String bound = this.getBoundary();
            if (bound == null) {
                bound = FormMultipartData.generateBoundary();
                this.setBoundary(bound);
            }
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + bound);
            try {
                OutputStream out = conn.getOutputStream();
                this.write(out, cs);
            }
            catch (IOException ex) {
                Logger.getLogger(FormUrlencodedMap.class.getName()).log(Level.SEVERE, null, ex);
                throw new IOError(ex);
            }
        }
        finally {
            this.lock.unlock();
        }
        return null;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
        partIdSequence = new AtomicLong(0L);
    }

    public static class BinaryPart
    implements SetCharset,
    Part {
        public final long id = partIdSequence.incrementAndGet();
        private String name;
        private String contentType;
        private Object fileName;
        private Charset charset;
        private Object value;
        private TransferEncoding transferEncoding = TransferEncoding.Binary;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public Object getFileName() {
            return this.fileName;
        }

        public void setFileName(Object fileName) {
            this.fileName = fileName;
        }

        public Charset getCharset() {
            if (this.charset == null) {
                this.charset = Charset.forName("utf-8");
            }
            return this.charset;
        }

        @Override
        public void setCharset(Charset charset) {
            this.charset = charset;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public TransferEncoding getTransferEncoding() {
            return this.transferEncoding;
        }

        public void setTransferEncoding(TransferEncoding transferEncoding) {
            this.transferEncoding = transferEncoding;
        }

        @Override
        public void write(OutputStream out) throws IOException {
            InputStream fin;
            File f;
            InputStream fin2;
            File f2;
            String name = this.getName();
            if (name == null) {
                name = "part-id-" + this.id;
            }
            Object fnameObj = this.getFileName();
            String fname = null;
            if (fnameObj instanceof String) {
                fname = (String)fnameObj;
                if (fname.length() < 1) {
                    fname = name;
                }
            } else if (fnameObj instanceof LazyValue) {
                Object oname = ((LazyValue)fnameObj).evaluate();
                if (oname instanceof String) {
                    fname = (String)oname;
                    if (fname.length() < 1) {
                        fname = name;
                    }
                } else if (oname instanceof File) {
                    fname = ((File)oname).getName();
                    if (fname.length() < 1) {
                        fname = name;
                    }
                } else if (oname instanceof xyz.cofe.fs.File) {
                    fname = ((xyz.cofe.fs.File)oname).getName();
                    if (fname.length() < 1) {
                        fname = name;
                    }
                } else {
                    fname = name;
                }
            } else {
                fname = name;
            }
            Charset cs = this.getCharset();
            Object val = this.value;
            if (val instanceof LazyValue) {
                val = ((LazyValue)val).evaluate();
            }
            String fileContType = null;
            if (val instanceof File) {
                f2 = (File)val;
                fileContType = URLConnection.guessContentTypeFromName(f2.getName());
                if (fileContType == null) {
                    fin2 = new FileInputStream(f2);
                    fileContType = URLConnection.guessContentTypeFromStream(fin2);
                    ((FileInputStream)fin2).close();
                }
            } else if (val instanceof xyz.cofe.fs.File && (fileContType = URLConnection.guessContentTypeFromName((f2 = (xyz.cofe.fs.File)val).getName())) == null) {
                fin2 = f2.openRead();
                fileContType = URLConnection.guessContentTypeFromStream(fin2);
                fin2.close();
            }
            String contType = this.contentType == null ? (fileContType != null ? fileContType : "application/octet-stream") : this.contentType;
            OutputStreamWriter writer = new OutputStreamWriter(out, cs);
            writer.append("Content-Disposition: form-data").append("; name=\"").append(name).append("\"").append("; filename=\"").append(fname).append("\"").append(FormMultipartData.CRLF);
            writer.append("Content-Type: ").append(contType).append(FormMultipartData.CRLF);
            if (this.transferEncoding != null) {
                writer.append("Content-Transfer-Encoding: ");
                switch (this.transferEncoding) {
                    case Binary: {
                        writer.append("binary");
                        break;
                    }
                    case Base64: {
                        writer.append("base64");
                    }
                }
                writer.append(FormMultipartData.CRLF);
            }
            writer.append(FormMultipartData.CRLF);
            writer.flush();
            OutputStream dataStream = out;
            boolean closeDataStream = false;
            byte[] suffixData = new byte[]{};
            String suffixDataString = "";
            if (this.transferEncoding != null) {
                switch (this.transferEncoding) {
                    case Base64: {
                        final OutputStream fout = out;
                        OutputStream nonCloseOut = new OutputStream(){

                            @Override
                            public void write(int b) throws IOException {
                                fout.write(b);
                            }

                            @Override
                            public void write(byte[] b, int off, int len) throws IOException {
                                fout.write(b, off, len);
                            }

                            @Override
                            public void write(byte[] b) throws IOException {
                                fout.write(b);
                            }

                            @Override
                            public void close() throws IOException {
                            }
                        };
                        Base64OutputStream base64out = new Base64OutputStream(nonCloseOut);
                        dataStream = base64out;
                        closeDataStream = false;
                        suffixDataString = "==";
                    }
                }
            }
            if (val instanceof InputStream) {
                IOFun.copy((InputStream)((InputStream)val), (OutputStream)dataStream);
                dataStream.flush();
                if (closeDataStream) {
                    dataStream.close();
                }
            } else if (val instanceof File) {
                f = (File)val;
                fin = new FileInputStream(f);
                IOFun.copy((InputStream)fin, (OutputStream)dataStream);
                ((FileInputStream)fin).close();
                dataStream.flush();
                if (closeDataStream) {
                    dataStream.close();
                }
            } else if (val instanceof byte[]) {
                byte[] data = (byte[])val;
                dataStream.write(data);
                dataStream.flush();
                if (closeDataStream) {
                    dataStream.close();
                }
            } else if (val instanceof xyz.cofe.fs.File) {
                f = (xyz.cofe.fs.File)val;
                fin = f.openRead();
                IOFun.copy((InputStream)fin, (OutputStream)dataStream);
                fin.close();
                dataStream.flush();
                if (closeDataStream) {
                    dataStream.close();
                }
            }
            if (suffixData != null && suffixData.length > 0) {
                out.write(suffixData);
            }
            if (suffixDataString != null && suffixDataString.length() > 0) {
                writer.append(suffixDataString);
            }
            writer.append(FormMultipartData.CRLF).flush();
        }
    }

    public static enum TransferEncoding {
        Binary,
        Base64;

    }

    public static class TextPart
    implements SetCharset,
    Part {
        public final long id = partIdSequence.incrementAndGet();
        private Charset charset;
        private String name;
        private String contentType;
        private Object value;
        private TypeCastGraph typeCast;

        public Charset getCharset() {
            if (this.charset == null) {
                this.charset = Charset.forName("utf-8");
            }
            return this.charset;
        }

        @Override
        public void setCharset(Charset charset) {
            this.charset = charset;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getContentType() {
            if (this.contentType == null) {
                this.contentType = "text/plain";
            }
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public TypeCastGraph getTypeCast() {
            if (this.typeCast == null) {
                this.typeCast = new ExtendedCastGraph();
            }
            return this.typeCast;
        }

        public void setTypeCast(TypeCastGraph typeCast) {
            this.typeCast = typeCast;
        }

        @Override
        public void write(OutputStream out) throws IOException {
            String name = this.getName();
            if (name == null) {
                name = "part-id-" + this.id;
            }
            Charset cs = this.getCharset();
            OutputStreamWriter writer = new OutputStreamWriter(out, cs);
            writer.append("Content-Disposition: form-data;").append(" name=\"").append(name).append("\"").append(FormMultipartData.CRLF);
            writer.append("Content-Type: ").append(this.getContentType()).append("; charset=").append(cs.name()).append(FormMultipartData.CRLF);
            writer.append(FormMultipartData.CRLF);
            Object val = this.value;
            if (val instanceof LazyValue) {
                val = ((LazyValue)val).evaluate();
            }
            if (val == null) {
                writer.append("").append(FormMultipartData.CRLF).flush();
            } else if (val instanceof String) {
                writer.append((String)val).append(FormMultipartData.CRLF).flush();
            } else {
                TypeCastGraph tcast = this.getTypeCast();
                String txt = (String)tcast.cast(this.value, String.class);
                if (txt != null) {
                    writer.append(txt).append(FormMultipartData.CRLF).flush();
                } else {
                    writer.append("").append(FormMultipartData.CRLF).flush();
                }
            }
        }
    }

    public static interface SetCharset {
        public void setCharset(Charset var1);
    }

    public static interface Part {
        public void write(OutputStream var1) throws IOException;
    }
}

