/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.map.LockEventMap;
import xyz.cofe.common.LazyValue;
import xyz.cofe.typeconv.ExtendedCastGraph;
import xyz.cofe.typeconv.TypeCastGraph;

public class FormUrlencodedMap
implements Map<String, Object>,
Func1<Object, URLConnection> {
    private static final Logger logger = Logger.getLogger(FormUrlencodedMap.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private final Map<String, Object> map;
    protected final Lock lock;
    private boolean writeNullValue = true;
    private TypeCastGraph typeCast;
    private Charset charset;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public FormUrlencodedMap() {
        LockEventMap evmap;
        this.lock = new ReentrantLock();
        this.map = evmap = new LockEventMap(new LinkedHashMap(), this.lock);
    }

    public FormUrlencodedMap(Map<String, Object> sourcemap) {
        LockEventMap evmap;
        this.lock = new ReentrantLock();
        this.map = evmap = sourcemap == null ? new LockEventMap(new LinkedHashMap(), this.lock) : new LockEventMap(sourcemap, this.lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormUrlencodedMap(FormUrlencodedMap source) {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        try {
            source.lock.lock();
            this.lock = new ReentrantLock();
            LockEventMap evmap = new LockEventMap(new LinkedHashMap(), this.lock);
            for (Map.Entry<String, Object> en : source.map.entrySet()) {
                if (en == null) continue;
                String k = en.getKey();
                Object v = en.getValue();
                if (k == null) continue;
                evmap.put((Object)k, v);
            }
            this.map = evmap;
            this.typeCast = source.typeCast;
            this.writeNullValue = source.writeNullValue;
            this.charset = source.charset;
        }
        finally {
            source.lock.unlock();
        }
    }

    public FormUrlencodedMap clone() {
        return new FormUrlencodedMap(this);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.map.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    public boolean isWriteNullValue() {
        try {
            this.lock.lock();
            boolean bl = this.writeNullValue;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setWriteNullValue(boolean writeNullValue) {
        try {
            this.lock.lock();
            this.writeNullValue = writeNullValue;
        }
        finally {
            this.lock.unlock();
        }
    }

    public TypeCastGraph getTypeCast() {
        try {
            this.lock.lock();
            if (this.typeCast == null) {
                this.typeCast = new ExtendedCastGraph();
            }
            TypeCastGraph typeCastGraph = this.typeCast;
            return typeCastGraph;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setTypeCast(TypeCastGraph typeCast) {
        try {
            this.lock.lock();
            this.typeCast = typeCast;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void write(OutputStream out) {
        if (out == null) {
            throw new IllegalArgumentException("out==null");
        }
        this.write(out, null);
    }

    public void write(OutputStream out, Charset cs) {
        if (out == null) {
            throw new IllegalArgumentException("out==null");
        }
        if (cs == null) {
            cs = Charset.forName("utf-8");
        }
        OutputStreamWriter outw = new OutputStreamWriter(out, cs);
        this.write(outw, cs);
        try {
            outw.flush();
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Writer out, Charset cs) {
        if (out == null) {
            throw new IllegalArgumentException("out==null");
        }
        if (cs == null) {
            cs = Charset.forName("utf-8");
        }
        try {
            this.lock.lock();
            int writedPairCount = 0;
            for (Map.Entry<String, Object> en : this.map.entrySet()) {
                String k = en.getKey();
                Object v = en.getValue();
                if (v == null) {
                    if (!this.writeNullValue || k == null || k.length() < 1) continue;
                    if (writedPairCount > 0) {
                        this.writePairSplitter(out, cs);
                    }
                    if (!this.writeNullValue(out, k, cs)) continue;
                    ++writedPairCount;
                    continue;
                }
                if (k == null || k.length() < 1) continue;
                if (writedPairCount > 0) {
                    this.writePairSplitter(out, cs);
                }
                if (!this.writeKeyValue(out, k, v, cs)) continue;
                ++writedPairCount;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void writePairSplitter(Writer out, Charset cs) {
        try {
            out.write("&");
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    protected boolean writeNullValue(Writer out, String k, Charset cs) {
        if (k == null) {
            return false;
        }
        if (k.length() < 1) {
            return false;
        }
        if (!this.writeNullValue) {
            return false;
        }
        try {
            String enck = URLEncoder.encode(k, cs.name());
            out.write(enck);
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
        return true;
    }

    protected boolean writeKeyValue(Writer out, String key, Object value, Charset cs) {
        if (value == null) {
            return this.writeNullValue(out, key, cs);
        }
        if (value instanceof LazyValue) {
            value = ((LazyValue)value).evaluate();
        }
        if (value == null) {
            return this.writeNullValue(out, key, cs);
        }
        if (key == null) {
            return false;
        }
        if (key.length() < 1) {
            return false;
        }
        if (value instanceof String) {
            return this.writeKeyText(out, key, (String)value, cs);
        }
        if (value instanceof File) {
            return this.writeKeyText(out, key, ((File)value).getName(), cs);
        }
        if (value instanceof xyz.cofe.fs.File) {
            return this.writeKeyText(out, key, ((xyz.cofe.fs.File)value).getName(), cs);
        }
        if (value instanceof byte[]) {
            return this.writeNullValue(out, key, cs);
        }
        if (value instanceof InputStream) {
            return this.writeNullValue(out, key, cs);
        }
        TypeCastGraph tcast = this.getTypeCast();
        try {
            String text = (String)tcast.cast(value, String.class);
            if (text == null || text.length() < 1) {
                return this.writeNullValue(out, key, cs);
            }
            return this.writeKeyText(out, key, text, cs);
        }
        catch (Throwable err) {
            FormUrlencodedMap.logWarning("failed cast value to string", err.getMessage());
            return false;
        }
    }

    protected boolean writeKeyText(Writer out, String key, String text, Charset cs) {
        if (key == null) {
            return false;
        }
        if (key.length() < 1) {
            return false;
        }
        if (text == null) {
            return this.writeNullValue(out, key, cs);
        }
        if (text.length() < 1) {
            return this.writeNullValue(out, key, cs);
        }
        try {
            String enckey = URLEncoder.encode(key, cs.name());
            out.write(enckey);
            out.write("=");
            String enctxt = URLEncoder.encode(text, cs.name());
            out.write(enctxt);
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
        return true;
    }

    public Charset getCharset() {
        try {
            this.lock.lock();
            Charset charset = this.charset;
            return charset;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setCharset(Charset charset) {
        try {
            this.lock.lock();
            this.charset = charset;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object apply(URLConnection conn) {
        if (conn == null) {
            throw new IllegalArgumentException("conn==null");
        }
        try {
            this.lock.lock();
            Charset cs = this.getCharset();
            cs = cs == null ? Charset.forName("utf-8") : cs;
            conn.setDoOutput(true);
            conn.setRequestProperty("Accept-Charset", cs.name());
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=" + cs.name());
            try {
                OutputStream out = conn.getOutputStream();
                this.write(out, cs);
            }
            catch (IOException ex) {
                Logger.getLogger(FormUrlencodedMap.class.getName()).log(Level.SEVERE, null, ex);
                throw new IOError(ex);
            }
        }
        finally {
            this.lock.unlock();
        }
        return null;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

