/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http;

import java.io.Closeable;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.MalformedURLException;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import xyz.cofe.collection.Func2;
import xyz.cofe.http.BuildInfo;
import xyz.cofe.http.HttpDownloader;
import xyz.cofe.http.HttpEvent;
import xyz.cofe.http.HttpListener;
import xyz.cofe.http.HttpListenersHelper;
import xyz.cofe.http.HttpRequest;
import xyz.cofe.http.HttpResponse;
import xyz.cofe.http.SystemProxySelector;
import xyz.cofe.http.download.Mirrors;

public class HttpClient {
    protected static final AtomicLong sequenceID = new AtomicLong();
    public final long id = sequenceID.incrementAndGet();
    protected final Lock lock;
    protected final HttpListenersHelper httpListenerHelper = new HttpListenersHelper();
    private static final String defaultCharset = "ISO-8859-1";
    protected Charset defCharset = null;
    protected String userAgent = null;
    protected Integer connectTimeout = null;
    protected Integer readTimeout = null;
    protected ProxySelector proxySelector = null;
    protected Integer responseThreadPriority = null;
    protected Func2<Thread, HttpResponse, Runnable> defCreateResponseThread = new Func2<Thread, HttpResponse, Runnable>(){

        public Thread apply(final HttpResponse it, Runnable run) {
            long responseId = it.id;
            Thread thread = new Thread(run);
            thread.setDaemon(true);
            thread.setName("httpResponse(id:" + responseId + ")");
            thread.setPriority(HttpClient.this.getResponseThreadPriority());
            thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    HttpClient.logException(e);
                    if (it != null) {
                        try {
                            it.addError(e);
                            it.setState(HttpResponse.State.Finished);
                        }
                        catch (Throwable err) {
                            HttpClient.logException(err);
                        }
                    }
                    long tbegin = System.currentTimeMillis();
                    long tmax = 15000L;
                    long sleep = 50L;
                    while (t.isAlive()) {
                        t.interrupt();
                        long tnow = System.currentTimeMillis();
                        long diff = tnow - tbegin;
                        if (diff > tmax) {
                            t.stop();
                            continue;
                        }
                        try {
                            Thread.sleep(sleep);
                        }
                        catch (InterruptedException ex) {
                            t.stop();
                            break;
                        }
                    }
                }
            });
            return thread;
        }
    };
    protected Func2<Thread, HttpDownloader, Runnable> defCreateDownloaderThread = new Func2<Thread, HttpDownloader, Runnable>(){

        public Thread apply(final HttpDownloader it, Runnable run) {
            long responseId = it.id;
            Thread thread = new Thread(run);
            thread.setDaemon(true);
            thread.setName("httpDownloader(id:" + responseId + ")");
            thread.setPriority(HttpClient.this.getResponseThreadPriority());
            thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    HttpClient.logException(e);
                    if (it != null) {
                        try {
                            it.setState(HttpDownloader.State.Finished);
                        }
                        catch (Throwable err) {
                            HttpClient.logException(err);
                        }
                    }
                    long tbegin = System.currentTimeMillis();
                    long tmax = 15000L;
                    long sleep = 50L;
                    while (t.isAlive()) {
                        t.interrupt();
                        long tnow = System.currentTimeMillis();
                        long diff = tnow - tbegin;
                        if (diff > tmax) {
                            t.stop();
                            continue;
                        }
                        try {
                            Thread.sleep(sleep);
                        }
                        catch (InterruptedException ex) {
                            t.stop();
                            break;
                        }
                    }
                }
            });
            return thread;
        }
    };

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(HttpClient.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(HttpClient.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(HttpClient.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(HttpClient.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(HttpClient.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(HttpClient.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(HttpClient.class.getName()).log(Level.SEVERE, null, ex);
    }

    public HttpClient() {
        this.lock = new ReentrantLock();
    }

    public HttpClient(HttpClient source) {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        this.lock = new ReentrantLock();
        try {
            this.lock.lock();
            this.userAgent = source.userAgent;
            this.defCharset = source.defCharset;
            this.responseThreadPriority = source.responseThreadPriority;
            this.connectTimeout = source.connectTimeout;
            this.readTimeout = source.readTimeout;
        }
        finally {
            this.lock.unlock();
        }
    }

    public HttpClient clone() {
        return new HttpClient(this);
    }

    public Set<HttpListener> getListeners() {
        return this.httpListenerHelper.getListeners();
    }

    public Closeable addListener(HttpListener listener) {
        return this.httpListenerHelper.addListener(listener);
    }

    public Closeable addListener(HttpListener listener, boolean weakLink) {
        return this.httpListenerHelper.addListener(listener, weakLink);
    }

    public void removeListener(HttpListener listener) {
        this.httpListenerHelper.removeListener(listener);
    }

    protected void fireEvent(HttpEvent event) {
        this.httpListenerHelper.fireEvent(event);
    }

    public Charset getDefaultCharset() {
        try {
            this.lock.lock();
            if (this.defCharset == null) {
                this.defCharset = Charset.forName(defaultCharset);
            }
            Charset charset = this.defCharset;
            return charset;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setDefaultCharset(Charset cs) {
        try {
            this.lock.lock();
            this.defCharset = cs;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getUserAgent() {
        try {
            this.lock.lock();
            if (this.userAgent == null) {
                String ver = BuildInfo.getVersion();
                this.userAgent = ver != null ? HttpClient.class.getName() + "/" + ver : HttpClient.class.getName() + "/0.1-SNAPSHOT";
            }
            String string = this.userAgent;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setUserAgent(String userAgent) {
        try {
            this.lock.lock();
            this.userAgent = userAgent;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getConnectTimeout() {
        try {
            this.lock.lock();
            if (this.connectTimeout == null) {
                this.connectTimeout = 30000;
            }
            int n = this.connectTimeout;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setConnectTimeout(int connectTimeoutMS) {
        if (connectTimeoutMS < 0) {
            throw new IllegalArgumentException("connectTimeoutMS<0");
        }
        try {
            this.lock.lock();
            this.connectTimeout = connectTimeoutMS;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getReadTimeout() {
        try {
            this.lock.lock();
            if (this.readTimeout == null) {
                this.readTimeout = 30000;
            }
            int n = this.readTimeout;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setReadTimeout(int readTimeoutMS) {
        if (readTimeoutMS < 0) {
            throw new IllegalArgumentException("readTimeoutMS<0");
        }
        try {
            this.lock.lock();
            this.readTimeout = readTimeoutMS;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ProxySelector getProxySelector() {
        try {
            this.lock.lock();
            if (this.proxySelector == null) {
                this.proxySelector = new SystemProxySelector();
            }
            ProxySelector proxySelector = this.proxySelector;
            return proxySelector;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setProxySelector(ProxySelector proxySelector) {
        try {
            this.lock.lock();
            this.proxySelector = proxySelector;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getResponseThreadPriority() {
        try {
            this.lock.lock();
            if (this.responseThreadPriority == null) {
                this.responseThreadPriority = 1;
            }
            int n = this.responseThreadPriority;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setResponseThreadPriority(int requestThreadPriority) {
        try {
            this.lock.lock();
            this.responseThreadPriority = requestThreadPriority;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Func2<Thread, HttpResponse, Runnable> createResponseThread() {
        HttpClient httpClient = this;
        synchronized (httpClient) {
            return this.defCreateResponseThread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Func2<Thread, HttpDownloader, Runnable> createDownloaderThread() {
        HttpClient httpClient = this;
        synchronized (httpClient) {
            return this.defCreateDownloaderThread;
        }
    }

    public HttpRequest createRequest(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri==null");
        }
        try {
            return new HttpRequest(uri.toURL(), this);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(HttpClient.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public HttpRequest createRequest(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url==null");
        }
        return new HttpRequest(url, this);
    }

    public HttpRequest createRequest(String url) {
        try {
            if (url == null) {
                throw new IllegalArgumentException("url==null");
            }
            return new HttpRequest(new URL(url), this);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(HttpClient.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public HttpDownloader createDownloader(Iterable<HttpRequest> requests) {
        if (requests == null) {
            throw new IllegalArgumentException("requests==null");
        }
        HttpRequest[] reqs = new HttpRequest[]{};
        if (requests != null) {
            for (HttpRequest hr : requests) {
                if (hr == null) continue;
                reqs = Arrays.copyOf(reqs, reqs.length + 1);
                reqs[reqs.length - 1] = hr;
            }
        }
        return new HttpDownloader(new Mirrors(reqs));
    }

    public HttpDownloader createDownloader(HttpRequest request, HttpRequest ... mirrors) {
        if (request == null) {
            throw new IllegalArgumentException("request==null");
        }
        HttpRequest[] reqs = new HttpRequest[]{};
        reqs = Arrays.copyOf(reqs, reqs.length + 1);
        reqs[reqs.length - 1] = request;
        if (mirrors != null) {
            for (HttpRequest hr : mirrors) {
                if (hr == null) continue;
                reqs = Arrays.copyOf(reqs, reqs.length + 1);
                reqs[reqs.length - 1] = hr;
            }
        }
        return new HttpDownloader(new Mirrors(reqs));
    }

    public HttpDownloader createDownloader(Mirrors mirrors) {
        if (mirrors == null) {
            throw new IllegalArgumentException("request==null");
        }
        return new HttpDownloader(mirrors);
    }

    static {
        HttpClient.logFine("init cookie", new Object[0]);
        CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
        TrustManager[] trustAllCertificates = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        HostnameVerifier trustAllHostnames = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        try {
            System.setProperty("jsse.enableSNIExtension", "false");
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCertificates, new SecureRandom());
            HttpClient.logFine("init ssl socket factory", new Object[0]);
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpClient.logFine("init hostname verifier", new Object[0]);
            HttpsURLConnection.setDefaultHostnameVerifier(trustAllHostnames);
        }
        catch (GeneralSecurityException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

