/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http;

import java.io.Closeable;
import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.HttpRetryException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.net.UnknownServiceException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cbuffer.ContentBuffer;
import xyz.cofe.cbuffer.MemContentBuffer;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.set.BasicEventSet;
import xyz.cofe.collection.set.EventSet;
import xyz.cofe.common.CloseableSet;
import xyz.cofe.common.Fragment;
import xyz.cofe.http.ContentFragment;
import xyz.cofe.http.ContentFragments;
import xyz.cofe.http.HttpClient;
import xyz.cofe.http.HttpEvent;
import xyz.cofe.http.HttpHeaders;
import xyz.cofe.http.HttpListener;
import xyz.cofe.http.HttpListenerAdapter;
import xyz.cofe.http.HttpListenersHelper;
import xyz.cofe.http.HttpRequest;
import xyz.cofe.http.HttpResponse;
import xyz.cofe.http.HttpStatusHelper;
import xyz.cofe.http.IsFinished;
import xyz.cofe.http.download.BasicFragmentValidator;
import xyz.cofe.http.download.BindHttpDownloader;
import xyz.cofe.http.download.ContentValidation;
import xyz.cofe.http.download.ContentValidator;
import xyz.cofe.http.download.ContentValidatorEvent;
import xyz.cofe.http.download.ContentValidatorListener;
import xyz.cofe.http.download.ContentValidatorProgressEvent;
import xyz.cofe.http.download.ContentValidatorSender;
import xyz.cofe.http.download.Counter;
import xyz.cofe.http.download.CreatedNewParts;
import xyz.cofe.http.download.EqualsFragments;
import xyz.cofe.http.download.FragmentValidator;
import xyz.cofe.http.download.GetCounters;
import xyz.cofe.http.download.GetPart;
import xyz.cofe.http.download.GetPartBuilder;
import xyz.cofe.http.download.GetPartList;
import xyz.cofe.http.download.IntCounter;
import xyz.cofe.http.download.LongCounter;
import xyz.cofe.http.download.MaxCounter;
import xyz.cofe.http.download.Mirrors;
import xyz.cofe.http.download.OverflowCounter;
import xyz.cofe.http.download.ProgressCounters;
import xyz.cofe.http.download.ResetCounter;
import xyz.cofe.http.download.ResetCounters;
import xyz.cofe.text.Text;

public class HttpDownloader
implements IsFinished,
ResetCounters,
GetCounters {
    private static final Logger logger = Logger.getLogger(HttpDownloader.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected static final AtomicLong sequenceID;
    protected final ReentrantLock lock = new ReentrantLock();
    public final long id = sequenceID.incrementAndGet();
    protected ContentBuffer contentBuffer = null;
    private final Mirrors mirrors;
    protected final HttpListenersHelper httpListenerHelper = new HttpListenersHelper();
    protected boolean followRedirect = true;
    protected long downloadedSize = 0L;
    protected long streamDownloadedSize = 0L;
    protected long contentLength = -1L;
    protected Boolean async = null;
    protected Thread thread = null;
    protected boolean allowParialContent = true;
    protected boolean forcePartialDownload = false;
    protected Boolean serverContinueSupported = null;
    protected int maxParallesGetParts = 1;
    protected volatile ContentValidator contentValidator;
    private final CloseableSet contentValidatorCS = new CloseableSet();
    protected volatile FragmentValidator fragmentValidator;
    private final CloseableSet fragmentValidatorCS = new CloseableSet();
    protected Lock fragmentsLock = new ReentrantLock();
    protected ContentFragments fragments = null;
    protected int defaultFragmentSize = 65536;
    protected Date started = null;
    protected Date finished = null;
    protected State state = State.Prepare;
    protected Signal signal = null;
    private boolean partialMode = false;
    protected static HttpStatusHelper httpStatusHelper;
    private final GetPartList gparts = new GetPartList(this.lock);
    protected EventSet<ContentFragment> validatedFragments = new BasicEventSet();
    private volatile ProgressCounters progressCounters;
    private volatile MaxCounter tryCounter;
    private static final String tryCounterName = "try";
    private volatile MaxCounter tryStartCounter;
    private static final String tryStartCounterName = "try.start";
    private volatile OverflowCounter tryFagmentCounter;
    private static final String tryFragmentCounterName = "try.fragment";
    private volatile MaxCounter multipleErrorsCounter;
    private static final String multipleErrorsCounterName = "try.multipleErrors";
    private volatile MaxCounter unknownHostCounter;
    private static final String unknownHostCounterName = "err.unknownHost";
    private volatile MaxCounter headersNotExistsCounter;
    private static final String headersNotExistsCounterName = "err.headersNotExists";
    private volatile MaxCounter badStatusCounter;
    private static final String badStatusCounterName = "err.badStatus";
    private volatile MaxCounter serverErrorCounter;
    private static final String serverErrorCounterName = "err.serverError";
    private volatile MaxCounter clientErrorCounter;
    private static final String clientErrorCounterName = "err.clientError";
    private volatile MaxCounter infoStatusCounter;
    private static final String infoStatusCounterName = "err.infoStatus";
    private volatile MaxCounter unSupportedStatusCounter;
    private static final String unSupportedStatusCounterName = "err.unSupportedStatus";
    private volatile MaxCounter uriSyntaxErrCounter;
    private static final String uriSyntaxErrCounterName = "err.uriSyntaxErr";
    private volatile MaxCounter unknownServiceCounter;
    private static final String unknownServiceCounterName = "err.unknownService";
    private volatile MaxCounter socketTimeoutCounter;
    private static final String socketTimeoutCounterName = "err.socketTimeout";
    private volatile MaxCounter protocolErrCounter;
    private static final String protocolErrCounterName = "err.protocolException";
    private volatile MaxCounter portUnreachableCounter;
    private static final String portUnreachableCounterName = "err.portUnreachable";
    private volatile MaxCounter malformedURLCounter;
    private static final String malformedURLCounterName = "err.malformedURL";
    private volatile MaxCounter httpRetryCounter;
    private static final String httpRetryCounterName = "err.httpRetry";
    private volatile MaxCounter socketErrCounter;
    private static final String socketErrCounterName = "err.socketException";
    private volatile MaxCounter bindErrCounter;
    private static final String bindErrCounterName = "err.bindException";
    private volatile MaxCounter connectErrCounter;
    private static final String connectErrCounterName = "err.connectException";
    private volatile MaxCounter noRouteToHostCounter;
    private static final String noRouteToHostCounterName = "err.noRouteToHost";
    private volatile LongCounter workTimeCounter;
    private static final String workTimeCounterName = "workTime";
    private volatile IntCounter requestsCounter;
    private static final String requestsCounterName = "requests";
    private volatile boolean countersMapInit = false;
    private final Map<String, Counter> counters = new WeakHashMap<String, Counter>();

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public HttpDownloader(HttpRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request==null");
        }
        this.mirrors = new Mirrors(this.lock, request);
        try {
            request.lock.lock();
            this.contentBuffer = request.contentBuffer;
            this.async = request.async;
            this.followRedirect = request.followRedirect;
            this.addListener(new HttpListenerAdapter(){

                @Override
                protected void downloaderResponse(ResponseEvent event, HttpDownloader downloader, HttpRequest request, HttpResponse response) {
                    HttpDownloader.this.getRequestsCounter().increment();
                }
            });
            this.getProgressCounters();
        }
        finally {
            request.lock.unlock();
        }
    }

    public HttpDownloader(Mirrors mirrors) {
        if (mirrors == null) {
            throw new IllegalArgumentException("mirrors==null");
        }
        if (mirrors.getMirrors().length == 0) {
            throw new IllegalArgumentException("mirrors is empty");
        }
        this.mirrors = mirrors.clone(this.lock);
        this.addListener(new HttpListenerAdapter(){

            @Override
            protected void downloaderResponse(ResponseEvent event, HttpDownloader downloader, HttpRequest request, HttpResponse response) {
                HttpDownloader.this.getRequestsCounter().increment();
            }
        });
        this.getProgressCounters();
    }

    public Lock getLock() {
        return this.lock;
    }

    public void setContentBuffer(ContentBuffer contentBuffer) {
        try {
            this.lock.lock();
            this.contentBuffer = contentBuffer;
            if (isLogFinest) {
                HttpDownloader.logFinest("setContentBuffer( {0} )", contentBuffer);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentBuffer getContentBuffer() {
        try {
            this.lock.lock();
            if (this.contentBuffer == null) {
                HttpRequest[] reqsts = this.mirrors.getMirrors();
                if (reqsts != null) {
                    for (HttpRequest req : reqsts) {
                        ContentBuffer cb;
                        if (req == null || (cb = req.getContentBuffer()) == null) continue;
                        this.contentBuffer = cb;
                        if (!isLogFiner) continue;
                        HttpDownloader.logFiner("create content buffer from request", new Object[0]);
                    }
                }
                if (this.contentBuffer == null) {
                    this.contentBuffer = new MemContentBuffer();
                    if (isLogFiner) {
                        HttpDownloader.logFiner("create content buffer in memory", new Object[0]);
                    }
                }
            }
            ContentBuffer contentBuffer = this.contentBuffer;
            return contentBuffer;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Mirrors getMirrors() {
        return this.mirrors;
    }

    public Set<HttpListener> getListeners() {
        if (isLogFinest) {
            HttpDownloader.logFinest("getListeners()", new Object[0]);
        }
        return this.httpListenerHelper.getListeners();
    }

    public Closeable addListener(HttpListener listener) {
        HttpDownloader.logFiner("addListener( {0} )", listener);
        Closeable c = this.httpListenerHelper.addListener(listener);
        return c;
    }

    public Closeable addListener(HttpListener listener, boolean weakLink) {
        HttpDownloader.logFiner("addListener( {0}, {1} )", listener, weakLink);
        Closeable c = this.httpListenerHelper.addListener(listener, weakLink);
        return c;
    }

    public void removeListener(HttpListener listener) {
        HttpDownloader.logFiner("removeListener( {0}, {1} )", listener);
        this.httpListenerHelper.removeListener(listener);
    }

    public void fireEvent(HttpEvent event) {
        if (isLogFinest) {
            HttpDownloader.logFinest("fireEvent( {0}, {1} )", event);
        }
        this.httpListenerHelper.fireEvent(event);
    }

    public boolean isFollowRedirect() {
        try {
            this.lock.lock();
            boolean bl = this.followRedirect;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setFollowRedirect(boolean followRedirect) {
        try {
            this.lock.lock();
            this.followRedirect = followRedirect;
            HttpDownloader.logFiner("setFollowRedirect( {0} )", followRedirect);
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getPartialDownloadedSize() {
        try {
            this.lock.lock();
            long l = this.getFragments().getTotalDownloadedSize();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDownloadedSize() {
        try {
            this.lock.lock();
            if (this.isPartialMode()) {
                long s = this.getFragments().getTotalDownloadedSize();
                if (isLogFinest) {
                    HttpDownloader.logFinest("getDownloadedSize() = {0} partial mode", s);
                }
                long l = s;
                return l;
            }
            long s = this.streamDownloadedSize;
            if (isLogFinest) {
                HttpDownloader.logFinest("getDownloadedSize() = {0} stream mode", s);
            }
            long l = s;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void setStreamDownloadedSize(long size) {
        try {
            this.lock.lock();
            this.streamDownloadedSize = size;
            HttpDownloader.logFiner("setStreamDownloadedSize( {0} )", size);
        }
        finally {
            this.lock.unlock();
        }
        this.fireEvent(new ProgressEvent(this));
    }

    public long getStreamDownloadedSize() {
        try {
            this.lock.lock();
            long l = this.streamDownloadedSize;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getContentLength() {
        return this.contentLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalSize() {
        try {
            this.lock.lock();
            if (this.isPartialMode()) {
                long s = this.getFragments().getTotalSize();
                if (isLogFinest) {
                    HttpDownloader.logFinest("getTotalSize() = {0} partial mode()", s);
                }
                long l = s;
                return l;
            }
            long s = this.getContentLength();
            if (isLogFinest) {
                HttpDownloader.logFinest("getTotalSize() = {0} stream mode", s);
            }
            long l = s;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAsync() {
        try {
            this.lock.lock();
            if (this.async == null) {
                HttpRequest[] reqsts = this.mirrors.getMirrors();
                if (reqsts != null) {
                    for (HttpRequest req : reqsts) {
                        if (req == null) continue;
                        this.async = req.isAsync();
                    }
                }
                if (this.async == null) {
                    this.async = false;
                }
            }
            if (isLogFinest) {
                HttpDownloader.logFinest("set async = {0}", this.async);
            }
            boolean bl = this.async;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setAsync(boolean async) {
        try {
            this.lock.lock();
            this.async = async;
            HttpDownloader.logFiner("setAsync( {0} )", async);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Thread getThread() {
        return this.thread;
    }

    public boolean isAllowParialContent() {
        try {
            this.lock.lock();
            boolean bl = this.allowParialContent;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setAllowParialContent(boolean allowParialContent) {
        try {
            this.lock.lock();
            this.allowParialContent = allowParialContent;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isForcePartialDownload() {
        try {
            this.lock.lock();
            boolean bl = this.forcePartialDownload;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setForcePartialDownload(boolean forcePartialDownload) {
        try {
            this.lock.lock();
            this.forcePartialDownload = forcePartialDownload;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Boolean isServerContinueSupported() {
        try {
            this.lock.lock();
            Boolean bl = this.serverContinueSupported;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void setServerContinueSupported(Boolean serverContinueSupported) {
        try {
            this.lock.lock();
            this.serverContinueSupported = serverContinueSupported;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getMaxParallesGetParts() {
        try {
            this.lock.lock();
            int n = this.maxParallesGetParts;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setMaxParallesGetParts(int maxParallesGetParts) {
        if (maxParallesGetParts < 1) {
            throw new IllegalArgumentException("maxParallesGetParts<1");
        }
        try {
            this.lock.lock();
            this.maxParallesGetParts = maxParallesGetParts;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ContentValidator getContentValidator() {
        try {
            this.lock.lock();
            ContentValidator contentValidator = this.contentValidator;
            return contentValidator;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setContentValidator(ContentValidator cv) {
        try {
            Closeable cl;
            this.lock.lock();
            this.contentValidatorCS.closeAll();
            this.contentValidator = cv;
            if (cv instanceof BindHttpDownloader && (cl = ((BindHttpDownloader)((Object)cv)).bindHttpDownloader(this)) != null) {
                this.contentValidatorCS.add(cl);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public FragmentValidator getFragmentValidator() {
        FragmentValidator fv = this.fragmentValidator;
        if (fv != null) {
            return fv;
        }
        try {
            Closeable cl;
            this.lock.lock();
            this.fragmentValidatorCS.closeAll();
            fv = this.fragmentValidator;
            if (fv == null && (fv = (this.fragmentValidator = new BasicFragmentValidator())) instanceof BindHttpDownloader && (cl = ((BindHttpDownloader)((Object)fv)).bindHttpDownloader(this)) != null) {
                this.fragmentValidatorCS.add(cl);
            }
        }
        finally {
            this.lock.unlock();
        }
        return fv;
    }

    public void setFragmentValidator(FragmentValidator fv) {
        try {
            Closeable cl;
            this.lock.lock();
            this.fragmentValidatorCS.closeAll();
            this.fragmentValidator = fv;
            if (fv instanceof BindHttpDownloader && (cl = ((BindHttpDownloader)((Object)fv)).bindHttpDownloader(this)) != null) {
                this.fragmentValidatorCS.add(cl);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public ContentFragments getFragments() {
        try {
            this.lock.lock();
            if (this.fragments == null) {
                this.fragments = new ContentFragments(this.fragmentsLock);
            }
            ContentFragments contentFragments = this.fragments;
            return contentFragments;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void setFragments(ContentFragments fragments) {
        if (fragments == null) {
            throw new IllegalArgumentException("fragments==null");
        }
        try {
            this.lock.lock();
            this.fragments = fragments;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContentFragment createFragment(long begin, long end) {
        try {
            this.lock.lock();
            ContentFragment contentFragment = new ContentFragment(begin, end, this.getFragments().getLock());
            return contentFragment;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getDefaultFragmentSize() {
        try {
            this.lock.lock();
            int n = this.defaultFragmentSize;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setDefaultFragmentSize(int defFragmentSize) {
        if (defFragmentSize < 1) {
            throw new IllegalArgumentException("defFragmentSize<1");
        }
        try {
            this.lock.lock();
            this.defaultFragmentSize = defFragmentSize;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Date getStarted() {
        return this.started;
    }

    public Date getFinished() {
        return this.finished;
    }

    public State getState() {
        return this.state;
    }

    protected void setState(State newState) {
        State old = null;
        try {
            this.lock.lock();
            old = this.state;
            this.state = newState;
            if (old != newState) {
                if (State.Starting.equals((Object)newState)) {
                    this.started = new Date();
                }
                if (State.Finished.equals((Object)newState)) {
                    this.finished = new Date();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        this.fireEvent(new StateChangedEvent(this, old, newState));
    }

    protected StateChangedEvent setStateAndRetEvent(State newState) {
        State old = null;
        try {
            this.lock.lock();
            old = this.state;
            this.state = newState;
            if (old != newState) {
                if (State.Starting.equals((Object)newState)) {
                    this.started = new Date();
                }
                if (State.Finished.equals((Object)newState)) {
                    this.finished = new Date();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return new StateChangedEvent(this, old, newState);
    }

    @Override
    public boolean isFinished() {
        try {
            this.lock.lock();
            boolean bl = State.Finished.equals((Object)this.state);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Signal getSignal() {
        try {
            this.lock.lock();
            Signal signal = this.signal;
            return signal;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void setSignal(Signal signal) {
        try {
            this.lock.lock();
            this.signal = signal;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Signal checkSignal() {
        try {
            this.lock.lock();
            Signal s = this.signal;
            this.signal = null;
            Signal signal = s;
            return signal;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void pause() {
        this.setSignal(Signal.Pause);
    }

    public void resume() {
        this.setSignal(Signal.Resume);
    }

    public boolean isPartialMode() {
        return this.partialMode;
    }

    protected void setPartialMode(boolean mode) {
        this.partialMode = mode;
    }

    public void start() {
        this.start(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ContentFragments fragments) {
        StateChangedEvent ev = null;
        try {
            this.lock.lock();
            State s = this.getState();
            switch (s) {
                case Prepare: 
                case Finished: {
                    break;
                }
                default: {
                    throw new IllegalStateException("state not in ( Prepare, Finished )");
                }
            }
            this.setPartialMode(false);
            this.resetCounters();
            StringBuilder sbStartUrls = new StringBuilder();
            for (HttpRequest req : this.mirrors.getMirrors()) {
                URL u;
                if (req == null || (u = req.getUrl()) == null) continue;
                if (sbStartUrls.length() > 0) {
                    sbStartUrls.append(", ");
                }
                sbStartUrls.append(u.toString());
            }
            HttpDownloader.logFine("start {0}", sbStartUrls.toString());
            ev = this.setStateAndRetEvent(State.Starting);
            final ContentFragments cfs = fragments;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    HttpDownloader.this.run(HttpDownloader.this.mirrors, cfs);
                }
            };
            if (this.isAsync()) {
                HttpClient hc = null;
                HttpRequest[] reqsts = this.mirrors.getMirrors();
                if (reqsts != null) {
                    for (HttpRequest req : reqsts) {
                        if (req == null) continue;
                        hc = req.getHttpClient();
                        break;
                    }
                }
                if (hc == null) {
                    hc = new HttpClient();
                }
                this.thread = (Thread)hc.createDownloaderThread().apply((Object)this, (Object)r);
                this.thread.start();
            } else {
                r.run();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (ev != null) {
            this.fireEvent(ev);
        }
    }

    protected void run(final Mirrors mirrors, ContentFragments fragments) {
        if (mirrors == null) {
            throw new IllegalArgumentException("mirrors==null");
        }
        State thisState = State.Starting;
        CatchFirstStatus sts = null;
        int cycleCount = 0;
        int nrequest = 0;
        while (true) {
            HttpResponse res;
            HttpRequest request;
            block15: {
                ++cycleCount;
                final Mirrors.NRequest nreq = mirrors.getNRequest(nrequest);
                request = nreq.getRequest();
                if (Thread.interrupted()) {
                    this.finishStreamDownload();
                    return;
                }
                Signal s = this.checkSignal();
                if (Signal.Pause.equals((Object)s)) {
                    this.setState(State.Pause);
                    while (true) {
                        if ((s = this.checkSignal()) == null) {
                            continue;
                        }
                        if (Signal.Resume.equals((Object)s)) {
                            this.setState(thisState);
                            break;
                        }
                        Thread.yield();
                    }
                }
                HttpDownloader.logFine("run {0}", request.getUrl());
                HttpRequest req = request;
                req.setContentBuffer(this.getContentBuffer());
                req.setContentOffsetStart(0L);
                req.getHttpHeaders().setRangeHeader(null);
                req.setAsync(true);
                res = req.createResponse();
                res.setFollowRedirect(this.isFollowRedirect());
                HttpListenerAdapter redirectListener = new HttpListenerAdapter(){

                    @Override
                    protected void responseRedirect(HttpResponse.RedirectEvent event, HttpResponse response, URL from, URL to) {
                        RedirectEvent re = new RedirectEvent(HttpDownloader.this, from, to);
                        HttpDownloader.this.fireEvent(re);
                        if (mirrors != null) {
                            mirrors.redirect(nreq.getMirrorId(), from, to);
                        }
                    }
                };
                res.addListener(redirectListener);
                this.fireEvent(new ResponseEvent(this, request, res));
                res.start();
                while (true) {
                    sts = null;
                    if (Thread.interrupted()) {
                        res.stop();
                        this.finishStreamDownload();
                        return;
                    }
                    s = this.checkSignal();
                    if (Signal.Pause.equals((Object)s)) {
                        res.pause();
                        this.setState(State.Pause);
                        while (true) {
                            if ((s = this.checkSignal()) == null) {
                                continue;
                            }
                            if (Signal.Resume.equals((Object)s)) {
                                res.resume();
                                this.setState(thisState);
                                break;
                            }
                            Thread.yield();
                        }
                    }
                    if (res.isFinished()) break block15;
                    HttpResponse.State st = res.getState();
                    if (!HttpResponse.State.Downloading.equals((Object)st)) {
                        Thread.yield();
                        continue;
                    }
                    HttpHeaders hh = res.getHttpHeaders();
                    if (hh != null) break;
                }
                sts = this.catchFirstResponse(mirrors, request, res, fragments);
            }
            if (sts == null) {
                sts = this.catchFirstResponse(mirrors, request, res, fragments);
            }
            if (sts == null || !sts.isRepeat()) break;
            ++nrequest;
        }
    }

    protected CatchFirstStatus catchFirstResponse(Mirrors mirrors, HttpRequest request, HttpResponse response, ContentFragments fragments) {
        int statusCode = response.getStatusCode();
        HttpHeaders resHH = response.getHttpHeaders();
        if (HttpResponse.State.Finished.equals((Object)response.getState()) && response.getErrors().size() > 0) {
            String errMessage = "";
            int errCount = response.getErrors().size();
            HttpDownloader.logFine("response has errors ({0}):", errCount);
            int i = -1;
            for (Throwable err : response.getErrors()) {
                HttpDownloader.logFine("response error {0}/{1}: {2}", ++i + 1, errCount, err.getMessage());
                errMessage = errMessage + (errMessage.length() > 0 ? "\n" : "") + (i + 1) + "/" + response.getErrors().size() + " " + err.getClass().getName() + ":" + err.getMessage();
            }
            if (!response.isFinished()) {
                response.stop();
            }
            if (errCount == 1) {
                MaxCounter tct;
                MaxCounter sct;
                Throwable err = response.getErrors().get(0);
                if (err instanceof UnknownHostException) {
                    sct = this.getTryStartCounter().increment();
                    MaxCounter tct2 = this.getTryCounter().increment();
                    MaxCounter cnt = this.getUnknownHostCounter().increment();
                    if (!(cnt.overflow() || tct2.overflow() || sct.overflow())) {
                        this.fireEvent(new RetryEvent(this, "retry " + cnt.get() + "/" + cnt.getMax() + " on " + err.getClass().getName() + ": " + err.getMessage()));
                        return new CatchFirstStatus(true);
                    }
                } else if (err instanceof URISyntaxException) {
                    sct = this.getTryStartCounter().increment();
                    MaxCounter tct3 = this.getTryCounter().increment();
                    MaxCounter cnt = this.getUriSyntaxErrCounter().increment();
                    if (!(cnt.overflow() || tct3.overflow() || sct.overflow())) {
                        this.fireEvent(new RetryEvent(this, "retry " + cnt.get() + "/" + cnt.getMax() + " on " + err.getClass().getName() + ": " + err.getMessage()));
                        return new CatchFirstStatus(true);
                    }
                } else if (err instanceof UnknownServiceException) {
                    tct = this.getTryCounter().increment();
                    MaxCounter cnt = this.getUnknownServiceCounter().increment();
                    MaxCounter sct2 = this.getTryStartCounter().increment();
                    if (!(cnt.overflow() || tct.overflow() || sct2.overflow())) {
                        this.fireEvent(new RetryEvent(this, "retry " + cnt.get() + "/" + cnt.getMax() + " on " + err.getClass().getName() + ": " + err.getMessage()));
                        return new CatchFirstStatus(true);
                    }
                } else if (err instanceof SocketTimeoutException) {
                    tct = this.getTryCounter().increment();
                    MaxCounter cnt = this.getSocketTimeoutCounter().increment();
                    MaxCounter sct3 = this.getTryStartCounter().increment();
                    if (!(cnt.overflow() || tct.overflow() || sct3.overflow())) {
                        this.fireEvent(new RetryEvent(this, "retry " + cnt.get() + "/" + cnt.getMax() + " on " + err.getClass().getName() + ": " + err.getMessage()));
                        return new CatchFirstStatus(true);
                    }
                } else if (err instanceof ProtocolException) {
                    tct = this.getTryCounter().increment();
                    MaxCounter cnt = this.getProtocolErrCounter().increment();
                    MaxCounter sct4 = this.getTryStartCounter().increment();
                    if (!(cnt.overflow() || tct.overflow() || sct4.overflow())) {
                        this.fireEvent(new RetryEvent(this, "retry " + cnt.get() + "/" + cnt.getMax() + " on " + err.getClass().getName() + ": " + err.getMessage()));
                        return new CatchFirstStatus(true);
                    }
                } else if (err instanceof PortUnreachableException) {
                    tct = this.getTryCounter().increment();
                    MaxCounter cnt = this.getPortUnreachableCounter().increment();
                    MaxCounter sct5 = this.getTryStartCounter().increment();
                    if (!(cnt.overflow() || tct.overflow() || sct5.overflow())) {
                        this.fireEvent(new RetryEvent(this, "retry " + cnt.get() + "/" + cnt.getMax() + " on " + err.getClass().getName() + ": " + err.getMessage()));
                        return new CatchFirstStatus(true);
                    }
                } else if (err instanceof NoRouteToHostException) {
                    tct = this.getTryCounter().increment();
                    MaxCounter cnt = this.getNoRouteToHostCounter().increment();
                    MaxCounter sct6 = this.getTryStartCounter().increment();
                    if (!(cnt.overflow() || tct.overflow() || sct6.overflow())) {
                        this.fireEvent(new RetryEvent(this, "retry " + cnt.get() + "/" + cnt.getMax() + " on " + err.getClass().getName() + ": " + err.getMessage()));
                        return new CatchFirstStatus(true);
                    }
                } else if (err instanceof MalformedURLException) {
                    tct = this.getTryCounter().increment();
                    MaxCounter cnt = this.getMalformedURLCounter().increment();
                    MaxCounter sct7 = this.getTryStartCounter().increment();
                    if (!(cnt.overflow() || tct.overflow() || sct7.overflow())) {
                        this.fireEvent(new RetryEvent(this, "retry " + cnt.get() + "/" + cnt.getMax() + " on " + err.getClass().getName() + ": " + err.getMessage()));
                        return new CatchFirstStatus(true);
                    }
                } else if (err instanceof HttpRetryException) {
                    tct = this.getTryCounter().increment();
                    MaxCounter cnt = this.getHttpRetryCounter().increment();
                    MaxCounter sct8 = this.getTryStartCounter().increment();
                    if (!(cnt.overflow() || tct.overflow() || sct8.overflow())) {
                        this.fireEvent(new RetryEvent(this, "retry " + cnt.get() + "/" + cnt.getMax() + " on " + err.getClass().getName() + ": " + err.getMessage()));
                        return new CatchFirstStatus(true);
                    }
                } else if (err instanceof ConnectException) {
                    tct = this.getTryCounter().increment();
                    MaxCounter cnt = this.getConnectErrCounter().increment();
                    MaxCounter sct9 = this.getTryStartCounter().increment();
                    if (!(cnt.overflow() || tct.overflow() || sct9.overflow())) {
                        this.fireEvent(new RetryEvent(this, "retry " + cnt.get() + "/" + cnt.getMax() + " on " + err.getClass().getName() + ": " + err.getMessage()));
                        return new CatchFirstStatus(true);
                    }
                } else if (err instanceof BindException) {
                    tct = this.getTryCounter().increment();
                    MaxCounter cnt = this.getBindErrCounter().increment();
                    MaxCounter sct10 = this.getTryStartCounter().increment();
                    if (!(cnt.overflow() || tct.overflow() || sct10.overflow())) {
                        this.fireEvent(new RetryEvent(this, "retry " + cnt.get() + "/" + cnt.getMax() + " on " + err.getClass().getName() + ": " + err.getMessage()));
                        return new CatchFirstStatus(true);
                    }
                } else if (err instanceof SocketException) {
                    tct = this.getTryCounter().increment();
                    MaxCounter cnt = this.getSocketErrCounter().increment();
                    MaxCounter sct11 = this.getTryStartCounter().increment();
                    if (!(cnt.overflow() || tct.overflow() || sct11.overflow())) {
                        this.fireEvent(new RetryEvent(this, "retry " + cnt.get() + "/" + cnt.getMax() + " on " + err.getClass().getName() + ": " + err.getMessage()));
                        return new CatchFirstStatus(true);
                    }
                }
            } else {
                MaxCounter tct = this.getTryCounter().increment();
                MaxCounter cnt = this.getMultipleErrorsCounter().increment();
                MaxCounter sct = this.getTryStartCounter().increment();
                if (!(cnt.overflow() || tct.overflow() || sct.overflow())) {
                    this.fireEvent(new RetryEvent(this, "retry " + cnt.get() + "/" + cnt.getMax() + " on " + errMessage));
                    return new CatchFirstStatus(true);
                }
            }
            this.finishAsError("response error = " + errMessage);
            return new CatchFirstStatus(false);
        }
        if (resHH == null) {
            HttpDownloader.logFine("no response headers, stop response", new Object[0]);
            if (!response.isFinished()) {
                response.stop();
            }
            MaxCounter tct = this.getTryCounter().increment();
            MaxCounter cnt = this.getHeadersNotExistsCounter().increment();
            MaxCounter sct = this.getTryStartCounter().increment();
            if (!(cnt.overflow() || tct.overflow() || sct.overflow())) {
                this.fireEvent(new RetryEvent(this, "retry " + cnt.get() + "/" + cnt.getMax() + " on no response headers"));
                return new CatchFirstStatus(true);
            }
            this.finishAsError("server error, status code = " + statusCode);
            return new CatchFirstStatus(false);
        }
        if (statusCode == -1) {
            HttpDownloader.logFine("status code = -1, stop response", new Object[0]);
            if (!response.isFinished()) {
                response.stop();
            }
            MaxCounter tct = this.getTryCounter().increment();
            MaxCounter cnt = this.getBadStatusCounter().increment();
            MaxCounter sct = this.getTryStartCounter().increment();
            if (!(cnt.overflow() || tct.overflow() || sct.overflow())) {
                this.fireEvent(new RetryEvent(this, "retry " + cnt.get() + "/" + cnt.getMax() + " on status code = -1"));
                return new CatchFirstStatus(true);
            }
            this.finishAsError("server error, status code = " + statusCode);
            return new CatchFirstStatus(false);
        }
        this.contentLength = resHH.getContentLength();
        HttpDownloader.logFine("content length = {0}", this.contentLength);
        HttpDownloader.logFine("catchFirstResponse\n  url = {2}  status = {0}\n{1}", statusCode, Text.indent((String)response.getHttpHeaders().toString(), (String)"\n", (String)"[Response] "), request.getUrl());
        String statusMessage = response.getStatusMessage();
        if (httpStatusHelper.isSuccess(statusCode)) {
            boolean suppContinue = HttpDownloader.isSupportedContinueDownload(response);
            this.setServerContinueSupported(suppContinue);
            if (suppContinue && this.isForcePartialDownload()) {
                this.switchPartialDownload(mirrors, request, response, fragments);
            } else {
                this.continueStreamDownload(request, response);
            }
        } else if (httpStatusHelper.isServerError(statusCode)) {
            if (!response.isFinished()) {
                response.stop();
            }
            MaxCounter tct = this.getTryCounter().increment();
            MaxCounter cnt = this.getServerErrorCounter().increment();
            MaxCounter sct = this.getTryStartCounter().increment();
            if (!(cnt.overflow() || tct.overflow() || sct.overflow())) {
                this.fireEvent(new RetryEvent(this, "retry " + cnt.get() + "/" + cnt.getMax() + " on server error = " + statusCode + " " + statusMessage));
                return new CatchFirstStatus(true);
            }
            this.finishAsError("server error, status code = " + statusCode + " " + statusMessage);
        } else if (httpStatusHelper.isClientError(statusCode)) {
            if (!response.isFinished()) {
                response.stop();
            }
            MaxCounter tct = this.getTryCounter().increment();
            MaxCounter cnt = this.getClientErrorCounter().increment();
            MaxCounter sct = this.getTryStartCounter().increment();
            if (!(cnt.overflow() || tct.overflow() || sct.overflow())) {
                this.fireEvent(new RetryEvent(this, "retry " + cnt.get() + "/" + cnt.getMax() + " on client error = " + statusCode + " " + statusMessage));
                return new CatchFirstStatus(true);
            }
            this.finishAsError("client error, status code = " + statusCode + " " + statusMessage);
        } else if (httpStatusHelper.isInfoStatus(statusCode)) {
            if (!response.isFinished()) {
                response.stop();
            }
            MaxCounter tct = this.getTryCounter().increment();
            MaxCounter sct = this.getTryStartCounter().increment();
            MaxCounter cnt = this.getInfoStatusCounter().increment();
            if (!(cnt.overflow() || tct.overflow() || sct.overflow())) {
                this.fireEvent(new RetryEvent(this, "retry " + "err.infoStatus=" + cnt.get() + "/" + cnt.getMax() + " try.start=" + sct.get() + "/" + sct.getMax() + " try=" + tct.get() + "/" + tct.getMax() + " on info status = " + statusCode + " " + statusMessage));
                return new CatchFirstStatus(true);
            }
            this.finishAsError("info response status code = " + statusCode + " " + statusMessage);
        } else {
            if (!response.isFinished()) {
                response.stop();
            }
            MaxCounter tct = this.getTryCounter().increment();
            MaxCounter sct = this.getTryStartCounter().increment();
            MaxCounter cnt = this.getUnSupportedStatusCounter().increment();
            if (!(cnt.overflow() || tct.overflow() || sct.overflow())) {
                this.fireEvent(new RetryEvent(this, "retry " + "err.unSupportedStatus=" + cnt.get() + "/" + cnt.getMax() + " try.start=" + sct.get() + "/" + sct.getMax() + " try=" + tct.get() + "/" + tct.getMax() + " on unknow status = " + statusCode + " " + statusMessage));
                return new CatchFirstStatus(true);
            }
            this.finishAsError("un supported response status code = " + statusCode + " " + statusMessage);
        }
        return new CatchFirstStatus(false);
    }

    public static boolean isSupportedContinueDownload(HttpResponse response) {
        HttpHeaders hh = response.getHttpHeaders();
        String acptRngs = hh.getAcceptRanges();
        long contentLen = hh.getContentLength();
        return acptRngs != null && acptRngs.trim().equalsIgnoreCase("bytes") && contentLen >= 0L;
    }

    protected void switchPartialDownload(Mirrors mirrors, HttpRequest request, HttpResponse firstRes, ContentFragments fragments) {
        HttpDownloader.logFine("switchPartialDownload", new Object[0]);
        this.setState(State.SwitchPartialDownloading);
        HttpDownloader.logFine("stop first response", new Object[0]);
        if (!firstRes.isFinished()) {
            firstRes.stop();
        }
        this.downloadedSize = firstRes.getDownloadedSize();
        HttpDownloader.logFine("stream downloaded {0} total {1}", this.downloadedSize, this.contentLength);
        this.fireEvent(new ProgressEvent(this));
        if (this.downloadedSize >= this.contentLength) {
            this.finishStreamDownload();
            return;
        }
        if (fragments == null) {
            EqualsFragments initFragments = new EqualsFragments(this);
            initFragments.initFragments(this.getFragments(), firstRes, this.contentLength);
            HttpDownloader.logFinest("fragments:\n{0}", this.getFragments());
        } else {
            this.setFragments(fragments);
        }
        this.continuePartialDownload(mirrors, request);
    }

    protected void continuePartialDownload(Mirrors mirrors, HttpRequest request) {
        this.setState(State.DownloadingPartial);
        this.setPartialMode(true);
        GetPartBuilder gpBuilder = this.createGetPartBuilder(mirrors, request);
        WeakHashMap<GetPart, ContentFragment> getPartFragment = new WeakHashMap<GetPart, ContentFragment>();
        WeakHashMap<ContentFragment, GetPart> fragmentGetPart = new WeakHashMap<ContentFragment, GetPart>();
        this.gparts.clear();
        LinkedBlockingQueue<Runnable> qe = new LinkedBlockingQueue<Runnable>();
        while (true) {
            this.fireQueueEvents(qe);
            if (this.checkStopSignal(this.gparts, getPartFragment)) {
                return;
            }
            this.checkPauseSignal(this.gparts);
            if (this.checkFinishedParts(this.gparts, getPartFragment, fragmentGetPart)) {
                this.gparts.stopAll();
                this.finishPartialDownload();
                return;
            }
            List<ContentFragment> lfragments = this.getFragments().getNotDownloaded();
            if (lfragments.isEmpty() && this.gparts.isEmpty()) break;
            if (!lfragments.isEmpty()) {
                this.createNewParts(lfragments, this.gparts, gpBuilder, fragmentGetPart, getPartFragment, qe);
            }
            Thread.yield();
        }
        this.gparts.stopAll();
        ContentValidator cv = this.getContentValidator();
        if (cv != null) {
            this.validateContent(mirrors, request, cv);
            return;
        }
        this.finishPartialDownload();
    }

    protected GetPartBuilder createGetPartBuilder(Mirrors mirrors, HttpRequest request) {
        GetPartBuilder gpBuilder = new GetPartBuilder(this, mirrors, request, this.getContentBuffer());
        return gpBuilder;
    }

    public GetPart[] getGetParts() {
        return this.gparts.toArray(new GetPart[0]);
    }

    protected CreatedNewParts createNewParts(List<ContentFragment> lfragments, GetPartList gparts, GetPartBuilder gpBuilder, WeakHashMap<ContentFragment, GetPart> fragmentGetPart, WeakHashMap<GetPart, ContentFragment> getPartFragment, Queue<Runnable> qe) {
        CreatedNewParts res = new CreatedNewParts();
        res.createdGetParts = new LinkedHashMap<GetPart, ContentFragment>();
        res.skippedFragmentsInWork = new LinkedHashSet<ContentFragment>();
        res.skippedFragmentsInWorkMap = new LinkedHashMap<GetPart, ContentFragment>();
        for (GetPart gp : gparts.toArray(new GetPart[0])) {
            if (gp.isFinished()) continue;
            for (ContentFragment cf : lfragments.toArray(new ContentFragment[0])) {
                if (!cf.equalsRange(gp.getFragment())) continue;
                lfragments.remove(cf);
            }
        }
        if (!lfragments.isEmpty()) {
            int max_paralles_get_parts = this.getMaxParallesGetParts();
            if (gparts.size() < max_paralles_get_parts) {
                int newParallesCO = max_paralles_get_parts - gparts.size();
                for (int i = 0; i < newParallesCO && !lfragments.isEmpty(); ++i) {
                    ContentFragment cf = lfragments.get(0);
                    lfragments.remove(cf);
                    GetPart gp = gpBuilder.getPart(cf);
                    gparts.add(gp);
                    res.createdGetParts.put(gp, cf);
                    getPartFragment.put(gp, cf);
                    fragmentGetPart.put(cf, gp);
                    this.addGetPartProgressListener(qe, gp, cf);
                    gp.start();
                    HttpDownloader.logFiner("start getpart {0}" + cf, new Object[0]);
                    this.fireEvent(new GetPartStartedEvent(this, gp, cf));
                    HttpResponse gpres = gp.getResponse();
                    if (gpres == null) continue;
                    this.fireEvent(new ResponseEvent(this, gp.getRequest(), gpres));
                }
            }
        }
        return res;
    }

    protected void repeatDownload(ContentFragment cf) {
        cf.setDownloadedSize(0L);
        if (isLogFiner) {
            HttpDownloader.logFiner("repeat {0}", cf);
        }
        if (isLogFinest) {
            HttpDownloader.logFinest("fragments:\n{0}", this.getFragments());
        }
        this.fireEvent(new RepeatFragmentEvent(this, cf));
    }

    protected void skipDownload(ContentFragment cf) {
        cf.setDownloadedSize(cf.getSize());
        if (isLogFiner) {
            HttpDownloader.logFiner("skip {0}", cf);
        }
        if (isLogFinest) {
            HttpDownloader.logFinest("fragments:\n{0}", this.getFragments());
        }
        this.fireEvent(new SkippedFragmentEvent(this, cf));
    }

    protected void markDownloaded(ContentFragment cf) {
        cf.setDownloadedSize(cf.getSize());
        if (isLogFiner) {
            HttpDownloader.logFiner("downloaded {0}", cf);
        }
        if (isLogFinest) {
            HttpDownloader.logFinest("fragments:\n{0}", this.getFragments());
        }
        this.fireEvent(new DownloadedFragmentEvent(this, cf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkFinishedParts(GetPartList gparts, WeakHashMap<GetPart, ContentFragment> getPartFragment, WeakHashMap<ContentFragment, GetPart> fragmentGetPart) {
        ContentFragment cf;
        FragmentValidator fragmentValidator = this.getFragmentValidator();
        for (GetPart gpart : gparts.toArray(new GetPart[0])) {
            if (gpart.isFinished()) {
                block20: {
                    cf = getPartFragment.get(gpart);
                    try {
                        if (cf == null) break block20;
                        try {
                            boolean valid = fragmentValidator.validate(gpart, cf);
                            if (!valid) {
                                OverflowCounter inc = this.getTryFagmentCounter().increment();
                                MaxCounter tct = this.getTryCounter().increment();
                                if (tct.overflow()) {
                                    throw new Error("overflow try counter (current=" + tct.get() + " max=" + tct.getMax() + ")");
                                }
                                if (inc.overflow()) {
                                    switch (inc.getOverflowAction()) {
                                        case Skip: {
                                            this.skipDownload(cf);
                                            break;
                                        }
                                        case Stop: {
                                            HttpDownloader.logFine("repeat overflow (count={0}, max={1})", inc.get(), inc.getMax());
                                            this.fireEvent(new RepeatOverflowEvent(this, (Integer)inc.get(), inc.getMax()));
                                            boolean bl = true;
                                            return bl;
                                        }
                                    }
                                    break block20;
                                } else {
                                    this.repeatDownload(cf);
                                }
                                break block20;
                            }
                            this.markDownloaded(cf);
                        }
                        catch (Throwable err) {
                            HttpDownloader.logException(err);
                            this.fireEvent(new FragmentErrorEvent(this, fragmentValidator, cf, gpart, err));
                            boolean bl = true;
                            gparts.remove(gpart);
                            getPartFragment.remove(gpart);
                            return bl;
                        }
                    }
                    finally {
                        gparts.remove(gpart);
                        getPartFragment.remove(gpart);
                    }
                }
                this.fireEvent(new GetPartFinishedEvent(this, gpart, cf));
            }
            this.fireEvent(new ProgressEvent(this));
        }
        GetPart[] getPartArray = getPartFragment.keySet().toArray(new GetPart[0]);
        int n = getPartArray.length;
        int n2 = 0;
        while (n2 < n) {
            GetPart gp = getPartArray[n2];
            if (gp != null && gp.isFinished()) {
                cf = getPartFragment.get(gp);
                getPartFragment.remove(gp);
                if (cf != null) {
                    fragmentGetPart.remove(cf);
                }
            }
            ++n2;
        }
        return false;
    }

    public EventSet<ContentFragment> getValidatedFragments() {
        return this.validatedFragments;
    }

    /*
     * WARNING - void declaration
     */
    protected void validateContent(Mirrors mirrors, HttpRequest request, ContentValidator cv) {
        void var13_27;
        LinkedHashSet<ContentFragment> valids;
        LinkedHashSet<ContentFragment> badFragments;
        ContentValidation cvres;
        if (cv == null) {
            this.finishPartialDownload();
            return;
        }
        ContentFragments cfs = this.getFragments();
        if (cfs == null) {
            this.finishPartialDownload();
            return;
        }
        ContentBuffer cbuff = this.getContentBuffer();
        if (cbuff == null) {
            this.finishPartialDownload();
            return;
        }
        this.setState(State.Validate);
        CloseableSet cscv = new CloseableSet();
        if (cv instanceof ContentValidatorSender) {
            ContentValidatorListener lst = new ContentValidatorListener(){

                @Override
                public void contentValidatorEvent(ContentValidatorEvent event) {
                    if (event != null && event instanceof ContentValidatorProgressEvent) {
                        ContentValidatorProgressEvent pe = (ContentValidatorProgressEvent)event;
                        ContentValidateProgressEvent cvpe = new ContentValidateProgressEvent(HttpDownloader.this, pe);
                        HttpDownloader.this.fireEvent(cvpe);
                    }
                }
            };
            cscv.add(((ContentValidatorSender)((Object)cv)).addListener(lst));
        }
        try {
            cvres = cv.validate(cbuff, cfs);
            if (cvres.getBad() instanceof Set) {
                badFragments = (LinkedHashSet<ContentFragment>)cvres.getBad();
            } else {
                badFragments = new LinkedHashSet<ContentFragment>();
                for (ContentFragment contentFragment : cvres.getBad()) {
                    if (contentFragment == null) continue;
                    badFragments.add(contentFragment);
                }
            }
        }
        catch (Throwable err) {
            HttpDownloader.logException(err);
            this.finishAsError("content validate error: " + err.getMessage());
            cscv.closeAll();
            return;
        }
        cscv.closeAll();
        if (cvres.getGood() instanceof Set) {
            valids = (LinkedHashSet<ContentFragment>)cvres.getGood();
        } else {
            valids = new LinkedHashSet<ContentFragment>();
            for (ContentFragment contentFragment : cvres.getGood()) {
                if (contentFragment == null) continue;
                valids.add(contentFragment);
            }
        }
        if (badFragments == null || badFragments.isEmpty()) {
            EventSet<ContentFragment> eventSet = this.getValidatedFragments();
            for (ContentFragment contentFragment : valids) {
                boolean bl = eventSet.add((Object)contentFragment);
                if (!bl) continue;
                this.fireEvent(new AddedValidFragmentEvent(this, cfs, eventSet, contentFragment));
            }
            this.finishPartialDownload();
            return;
        }
        LinkedHashSet<ContentFragment> linkedHashSet = new LinkedHashSet<ContentFragment>();
        ContentFragment[] contentFragmentArray = badFragments.toArray(new ContentFragment[0]);
        int n = contentFragmentArray.length;
        boolean bl = false;
        while (var13_27 < n) {
            ContentFragment badcf = contentFragmentArray[var13_27];
            int i = cfs.indexOf(badcf);
            if (i >= 0) {
                Fragment ocf = cfs.get(i);
                if (ocf instanceof ContentFragment) {
                    ContentFragment cf = (ContentFragment)ocf;
                    linkedHashSet.add(cf);
                }
            } else {
                ContentFragment cf = badcf.clone();
                cfs.add(cf);
                linkedHashSet.add(cf);
            }
            ++var13_27;
        }
        EventSet<ContentFragment> eventSet = this.getValidatedFragments();
        for (ContentFragment contentFragment : linkedHashSet) {
            valids.remove(contentFragment);
            this.repeatDownload(contentFragment);
            boolean removedBad = eventSet.remove((Object)contentFragment);
            if (!removedBad) continue;
            this.fireEvent(new RemovedInvalidFragmentEvent(this, cfs, eventSet, contentFragment));
        }
        for (ContentFragment contentFragment : valids) {
            boolean addedGood = eventSet.add((Object)contentFragment);
            if (!addedGood) continue;
            this.fireEvent(new AddedValidFragmentEvent(this, cfs, eventSet, contentFragment));
        }
        MaxCounter maxCounter = this.getTryCounter().clone();
        if (maxCounter.overflow()) {
            this.finishAsError("overflow try counter: current=" + maxCounter.get() + " max=" + maxCounter.getMax());
            return;
        }
        this.run(mirrors, cfs);
    }

    protected void addGetPartProgressListener(final Queue<Runnable> qe, GetPart gp, final ContentFragment cf) {
        final CloseableSet closeListener = new CloseableSet();
        HttpListenerAdapter gpPartListener = new HttpListenerAdapter(){
            CloseableSet cs;
            {
                this.cs = closeListener;
            }

            @Override
            protected void responseProgress(HttpResponse.ProgressEvent event, HttpResponse response) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        HttpDownloader.this.fireEvent(new ProgressEvent(HttpDownloader.this));
                    }
                };
                qe.add(r);
                long size = response.getDownloadedSize();
                cf.setDownloadedSize(size);
            }

            @Override
            protected void responseStateChanged(HttpResponse.StateChangedEvent event, HttpResponse response, HttpResponse.State oldState, HttpResponse.State newState) {
                if (newState == HttpResponse.State.Finished && this.cs != null) {
                    this.cs.closeAll();
                    this.cs = null;
                }
            }
        };
        closeListener.add(gp.addResponseListener(gpPartListener, false));
    }

    protected void fireQueueEvents(Queue<Runnable> qe) {
        Runnable r;
        while (!qe.isEmpty() && (r = qe.poll()) != null) {
            r.run();
        }
    }

    protected boolean checkStopSignal(GetPartList gparts, WeakHashMap<GetPart, ContentFragment> getPartFragment) {
        if (Thread.interrupted()) {
            gparts.stopAll();
            Iterator<GetPart> iterator = gparts.iterator();
            while (iterator.hasNext()) {
                GetPart gp2 = iterator.next();
                this.fireEvent(new GetPartFinishedEvent(this, gp2, getPartFragment.get(gp2)));
            }
            gparts.clear();
            this.finishAsError("forced stop");
            return true;
        }
        return false;
    }

    protected void checkPauseSignal(GetPartList gparts) {
        block2: {
            Signal sgnl = this.checkSignal();
            if (!Signal.Pause.equals((Object)sgnl)) break block2;
            gparts.pauseAll();
            this.setState(State.Pause);
            do {
                if (Signal.Resume.equals((Object)(sgnl = this.checkSignal()))) {
                    gparts.resumeAll();
                    this.setState(State.DownloadingPartial);
                    break block2;
                }
                Thread.yield();
            } while (!Thread.currentThread().isInterrupted());
            this.setState(State.DownloadingPartial);
        }
    }

    protected void continueStreamDownload(HttpRequest request, HttpResponse firstRes) {
        HttpDownloader.logFine("continueStreamDownload", new Object[0]);
        this.setState(State.DownloadingStream);
        final LinkedBlockingQueue qe = new LinkedBlockingQueue();
        CloseableSet closeset = new CloseableSet();
        HttpListenerAdapter l = new HttpListenerAdapter(){

            @Override
            protected void responseProgress(HttpResponse.ProgressEvent event, HttpResponse response) {
                final HttpResponse fresponse = response;
                qe.add(new Runnable(){

                    @Override
                    public void run() {
                        HttpDownloader.this.setStreamDownloadedSize(fresponse.getDownloadedSize());
                    }
                });
            }
        };
        Closeable c = firstRes.addListener(l, true);
        closeset.add(c);
        while (!firstRes.isFinished()) {
            Runnable r;
            if (Thread.interrupted()) {
                firstRes.stop();
                break;
            }
            while (!qe.isEmpty() && (r = (Runnable)qe.poll()) != null) {
                r.run();
            }
            Signal s = this.checkSignal();
            if (!Signal.Pause.equals((Object)s)) continue;
            firstRes.pause();
            this.setState(State.Pause);
            while ((s = this.checkSignal()) == null || !Signal.Resume.equals((Object)s)) {
            }
            firstRes.resume();
            this.setState(State.DownloadingStream);
        }
        closeset.closeAll();
        this.setStreamDownloadedSize(firstRes.getDownloadedSize());
        this.finishStreamDownload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressCounters getProgressCounters() {
        if (this.progressCounters != null) {
            return this.progressCounters;
        }
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            if (this.progressCounters == null) {
                this.progressCounters = new ProgressCounters(this);
            }
        }
        return this.progressCounters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaxCounter getTryCounter() {
        if (this.tryCounter != null) {
            return this.tryCounter;
        }
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            if (this.tryCounter == null) {
                this.tryCounter = new MaxCounter(0, 100, this.lock);
                this.counters.put(tryCounterName, this.tryCounter);
            }
        }
        return this.tryCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTryCounter(MaxCounter cnt) {
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            this.getTryCounter().assign(cnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaxCounter getTryStartCounter() {
        if (this.tryStartCounter != null) {
            return this.tryStartCounter;
        }
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            if (this.tryStartCounter == null) {
                this.tryStartCounter = new MaxCounter(0, -1, this.lock);
                this.counters.put(tryStartCounterName, this.tryStartCounter);
            }
        }
        return this.tryStartCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTryStartCounter(MaxCounter cnt) {
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            this.getTryStartCounter().assign(cnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OverflowCounter getTryFagmentCounter() {
        if (this.tryFagmentCounter != null) {
            return this.tryFagmentCounter;
        }
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            if (this.tryFagmentCounter == null) {
                this.tryFagmentCounter = new OverflowCounter(0, -1, this.lock);
                this.counters.put(tryFragmentCounterName, this.tryFagmentCounter);
            }
        }
        return this.tryFagmentCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTryFagmentCounter(OverflowCounter cnt) {
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            this.getTryFagmentCounter().assign(cnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaxCounter getMultipleErrorsCounter() {
        if (this.multipleErrorsCounter != null) {
            return this.multipleErrorsCounter;
        }
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            if (this.multipleErrorsCounter == null) {
                this.multipleErrorsCounter = new MaxCounter(0, -1, this.lock);
                this.counters.put(multipleErrorsCounterName, this.multipleErrorsCounter);
            }
        }
        return this.multipleErrorsCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMultipleErrorsCounter(MaxCounter cnt) {
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            this.getMultipleErrorsCounter().assign(cnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaxCounter getUnknownHostCounter() {
        if (this.unknownHostCounter != null) {
            return this.unknownHostCounter;
        }
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            if (this.unknownHostCounter == null) {
                this.unknownHostCounter = new MaxCounter(0, -1, this.lock);
                this.counters.put(unknownHostCounterName, this.unknownHostCounter);
            }
        }
        return this.unknownHostCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnknownHostCounter(MaxCounter cnt) {
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            this.getUnknownHostCounter().assign(cnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaxCounter getHeadersNotExistsCounter() {
        if (this.headersNotExistsCounter != null) {
            return this.headersNotExistsCounter;
        }
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            if (this.headersNotExistsCounter == null) {
                this.headersNotExistsCounter = new MaxCounter(0, -1, this.lock);
                this.counters.put(headersNotExistsCounterName, this.headersNotExistsCounter);
            }
        }
        return this.headersNotExistsCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeadersNotExistsCounter(MaxCounter cnt) {
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            this.getHeadersNotExistsCounter().assign(cnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaxCounter getBadStatusCounter() {
        if (this.badStatusCounter != null) {
            return this.badStatusCounter;
        }
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            if (this.badStatusCounter == null) {
                this.badStatusCounter = new MaxCounter(0, -1, this.lock);
                this.counters.put(badStatusCounterName, this.badStatusCounter);
            }
        }
        return this.badStatusCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBadStatusCounter(MaxCounter cnt) {
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            this.getBadStatusCounter().assign(cnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaxCounter getServerErrorCounter() {
        if (this.serverErrorCounter != null) {
            return this.serverErrorCounter;
        }
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            if (this.serverErrorCounter == null) {
                this.serverErrorCounter = new MaxCounter(0, -1, this.lock);
                this.counters.put(serverErrorCounterName, this.serverErrorCounter);
            }
        }
        return this.serverErrorCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServerErrorCounter(MaxCounter cnt) {
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            this.getServerErrorCounter().assign(cnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaxCounter getClientErrorCounter() {
        if (this.clientErrorCounter != null) {
            return this.clientErrorCounter;
        }
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            if (this.clientErrorCounter == null) {
                this.clientErrorCounter = new MaxCounter(0, -1, this.lock);
                this.counters.put(clientErrorCounterName, this.clientErrorCounter);
            }
        }
        return this.clientErrorCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientErrorCounter(MaxCounter cnt) {
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            this.getClientErrorCounter().assign(cnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaxCounter getInfoStatusCounter() {
        if (this.infoStatusCounter != null) {
            return this.infoStatusCounter;
        }
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            if (this.infoStatusCounter == null) {
                this.infoStatusCounter = new MaxCounter(0, 100, this.lock);
                this.counters.put(infoStatusCounterName, this.infoStatusCounter);
            }
        }
        return this.infoStatusCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInfoStatusCounter(MaxCounter cnt) {
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            this.getInfoStatusCounter().assign(cnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaxCounter getUnSupportedStatusCounter() {
        if (this.unSupportedStatusCounter != null) {
            return this.unSupportedStatusCounter;
        }
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            if (this.unSupportedStatusCounter == null) {
                this.unSupportedStatusCounter = new MaxCounter(0, -1, this.lock);
                this.counters.put(unSupportedStatusCounterName, this.unSupportedStatusCounter);
            }
        }
        return this.unSupportedStatusCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnSupportedStatusCounter(MaxCounter cnt) {
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            this.getUnSupportedStatusCounter().assign(cnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaxCounter getUriSyntaxErrCounter() {
        if (this.uriSyntaxErrCounter != null) {
            return this.uriSyntaxErrCounter;
        }
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            if (this.uriSyntaxErrCounter == null) {
                this.uriSyntaxErrCounter = new MaxCounter(0, -1, this.lock);
                this.counters.put(uriSyntaxErrCounterName, this.uriSyntaxErrCounter);
            }
        }
        return this.uriSyntaxErrCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUriSyntaxErrCounterCounter(MaxCounter cnt) {
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            this.getUriSyntaxErrCounter().assign(cnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaxCounter getUnknownServiceCounter() {
        if (this.unknownServiceCounter != null) {
            return this.unknownServiceCounter;
        }
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            if (this.unknownServiceCounter == null) {
                this.unknownServiceCounter = new MaxCounter(0, -1, this.lock);
                this.counters.put(unknownServiceCounterName, this.unknownServiceCounter);
            }
        }
        return this.unknownServiceCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnknownServiceCounter(MaxCounter cnt) {
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            this.getUnknownServiceCounter().assign(cnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaxCounter getSocketTimeoutCounter() {
        if (this.socketTimeoutCounter != null) {
            return this.socketTimeoutCounter;
        }
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            if (this.socketTimeoutCounter == null) {
                this.socketTimeoutCounter = new MaxCounter(0, -1, this.lock);
                this.counters.put(socketTimeoutCounterName, this.socketTimeoutCounter);
            }
        }
        return this.socketTimeoutCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSocketTimeoutCounter(MaxCounter cnt) {
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            this.getSocketTimeoutCounter().assign(cnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaxCounter getProtocolErrCounter() {
        if (this.protocolErrCounter != null) {
            return this.protocolErrCounter;
        }
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            if (this.protocolErrCounter == null) {
                this.protocolErrCounter = new MaxCounter(0, -1, this.lock);
                this.counters.put(protocolErrCounterName, this.protocolErrCounter);
            }
        }
        return this.protocolErrCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProtocolErrCounter(MaxCounter cnt) {
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            this.getProtocolErrCounter().assign(cnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaxCounter getPortUnreachableCounter() {
        if (this.portUnreachableCounter != null) {
            return this.portUnreachableCounter;
        }
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            if (this.portUnreachableCounter == null) {
                this.portUnreachableCounter = new MaxCounter(0, -1, this.lock);
                this.counters.put(portUnreachableCounterName, this.portUnreachableCounter);
            }
        }
        return this.portUnreachableCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPortUnreachableCounter(MaxCounter cnt) {
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            this.getPortUnreachableCounter().assign(cnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaxCounter getMalformedURLCounter() {
        if (this.malformedURLCounter != null) {
            return this.malformedURLCounter;
        }
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            if (this.malformedURLCounter == null) {
                this.malformedURLCounter = new MaxCounter(0, -1, this.lock);
                this.counters.put(malformedURLCounterName, this.malformedURLCounter);
            }
        }
        return this.malformedURLCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMalformedURLCounter(MaxCounter cnt) {
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            this.getMalformedURLCounter().assign(cnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaxCounter getHttpRetryCounter() {
        if (this.httpRetryCounter != null) {
            return this.httpRetryCounter;
        }
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            if (this.httpRetryCounter == null) {
                this.httpRetryCounter = new MaxCounter(0, -1, this.lock);
                this.counters.put(httpRetryCounterName, this.httpRetryCounter);
            }
        }
        return this.httpRetryCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHttpRetryCounter(MaxCounter cnt) {
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            this.getHttpRetryCounter().assign(cnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaxCounter getSocketErrCounter() {
        if (this.socketErrCounter != null) {
            return this.socketErrCounter;
        }
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            if (this.socketErrCounter == null) {
                this.socketErrCounter = new MaxCounter(0, -1, this.lock);
                this.counters.put(socketErrCounterName, this.socketErrCounter);
            }
        }
        return this.socketErrCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSocketErrCounter(MaxCounter cnt) {
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            this.getSocketErrCounter().assign(cnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaxCounter getBindErrCounter() {
        if (this.bindErrCounter != null) {
            return this.bindErrCounter;
        }
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            if (this.bindErrCounter == null) {
                this.bindErrCounter = new MaxCounter(0, -1, this.lock);
                this.counters.put(bindErrCounterName, this.bindErrCounter);
            }
        }
        return this.bindErrCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBindErrCounter(MaxCounter cnt) {
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            this.getBindErrCounter().assign(cnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaxCounter getConnectErrCounter() {
        if (this.connectErrCounter != null) {
            return this.connectErrCounter;
        }
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            if (this.connectErrCounter == null) {
                this.connectErrCounter = new MaxCounter(0, -1, this.lock);
                this.counters.put(connectErrCounterName, this.connectErrCounter);
            }
        }
        return this.connectErrCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectErrCounter(MaxCounter cnt) {
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            this.getConnectErrCounter().assign(cnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaxCounter getNoRouteToHostCounter() {
        if (this.noRouteToHostCounter != null) {
            return this.noRouteToHostCounter;
        }
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            if (this.noRouteToHostCounter == null) {
                this.noRouteToHostCounter = new MaxCounter(0, -1, this.lock);
                this.counters.put(noRouteToHostCounterName, this.noRouteToHostCounter);
            }
        }
        return this.noRouteToHostCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNoRouteToHostCounter(MaxCounter cnt) {
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            this.getNoRouteToHostCounter().assign(cnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LongCounter getWorkTimeCounter() {
        if (this.workTimeCounter != null) {
            return this.workTimeCounter;
        }
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            if (this.workTimeCounter == null) {
                this.workTimeCounter = new LongCounter((Lock)this.lock){

                    @Override
                    public Long get() {
                        Date dStarted = HttpDownloader.this.getStarted();
                        Date dFinished = HttpDownloader.this.getFinished();
                        if (dStarted == null) {
                            return 0L;
                        }
                        if (dFinished == null || dStarted.after(dFinished)) {
                            return new Date().getTime() - dStarted.getTime();
                        }
                        return dFinished.getTime() - dStarted.getTime();
                    }
                };
                this.counters.put(workTimeCounterName, this.workTimeCounter);
            }
        }
        return this.workTimeCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntCounter getRequestsCounter() {
        if (this.requestsCounter != null) {
            return this.requestsCounter;
        }
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            if (this.requestsCounter == null) {
                this.requestsCounter = new IntCounter(this.lock);
                this.counters.put(requestsCounterName, this.requestsCounter);
            }
        }
        return this.requestsCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Counter> getCounters() {
        if (!this.countersMapInit) {
            HttpDownloader httpDownloader = this;
            synchronized (httpDownloader) {
                if (!this.countersMapInit) {
                    this.countersMapInit = true;
                    this.getTryCounter();
                    this.getTryStartCounter();
                    this.getSocketErrCounter();
                    this.getBindErrCounter();
                    this.getTryFagmentCounter();
                    this.getBadStatusCounter();
                    this.getClientErrorCounter();
                    this.getHeadersNotExistsCounter();
                    this.getInfoStatusCounter();
                    this.getServerErrorCounter();
                    this.getUnSupportedStatusCounter();
                    this.getUnknownHostCounter();
                    this.getUriSyntaxErrCounter();
                    this.getUnknownServiceCounter();
                    this.getSocketTimeoutCounter();
                    this.getProtocolErrCounter();
                    this.getPortUnreachableCounter();
                    this.getNoRouteToHostCounter();
                    this.getMalformedURLCounter();
                    this.getHttpRetryCounter();
                    this.getConnectErrCounter();
                    this.getWorkTimeCounter();
                    this.getRequestsCounter();
                    this.getFragmentValidator();
                }
            }
        }
        return this.counters;
    }

    @Override
    public void resetCounters() {
        ContentValidator cv;
        try {
            this.lock.lock();
            if (this.counters != null) {
                for (Counter c : this.counters.values()) {
                    if (c == null || !(c instanceof ResetCounter)) continue;
                    ((ResetCounter)((Object)c)).reset();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        FragmentValidator fv = this.getFragmentValidator();
        if (fv instanceof ResetCounters) {
            ((ResetCounters)((Object)fv)).resetCounters();
        }
        if ((cv = this.getContentValidator()) instanceof ResetCounters) {
            ((ResetCounters)((Object)cv)).resetCounters();
        }
        this.validatedFragments.clear();
        this.fireEvent(new CountersResetedEvent(this));
    }

    protected void finishStreamDownload() {
        this.setState(State.Finished);
        HttpDownloader.logFine("finish download", new Object[0]);
    }

    protected void finishAsError(GetPartList gparts, WeakHashMap<GetPart, ContentFragment> getPartFragment, String message) {
        gparts.stopAll();
        Iterator<GetPart> iterator = gparts.iterator();
        while (iterator.hasNext()) {
            GetPart gp2 = iterator.next();
            this.fireEvent(new GetPartFinishedEvent(this, gp2, getPartFragment.get(gp2)));
        }
        gparts.clear();
        this.finishAsError(message);
    }

    protected void finishAsError(String message) {
        this.fireEvent(new FinishWithErrorEvent(this, message));
        this.setState(State.Finished);
        HttpDownloader.logWarning("finish download with error: {0}", message);
    }

    protected void finishPartialDownload() {
        this.setState(State.Finished);
        HttpDownloader.logFine("finish download", new Object[0]);
    }

    public void waitForFinished() {
        Thread tt = Thread.currentThread();
        Thread t = null;
        try {
            if (this.lock != null) {
                this.lock.lock();
            }
            t = this.thread;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
        if (t == null) {
            throw new IllegalStateException("not async started");
        }
        if (t.equals(tt)) {
            throw new Error("thread can be locked");
        }
        while (!this.isFinished() || t.isAlive()) {
            Thread.yield();
        }
    }

    public boolean isAlive() {
        Thread t = null;
        try {
            if (this.lock != null) {
                this.lock.lock();
            }
            t = this.thread;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
        if (t == null) {
            return false;
        }
        return t.isAlive();
    }

    public void stop() {
        Thread tt = Thread.currentThread();
        Thread t = null;
        try {
            if (this.lock != null) {
                this.lock.lock();
            }
            t = this.thread;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
        if (t == null) {
            throw new IllegalStateException("not async started");
        }
        if (t.equals(tt)) {
            throw new Error("thread can be locked");
        }
        while (!this.isFinished() || t.isAlive()) {
            t.interrupt();
            Thread.yield();
        }
    }

    public Closeable onFinished(final Func1<Object, HttpDownloader> runOnFinsihed) {
        if (runOnFinsihed == null) {
            throw new IllegalArgumentException("runOnFinsihed==null");
        }
        final CloseableSet cset = new CloseableSet();
        HttpListenerAdapter listener = new HttpListenerAdapter(){
            private CloseableSet cs;
            private Func1<Object, HttpDownloader> call;
            {
                this.cs = cset;
                this.call = runOnFinsihed;
            }

            @Override
            protected void downloaderFinished(StateChangedEvent event, HttpDownloader downloader) {
                if (this.cs != null) {
                    this.cs.closeAll();
                    this.cs = null;
                }
                if (this.call != null) {
                    this.call.apply((Object)downloader);
                    this.call = null;
                }
            }
        };
        cset.add(this.addListener(listener, false));
        Closeable cl = new Closeable(){

            @Override
            public void close() throws IOException {
                cset.closeAll();
            }
        };
        return cl;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
        sequenceID = new AtomicLong();
        httpStatusHelper = new HttpStatusHelper();
    }

    protected static class CatchFirstStatus {
        protected boolean repeat;

        public CatchFirstStatus(boolean repeat) {
            this.repeat = repeat;
        }

        public boolean isRepeat() {
            return this.repeat;
        }

        public void setRepeat(boolean repeat) {
            this.repeat = repeat;
        }
    }

    protected static enum Signal {
        Pause,
        Resume;

    }

    public static enum State {
        Prepare,
        Starting,
        Pause,
        DownloadingStream,
        SwitchPartialDownloading,
        DownloadingPartial,
        Validate,
        Finished;

    }

    public static class RetryEvent
    extends HttpEvent {
        protected HttpDownloader downloader;
        protected String message = "no message";

        public RetryEvent(HttpDownloader downloader, String message) {
            this.downloader = downloader;
            this.message = message == null ? this.message : message;
        }

        public HttpDownloader getHttpDownloader() {
            return this.downloader;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class FinishWithErrorEvent
    extends HttpEvent {
        protected HttpDownloader downloader;
        protected String message;

        public FinishWithErrorEvent(HttpDownloader downloader, String message) {
            this.downloader = downloader;
            this.message = message;
        }

        public HttpDownloader getHttpDownloader() {
            return this.downloader;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class ContentValidateProgressEvent
    extends HttpEvent {
        protected ContentValidator contentValidator;
        protected ContentBuffer contentBuffer;
        protected ContentFragments sampleFragments;
        protected ContentFragment cf;
        protected HttpDownloader downloader;
        protected boolean hashMatched = false;
        protected int sampleNum = -1;
        protected int sampleTotal = -1;

        public ContentValidateProgressEvent(HttpDownloader downloader, ContentValidatorProgressEvent pe) {
            this.downloader = downloader;
            this.cf = pe.getSample();
            this.sampleNum = pe.getSampleNum();
            this.sampleTotal = pe.getSampleTotal();
            this.hashMatched = pe.isHashMatched();
            this.sampleFragments = pe.getSampleFragments();
            this.contentBuffer = pe.getContentBuffer();
            this.contentValidator = pe.getSource();
        }

        public ContentValidator getContentValidator() {
            return this.contentValidator;
        }

        public ContentBuffer getContentBuffer() {
            return this.contentBuffer;
        }

        public ContentFragments getSampleFragments() {
            return this.sampleFragments;
        }

        public ContentFragment getSample() {
            return this.cf;
        }

        public HttpDownloader getHttpDownloader() {
            return this.downloader;
        }

        public boolean isHashMatched() {
            return this.hashMatched;
        }

        public int getSampleNum() {
            return this.sampleNum;
        }

        public int getSampleTotal() {
            return this.sampleTotal;
        }
    }

    public static class RemovedInvalidFragmentEvent
    extends ContentValidateEvent {
        protected ContentFragment cf;

        public RemovedInvalidFragmentEvent(HttpDownloader downloader, ContentFragments fragments, EventSet<ContentFragment> valid, ContentFragment cf) {
            super(downloader, fragments, valid);
            this.cf = cf;
        }

        public ContentFragment getContentFragment() {
            return this.cf;
        }
    }

    public static class AddedValidFragmentEvent
    extends ContentValidateEvent {
        protected ContentFragment cf;

        public AddedValidFragmentEvent(HttpDownloader downloader, ContentFragments fragments, EventSet<ContentFragment> valid, ContentFragment cf) {
            super(downloader, fragments, valid);
            this.cf = cf;
        }

        public ContentFragment getContentFragment() {
            return this.cf;
        }
    }

    public static class ContentValidateEvent
    extends HttpEvent {
        protected HttpDownloader downloader = null;
        protected ContentFragments fragments = null;
        protected EventSet<ContentFragment> valid = null;

        public ContentValidateEvent(HttpDownloader downloader, ContentFragments fragments, EventSet<ContentFragment> valid) {
            this.downloader = downloader;
            this.fragments = fragments;
            this.valid = valid;
        }

        public HttpDownloader getHttpDownloader() {
            return this.downloader;
        }

        public ContentFragments getFragments() {
            return this.fragments;
        }

        public EventSet<ContentFragment> getValidated() {
            return this.valid;
        }
    }

    public static class FragmentErrorEvent
    extends HttpEvent {
        protected HttpDownloader downloader = null;
        protected ContentFragment cf = null;
        protected GetPart gp = null;
        protected Throwable err = null;
        protected FragmentValidator fv = null;

        public FragmentErrorEvent(HttpDownloader downloader, FragmentValidator fv, ContentFragment cf, GetPart gp, Throwable err) {
            this.downloader = downloader;
            this.cf = cf;
            this.fv = fv;
            this.gp = gp;
            this.err = err;
        }

        public HttpDownloader getHttpDownloader() {
            return this.downloader;
        }

        public ContentFragment getContentFragment() {
            return this.cf;
        }

        public GetPart getGetPart() {
            return this.gp;
        }

        public FragmentValidator getFragmentValidator() {
            return this.fv;
        }

        public Throwable getError() {
            return this.err;
        }
    }

    public static class SkippedFragmentEvent
    extends HttpEvent {
        protected HttpDownloader downloader = null;
        protected ContentFragment cf = null;

        public SkippedFragmentEvent(HttpDownloader downloader, ContentFragment cf) {
            this.downloader = downloader;
            this.cf = cf;
        }

        public HttpDownloader getHttpDownloader() {
            return this.downloader;
        }

        public ContentFragment getContentFragment() {
            return this.cf;
        }
    }

    public static class DownloadedFragmentEvent
    extends HttpEvent {
        protected HttpDownloader downloader = null;
        protected ContentFragment cf = null;

        public DownloadedFragmentEvent(HttpDownloader downloader, ContentFragment cf) {
            this.downloader = downloader;
            this.cf = cf;
        }

        public HttpDownloader getHttpDownloader() {
            return this.downloader;
        }

        public ContentFragment getContentFragment() {
            return this.cf;
        }
    }

    public static class RepeatFragmentEvent
    extends HttpEvent {
        protected HttpDownloader downloader = null;
        protected ContentFragment cf = null;

        public RepeatFragmentEvent(HttpDownloader downloader, ContentFragment cf) {
            this.downloader = downloader;
            this.cf = cf;
        }

        public HttpDownloader getHttpDownloader() {
            return this.downloader;
        }

        public ContentFragment getContentFragment() {
            return this.cf;
        }
    }

    public static class RepeatOverflowEvent
    extends HttpEvent {
        protected HttpDownloader downloader = null;
        protected int currentRepeatCount = -1;
        protected int maxRepeatCount = -1;

        public RepeatOverflowEvent(HttpDownloader downloader, int currentRepeatCount, int maxRepeatCount) {
            this.downloader = downloader;
            this.currentRepeatCount = currentRepeatCount;
            this.maxRepeatCount = maxRepeatCount;
        }

        public HttpDownloader getHttpDownloader() {
            return this.downloader;
        }

        public int getCurrentRepeatCount() {
            return this.currentRepeatCount;
        }

        public int getMaxRepeatCount() {
            return this.maxRepeatCount;
        }
    }

    public static class CountersResetedEvent
    extends HttpEvent {
        protected HttpDownloader downloader = null;

        public CountersResetedEvent(HttpDownloader downloader) {
            this.downloader = downloader;
        }

        public HttpDownloader getHttpDownloader() {
            return this.downloader;
        }
    }

    public static class GetPartFinishedEvent
    extends GetPartEvent {
        public GetPartFinishedEvent(HttpDownloader downloader, GetPart getPart, ContentFragment fragment) {
            super(downloader, getPart, fragment);
        }
    }

    public static class GetPartStartedEvent
    extends GetPartEvent {
        public GetPartStartedEvent(HttpDownloader downloader, GetPart getPart, ContentFragment fragment) {
            super(downloader, getPart, fragment);
        }
    }

    public static class GetPartEvent
    extends HttpEvent {
        protected HttpDownloader downloader = null;
        protected GetPart getPart = null;
        protected ContentFragment fragment = null;

        public GetPartEvent(HttpDownloader downloader, GetPart getPart, ContentFragment fragment) {
            if (downloader == null) {
                throw new IllegalArgumentException("downloader==null");
            }
            this.downloader = downloader;
            this.getPart = getPart;
            this.fragment = fragment;
        }

        public HttpDownloader getHttpDownloader() {
            return this.downloader;
        }

        public GetPart getGetPart() {
            return this.getPart;
        }

        public ContentFragment getFragment() {
            return this.fragment;
        }
    }

    public static class ResponseEvent
    extends HttpEvent {
        protected HttpDownloader downloader = null;
        protected HttpRequest request = null;
        protected HttpResponse response = null;

        public ResponseEvent(HttpDownloader downloader, HttpRequest request, HttpResponse response) {
            if (downloader == null) {
                throw new IllegalArgumentException("downloader==null");
            }
            if (response == null) {
                throw new IllegalArgumentException("response==null");
            }
            if (request == null) {
                throw new IllegalArgumentException("request==null");
            }
            this.downloader = downloader;
            this.request = request;
            this.response = response;
        }

        public ResponseEvent(HttpDownloader downloader, HttpResponse response) {
            if (downloader == null) {
                throw new IllegalArgumentException("downloader==null");
            }
            if (response == null) {
                throw new IllegalArgumentException("response==null");
            }
            this.downloader = downloader;
        }

        public HttpDownloader getHttpDownloader() {
            return this.downloader;
        }

        public HttpRequest getRequest() {
            if (this.request == null) {
                this.request = this.response.getRequest();
            }
            return this.request;
        }

        public HttpResponse getResponse() {
            return this.response;
        }
    }

    public static class ProgressEvent
    extends HttpEvent {
        protected HttpDownloader downloader = null;

        public ProgressEvent(HttpDownloader downloader) {
            this.downloader = downloader;
        }

        public HttpDownloader getHttpDownloader() {
            return this.downloader;
        }
    }

    public static class RedirectEvent
    extends HttpEvent {
        protected HttpDownloader downloader = null;
        protected URL from = null;
        protected URL to = null;

        public RedirectEvent(HttpDownloader downloader, URL from, URL to) {
            this.downloader = downloader;
            this.from = from;
            this.to = to;
        }

        public HttpDownloader getHttpDownloader() {
            return this.downloader;
        }

        public URL getFrom() {
            return this.from;
        }

        public URL getTo() {
            return this.to;
        }
    }

    public static class StateChangedEvent
    extends HttpEvent {
        protected HttpDownloader httpDownloader = null;
        protected State oldState = null;
        protected State newState = null;

        public StateChangedEvent(HttpDownloader downloader, State oldState, State newState) {
            this.httpDownloader = downloader;
            this.oldState = oldState;
            this.newState = newState;
        }

        public HttpDownloader getHttpDownloader() {
            return this.httpDownloader;
        }

        public State getOldState() {
            return this.oldState;
        }

        public State getNewState() {
            return this.newState;
        }
    }
}

