/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xyz.cofe.http.DateTime;
import xyz.cofe.text.Text;

public class HttpHeaders {
    private Map<String, List<String>> headers = null;
    public static final String CONTENT_TYPE = "Content-Type";
    private static Pattern contentRangePattern = Pattern.compile("(?is)^\\s*bytes\\s+(\\d+)\\s*-\\s*(\\d+)\\s*/\\s*(\\d+).*?$");

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(HttpHeaders.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(HttpHeaders.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(HttpHeaders.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(HttpHeaders.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(HttpHeaders.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(HttpHeaders.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(HttpHeaders.class.getName()).log(Level.SEVERE, null, ex);
    }

    protected HttpHeaders(Map<String, List<String>> multiMap) {
        if (multiMap == null) {
            throw new IllegalArgumentException("multiMap==null");
        }
        this.headers = multiMap;
    }

    public HttpHeaders() {
        this.headers = new LinkedHashMap<String, List<String>>();
    }

    public HttpHeaders(HttpHeaders source) {
        if (source != null) {
            this.headers = source.cloneHeaders();
        }
    }

    public static HttpHeaders createFromMultiMap(Map<String, List<String>> multiMap) {
        if (multiMap == null) {
            throw new IllegalArgumentException("multiMap==null");
        }
        return new HttpHeaders(multiMap);
    }

    public Map<String, List<String>> getMultiMap() {
        return this.headers;
    }

    public HttpHeaders clone() {
        return new HttpHeaders(this);
    }

    public Map<String, List<String>> cloneHeaders() {
        LinkedHashMap<String, List<String>> clone = new LinkedHashMap<String, List<String>>();
        if (this.headers != null) {
            for (Map.Entry<String, List<String>> e : this.headers.entrySet()) {
                String sk = e.getKey();
                List<String> sv = e.getValue();
                ArrayList<String> cv = new ArrayList<String>();
                cv.addAll(sv);
                clone.put(sk, cv);
            }
        }
        return clone;
    }

    public String getFirst(String key) {
        if (this.headers == null) {
            return null;
        }
        if (key == null && this.headers.containsKey(null)) {
            List<String> values = this.headers.get(key);
            if (values != null && values.size() > 0) {
                return values.get(0);
            }
            return null;
        }
        for (Map.Entry<String, List<String>> e : this.headers.entrySet()) {
            List<String> values;
            String sk = e.getKey();
            if (key == null || sk == null || !key.equalsIgnoreCase(sk) || (values = e.getValue()) == null || values.size() <= 0) continue;
            return values.get(0);
        }
        return null;
    }

    public String get(String key) {
        return this.getFirst(key);
    }

    protected static Set<String> getKeysIgnoreCase(Map<String, List<String>> headers, String key) {
        if (key == null) {
            throw new IllegalArgumentException("key==null");
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (String k : headers.keySet()) {
            if (!key.equalsIgnoreCase(k)) continue;
            keys.add(k);
        }
        return keys;
    }

    public HttpHeaders set(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("key==null");
        }
        Map<String, List<String>> h = this.headers;
        if (value == null) {
            Set<String> keys = HttpHeaders.getKeysIgnoreCase(h, key);
            for (String k : keys) {
                h.remove(key);
            }
            return this;
        }
        Set<String> keys = HttpHeaders.getKeysIgnoreCase(h, key);
        if (!keys.isEmpty()) {
            int idx = -1;
            for (String k : keys) {
                if (++idx == 0) {
                    ArrayList<String> values = new ArrayList<String>();
                    values.add(value);
                    h.put(k, values);
                    continue;
                }
                h.remove(k);
            }
        } else {
            ArrayList<String> lv = new ArrayList<String>();
            lv.add(value);
            h.put(key, lv);
        }
        return this;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        for (Map.Entry<String, List<String>> e : this.headers.entrySet()) {
            String header = e.getKey();
            List<String> values = e.getValue();
            if (values == null || header == null || values.isEmpty()) continue;
            for (String value : values) {
                buff.append(header).append(": ").append(value != null ? value.trim() : null).append("\n");
            }
        }
        return buff.toString();
    }

    public String getContentTypeHeader() {
        return this.getFirst(CONTENT_TYPE);
    }

    public Charset getContentTypeCharset() {
        String charset = null;
        String contentType = this.getContentTypeHeader();
        if (contentType != null) {
            for (String param : contentType.replace(" ", "").split(";")) {
                if (!param.toLowerCase().startsWith("charset=")) continue;
                charset = param.split("=", 2)[1];
                break;
            }
            if (charset != null) {
                return Charset.forName(charset);
            }
        }
        return null;
    }

    public String getContentType() {
        String contentTypeHeader = this.getContentTypeHeader();
        if (contentTypeHeader != null && contentTypeHeader.contains(";")) {
            int i = contentTypeHeader.indexOf(";");
            return contentTypeHeader.substring(0, i).trim();
        }
        return null;
    }

    public long getContentLength() {
        String val = this.get("Content-Length");
        if (val != null) {
            try {
                return Long.parseLong(val);
            }
            catch (NumberFormatException ex) {
                return -1L;
            }
        }
        return -1L;
    }

    public String getContentDispositionHeader() {
        return this.get("Content-Disposition");
    }

    protected String parseQuotedString(String text, int offset) {
        String ltext;
        int state = 0;
        StringBuilder sb = new StringBuilder();
        block7: for (int i = offset; i < text.length() && (ltext = Text.lookupText((String)text, (int)i, (int)2)).length() != 0; ++i) {
            if (ltext.length() == 1) {
                switch (state) {
                    case 1: {
                        sb.append(ltext);
                    }
                }
            }
            if (ltext.length() != 2) continue;
            switch (state) {
                case 0: {
                    if (!ltext.startsWith("\"")) continue block7;
                    state = 1;
                    continue block7;
                }
                case 1: {
                    if (ltext.startsWith("\"")) {
                        state = 2;
                        continue block7;
                    }
                    if (ltext.equals("\\r")) {
                        ++i;
                        sb.append("\r");
                        continue block7;
                    }
                    if (ltext.equals("\\t")) {
                        ++i;
                        sb.append("\t");
                        continue block7;
                    }
                    if (ltext.equals("\\n")) {
                        ++i;
                        sb.append("\n");
                        continue block7;
                    }
                    if (ltext.equals("\\\"")) {
                        ++i;
                        sb.append("\"");
                        continue block7;
                    }
                    if (ltext.equals("\\\\")) {
                        ++i;
                        sb.append("\\");
                        continue block7;
                    }
                    if (ltext.startsWith("\\")) {
                        ++i;
                        sb.append(ltext.charAt(1));
                        continue block7;
                    }
                    sb.append(ltext.charAt(0));
                }
            }
        }
        return sb.toString();
    }

    public String getContentDispositionFileName() {
        String header = this.getContentDispositionHeader();
        if (header == null) {
            return null;
        }
        if (!header.contains(";")) {
            return null;
        }
        String[] kvline = header.split(";");
        if (kvline != null && kvline.length > 0) {
            for (int i = 1; i < kvline.length; ++i) {
                String[] kv = kvline[i].split("\\s*=\\s*", 2);
                if (kv == null || kv.length != 2) continue;
                String k = kv[0].trim();
                String v = kv[1].trim();
                if (!k.equalsIgnoreCase("filename") || v.length() <= 0) continue;
                if (v.startsWith("\"")) {
                    int i1 = v.indexOf("\"");
                    return this.parseQuotedString(v, i1);
                }
                return v;
            }
        }
        return null;
    }

    public String getAcceptRanges() {
        return this.get("Accept-Ranges");
    }

    public String getRangeHeader() {
        return this.get("Range");
    }

    public Range getRange() {
        String val = this.get("Range");
        if (val == null) {
            return null;
        }
        if (!(val = val.trim()).toLowerCase().startsWith("bytes=")) {
            return null;
        }
        String[] ft = (val = val.substring("bytes=".length())).split("\\-", 2);
        if (ft.length != 2) {
            return null;
        }
        if (ft[0].trim().length() > 0 && ft[1].trim().length() > 0) {
            Range r = new Range();
            r.from = Long.parseLong(ft[0]);
            r.to = Long.parseLong(ft[1]);
            return r;
        }
        if (ft[0].trim().length() > 0) {
            Range r = new Range();
            r.from = Long.parseLong(ft[0]);
            r.to = -1L;
            return r;
        }
        return null;
    }

    public void setRange(long from, long to) {
        if (from < 0L) {
            throw new IllegalArgumentException("from<0");
        }
        if (to >= 0L && to < from) {
            throw new IllegalArgumentException("to>=0 && to<from");
        }
        if (to >= 0L) {
            this.set("Range", "bytes=" + Long.toString(from) + "-" + Long.toString(to));
        } else {
            this.set("Range", "bytes=" + Long.toString(from) + "-");
        }
    }

    public void setRangeHeader(String val) {
        this.set("Range", null);
    }

    public String getContentRangeHeader() {
        return this.get("Content-Range");
    }

    public ContentRange getContentRange() {
        Matcher m;
        String val = this.getContentRangeHeader();
        if (val != null && (m = contentRangePattern.matcher(val)).matches()) {
            String fromStr = m.group(1);
            String toStr = m.group(2);
            String totalStr = m.group(3);
            ContentRange cr = new ContentRange();
            cr.from = Long.parseLong(fromStr);
            cr.to = Long.parseLong(toStr);
            cr.total = Long.parseLong(totalStr);
            return cr;
        }
        return null;
    }

    public String getAccept() {
        return this.get("Accept");
    }

    public void setAccept(String accept) {
        this.set("Accept", accept);
    }

    public String getAcceptLanguage() {
        return this.get("Accept-Language");
    }

    public void setAcceptLanguage(String accept) {
        this.set("Accept-Language", accept);
    }

    public String getUserAgent() {
        return this.get("User-Agent");
    }

    public void setUserAgent(String useragent) {
        this.set("User-Agent", useragent);
    }

    public Charset getAcceptCharset() {
        String val = this.get("Accept-Charset");
        return val != null ? Charset.forName(val) : null;
    }

    public void setAcceptCharset(Charset accept) {
        this.set("Accept-Charset", accept != null ? accept.name() : null);
    }

    public String getLocation() {
        String val = this.get("Location");
        return val;
    }

    public void setLocation(String location) {
        this.set("Location", location);
    }

    public String getReferer() {
        String val = this.get("Referer");
        return val;
    }

    public void setReferer(String referer) {
        this.set("Referer", referer);
    }

    public String getSetCookie() {
        return this.get("Set-Cookie");
    }

    public void setSetCookie(String setCookie) {
        this.set("Set-Cookie", setCookie);
    }

    public String getCookie() {
        return this.get("Cookie");
    }

    public void setCookie(String setCookie) {
        this.set("Cookie", setCookie);
    }

    public Date getLastModifiedLocal() {
        String lastModifiedHeader = this.get("Last-Modified");
        if (lastModifiedHeader == null) {
            return null;
        }
        return new DateTime().parse(lastModifiedHeader, false);
    }

    public void setLastModifiedLocal(Date date) {
        if (date == null) {
            this.set("Last-Modified", null);
        } else {
            this.set("Last-Modified", new DateTime().toDate(date, false));
        }
    }

    public Date getLastModifiedGMT() {
        String lastModifiedHeader = this.get("Last-Modified");
        if (lastModifiedHeader == null) {
            return null;
        }
        return new DateTime().parse(lastModifiedHeader, true);
    }

    public void setLastModifiedGMT(Date date) {
        if (date == null) {
            this.set("Last-Modified", null);
        } else {
            this.set("Last-Modified", new DateTime().toDate(date, true));
        }
    }

    public Date getIfModifiedSinceLocal() {
        String lastModifiedHeader = this.get("If-Modified-Since");
        if (lastModifiedHeader == null) {
            return null;
        }
        return new DateTime().parse(lastModifiedHeader, false);
    }

    public void setIfModifiedSinceLocal(Date date) {
        if (date == null) {
            this.set("If-Modified-Since", null);
        } else {
            this.set("If-Modified-Since", new DateTime().toDate(date, false));
        }
    }

    public Date getIfModifiedSinceGMT() {
        String lastModifiedHeader = this.get("If-Modified-Since");
        if (lastModifiedHeader == null) {
            return null;
        }
        return new DateTime().parse(lastModifiedHeader, true);
    }

    public void setIfModifiedSinceGMT(Date date) {
        if (date == null) {
            this.set("If-Modified-Since", null);
        } else {
            this.set("If-Modified-Since", new DateTime().toDate(date, true));
        }
    }

    public static class ContentRange {
        public long from = -1L;
        public long to = -1L;
        public long total = -1L;

        public String toString() {
            return Long.toString(this.from) + "-" + Long.toString(this.to) + "/" + Long.toString(this.total);
        }
    }

    public static class Range {
        public long from = -1L;
        public long to = -1L;
    }
}

