/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.http.HttpEvent;
import xyz.cofe.http.HttpListener;

public class HttpListenersHelper {
    private Object sync = null;
    protected HashSet<HttpListener> listeners = new HashSet();
    protected WeakHashMap<HttpListener, Object> weakLinks = new WeakHashMap();

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(HttpListenersHelper.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(HttpListenersHelper.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(HttpListenersHelper.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(HttpListenersHelper.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(HttpListenersHelper.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(HttpListenersHelper.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(HttpListenersHelper.class.getName()).log(Level.SEVERE, null, ex);
    }

    public HttpListenersHelper() {
        this(true);
    }

    public HttpListenersHelper(boolean sync) {
        if (sync) {
            this.sync = this;
        }
    }

    public HttpListenersHelper(boolean sync, Object synObj) {
        if (sync) {
            this.sync = synObj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<HttpListener> getListeners() {
        LinkedHashSet<HttpListener> res = new LinkedHashSet<HttpListener>();
        if (this.sync != null) {
            Object object = this.sync;
            synchronized (object) {
                res.addAll(this.listeners);
                res.addAll(this.weakLinks.keySet());
            }
        } else {
            res.addAll(this.listeners);
            res.addAll(this.weakLinks.keySet());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Closeable addListener(HttpListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener==null");
        }
        if (this.sync != null) {
            Object object = this.sync;
            synchronized (object) {
                return this.addListener0(listener);
            }
        }
        return this.addListener0(listener);
    }

    private Closeable addListener0(HttpListener listener) {
        this.listeners.add(listener);
        final HttpListener lstr = listener;
        return new Closeable(){
            private HttpListener l_str;
            {
                this.l_str = lstr;
            }

            @Override
            public void close() throws IOException {
                if (this.l_str != null) {
                    HttpListenersHelper.this.removeListener(this.l_str);
                    this.l_str = null;
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Closeable addListener(HttpListener listener, boolean weakLink) {
        if (listener == null) {
            throw new IllegalArgumentException("listener==null");
        }
        if (this.sync != null) {
            Object object = this.sync;
            synchronized (object) {
                if (weakLink) {
                    return this.addListenerWeak0(listener);
                }
                return this.addListener0(listener);
            }
        }
        if (weakLink) {
            return this.addListenerWeak0(listener);
        }
        return this.addListener0(listener);
    }

    private Closeable addListenerWeak0(HttpListener listener) {
        this.weakLinks.put(listener, true);
        final HttpListener lstr = listener;
        return new Closeable(){
            private HttpListener l_str;
            {
                this.l_str = lstr;
            }

            @Override
            public void close() throws IOException {
                if (this.l_str != null) {
                    HttpListenersHelper.this.removeListener(this.l_str);
                    this.l_str = null;
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(HttpListener listener) {
        if (this.sync != null) {
            Object object = this.sync;
            synchronized (object) {
                if (listener != null) {
                    this.listeners.remove(listener);
                    this.weakLinks.remove(listener);
                }
            }
        } else if (listener != null) {
            this.listeners.remove(listener);
            this.weakLinks.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(HttpEvent event) {
        HttpListener[] lstnrs = null;
        if (this.sync != null) {
            HttpListener[] httpListenerArray = this;
            synchronized (this) {
                lstnrs = this.getListeners().toArray(new HttpListener[0]);
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            lstnrs = this.getListeners().toArray(new HttpListener[0]);
        }
        {
            if (event != null) {
                for (HttpListener l : lstnrs) {
                    if (l == null) continue;
                    l.httpEvent(event);
                }
            }
            return;
        }
    }
}

