/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http;

import java.io.Closeable;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cbuffer.ContentBuffer;
import xyz.cofe.collection.Func1;
import xyz.cofe.http.HttpClient;
import xyz.cofe.http.HttpEvent;
import xyz.cofe.http.HttpHeaders;
import xyz.cofe.http.HttpListener;
import xyz.cofe.http.HttpListenersHelper;
import xyz.cofe.http.HttpResponse;

public class HttpRequest {
    protected static final AtomicLong sequenceID = new AtomicLong();
    protected final Lock lock;
    public final long id = sequenceID.incrementAndGet();
    private URL url = null;
    private String method = "GET";
    private HttpClient httpClient = null;
    private HttpHeaders httpHeaders = null;
    protected Integer connectTimeout = null;
    protected Integer readTimeout = null;
    protected final HttpListenersHelper httpListenerHelper = new HttpListenersHelper();
    protected Boolean async = null;
    protected ContentBuffer contentBuffer = null;
    protected long contentOffsetStart = -1L;
    protected long maxDownloadSize = -1L;
    protected boolean followRedirect = true;
    protected Func1<Object, URLConnection> data;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(HttpRequest.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(HttpRequest.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(HttpRequest.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(HttpRequest.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(HttpRequest.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(HttpRequest.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(HttpRequest.class.getName()).log(Level.SEVERE, null, ex);
    }

    public HttpRequest(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url==null");
        }
        this.url = url;
        this.lock = new ReentrantLock();
    }

    public HttpRequest(URL url, HttpClient httpClient) {
        if (url == null) {
            throw new IllegalArgumentException("url==null");
        }
        if (httpClient == null) {
            throw new IllegalArgumentException("httpClient==null");
        }
        this.httpClient = httpClient;
        this.url = url;
        this.lock = new ReentrantLock();
    }

    public HttpRequest(HttpRequest source) {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        try {
            source.lock.lock();
            this.httpClient = source.getHttpClient();
            this.httpHeaders = source.getHttpHeaders().clone();
            this.method = source.getMethod();
            this.url = source.getUrl();
            this.async = source.isAsync();
            this.connectTimeout = source.getConnectTimeout();
            this.readTimeout = source.getReadTimeout();
            this.lock = new ReentrantLock();
            this.data = source.getData();
        }
        finally {
            source.lock.unlock();
        }
    }

    public HttpRequest clone() {
        return new HttpRequest(this);
    }

    public final long getId() {
        return this.id;
    }

    public URL getUrl() {
        try {
            this.lock.lock();
            URL uRL = this.url;
            return uRL;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setUrl(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url==null");
        }
        try {
            this.lock.lock();
            this.url = url;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getMethod() {
        try {
            this.lock.lock();
            if (this.method == null) {
                this.method = "GET";
            }
            String string = this.method;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setMethod(String method) {
        if (method == null) {
            throw new IllegalArgumentException("method==null");
        }
        try {
            this.lock.lock();
            this.method = method;
        }
        finally {
            this.lock.unlock();
        }
    }

    public HttpClient getHttpClient() {
        try {
            this.lock.lock();
            if (this.httpClient == null) {
                this.httpClient = new HttpClient();
            }
            HttpClient httpClient = this.httpClient;
            return httpClient;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setHttpClient(HttpClient httpClient) {
        try {
            this.lock.lock();
            this.httpClient = httpClient;
        }
        finally {
            this.lock.unlock();
        }
    }

    public HttpHeaders getHttpHeaders() {
        try {
            this.lock.lock();
            if (this.httpHeaders == null) {
                this.httpHeaders = new HttpHeaders();
            }
            HttpHeaders httpHeaders = this.httpHeaders;
            return httpHeaders;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setHttpHeaders(HttpHeaders headers) {
        try {
            this.lock.lock();
            this.httpHeaders = headers;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyHeadersTo(URLConnection connection) {
        try {
            this.lock.lock();
            if (connection == null) {
                throw new IllegalArgumentException("connection==null");
            }
            for (Map.Entry<String, List<String>> e : this.getHttpHeaders().getMultiMap().entrySet()) {
                String k = e.getKey();
                List<String> lv = e.getValue();
                if (k == null || lv == null || lv.isEmpty()) continue;
                String v = lv.get(0);
                connection.setRequestProperty(k, v);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserAgent() {
        try {
            this.lock.lock();
            HttpHeaders hh = this.getHttpHeaders();
            String ua = hh.getUserAgent();
            if (ua == null) {
                if (this.httpClient != null) {
                    String ua1 = this.httpClient.getUserAgent();
                    if (ua1 != null) {
                        hh.setUserAgent(ua1);
                        String string = ua1;
                        return string;
                    }
                    String string = null;
                    return string;
                }
                String string = null;
                return string;
            }
            String string = ua;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setUserAgent(String userAgent) {
        try {
            this.lock.lock();
            HttpHeaders hh = this.getHttpHeaders();
            hh.setUserAgent(userAgent);
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getConnectTimeout() {
        try {
            this.lock.lock();
            if (this.connectTimeout == null) {
                this.connectTimeout = this.httpClient != null ? Integer.valueOf(this.httpClient.getConnectTimeout()) : Integer.valueOf(30000);
                int n = this.connectTimeout;
                return n;
            }
            int n = this.connectTimeout;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setConnectTimeout(int connectTimeoutMS) {
        if (connectTimeoutMS < 0) {
            throw new IllegalArgumentException("connectTimeoutMS<0");
        }
        try {
            this.lock.lock();
            this.connectTimeout = connectTimeoutMS;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getReadTimeout() {
        try {
            this.lock.lock();
            if (this.readTimeout == null) {
                this.readTimeout = this.httpClient != null ? Integer.valueOf(this.httpClient.getReadTimeout()) : Integer.valueOf(30000);
                int n = this.readTimeout;
                return n;
            }
            int n = this.readTimeout;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setReadTimeout(int readTimeoutMS) {
        if (readTimeoutMS < 0) {
            throw new IllegalArgumentException("readTimeoutMS<0");
        }
        try {
            this.lock.lock();
            this.readTimeout = readTimeoutMS;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Set<HttpListener> getListeners() {
        return this.httpListenerHelper.getListeners();
    }

    public Closeable addListener(HttpListener listener) {
        return this.httpListenerHelper.addListener(listener);
    }

    public Closeable addListener(HttpListener listener, boolean weakLink) {
        return this.httpListenerHelper.addListener(listener, weakLink);
    }

    public void removeListener(HttpListener listener) {
        this.httpListenerHelper.removeListener(listener);
    }

    protected void fireEvent(HttpEvent event) {
        this.httpListenerHelper.fireEvent(event);
    }

    public boolean isAsync() {
        try {
            this.lock.lock();
            if (this.async == null) {
                this.async = false;
            }
            boolean bl = this.async;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setAsync(boolean async) {
        try {
            this.lock.lock();
            this.async = async;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ContentBuffer getContentBuffer() {
        try {
            this.lock.lock();
            ContentBuffer contentBuffer = this.contentBuffer;
            return contentBuffer;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setContentBuffer(ContentBuffer contentBuffer) {
        try {
            this.lock.lock();
            this.contentBuffer = contentBuffer;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getContentOffsetStart() {
        try {
            this.lock.lock();
            long l = this.contentOffsetStart;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setContentOffsetStart(long contentOffsetStart) {
        try {
            this.lock.lock();
            this.contentOffsetStart = contentOffsetStart;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getMaxDownloadSize() {
        try {
            this.lock.lock();
            long l = this.maxDownloadSize;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setMaxDownloadSize(long maxSize) {
        try {
            this.lock.lock();
            this.maxDownloadSize = maxSize;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isFollowRedirect() {
        try {
            this.lock.lock();
            boolean bl = this.followRedirect;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setFollowRedirect(boolean followRedirect) {
        try {
            this.lock.lock();
            this.followRedirect = followRedirect;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Func1<Object, URLConnection> getData() {
        try {
            this.lock.lock();
            Func1<Object, URLConnection> func1 = this.data;
            return func1;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setData(Func1<Object, URLConnection> data) {
        try {
            this.lock.lock();
            this.data = data;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void prepareUserAgent(URLConnection connection) {
        String ua1;
        HttpHeaders hh = this.getHttpHeaders();
        String ua = hh.getUserAgent();
        if (ua == null && this.httpClient != null && (ua1 = this.httpClient.getUserAgent()) != null) {
            hh.setUserAgent(ua1);
        }
    }

    protected void prepareRequiredHeaders(URLConnection connection) {
        HttpRequest.logFine("prepareRequiredHeaders", new Object[0]);
        if (connection != null) {
            String existsCookie;
            String cookie;
            if (this.httpHeaders == null) {
                this.httpHeaders = new HttpHeaders();
            }
            if ((cookie = connection.getRequestProperty("Cookie")) != null && (existsCookie = this.httpHeaders.getCookie()) == null) {
                this.httpHeaders.setCookie(cookie);
            }
        }
        this.prepareUserAgent(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLConnection openURLConnection() throws IOException {
        HttpClient client = null;
        List<Proxy> lproxy = null;
        URLConnection connection = null;
        try {
            this.lock.lock();
            client = this.getHttpClient();
            try {
                lproxy = client.getProxySelector().select(this.url.toURI());
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(HttpRequest.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (lproxy == null || lproxy.isEmpty()) {
                HttpRequest.logFine("open url connection: {0}", this.url);
                connection = this.url.openConnection();
            } else {
                IOException err = null;
                for (Proxy p : lproxy) {
                    if (connection != null) break;
                    try {
                        err = null;
                        HttpRequest.logFine("open url connection: {0} through proxy {1}", this.url, p);
                        connection = this.url.openConnection(p);
                    }
                    catch (IOException ex) {
                        err = ex;
                        connection = null;
                        HttpRequest.logException(err);
                    }
                }
                if (err != null) {
                    throw err;
                }
            }
            if (connection == null) {
                throw new IOException("can't open connection to " + this.url);
            }
            this.prepareRequiredHeaders(connection);
            this.applyHeadersTo(connection);
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                if (this.method != null) {
                    try {
                        httpConnection.setRequestMethod(this.method);
                    }
                    catch (ProtocolException ex) {
                        Logger.getLogger(HttpRequest.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                httpConnection.setInstanceFollowRedirects(false);
                httpConnection.setConnectTimeout(this.getConnectTimeout());
                httpConnection.setReadTimeout(this.getReadTimeout());
            }
            URLConnection uRLConnection = connection;
            return uRLConnection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public HttpResponse createResponse() {
        try {
            URLConnection conn = this.openURLConnection();
            return new HttpResponse(this, conn);
        }
        catch (IOException ex) {
            Logger.getLogger(HttpRequest.class.getName()).log(Level.SEVERE, null, ex);
            return new HttpResponse(this, ex);
        }
    }
}

