/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cbuffer.ContentBuffer;
import xyz.cofe.cbuffer.ContentBufferInputStream;
import xyz.cofe.cbuffer.MemContentBuffer;
import xyz.cofe.collection.BasicPair;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.Func4;
import xyz.cofe.collection.Pair;
import xyz.cofe.common.CloseableSet;
import xyz.cofe.http.HttpClient;
import xyz.cofe.http.HttpEvent;
import xyz.cofe.http.HttpHeaders;
import xyz.cofe.http.HttpListener;
import xyz.cofe.http.HttpListenerAdapter;
import xyz.cofe.http.HttpListenersHelper;
import xyz.cofe.http.HttpRequest;
import xyz.cofe.http.HttpStatusHelper;
import xyz.cofe.http.IsFinished;
import xyz.cofe.text.Text;

public class HttpResponse
implements IsFinished {
    protected static final HttpStatusHelper httpStatusHelper = new HttpStatusHelper();
    protected static final AtomicLong sequenceID = new AtomicLong();
    public final long id = sequenceID.incrementAndGet();
    protected final Lock lock;
    private boolean sendFinishedOnAddListener = false;
    protected URLConnection connection = null;
    protected Func1<Object, URLConnection> data;
    private final HttpRequest request;
    private final List<Throwable> errors = new ArrayList<Throwable>();
    protected final HttpListenersHelper httpListenerHelper = new HttpListenersHelper();
    protected long downloadedSize = 0L;
    protected Long maxDownloadSize = null;
    protected Date started = null;
    protected Date finished = null;
    protected State state = State.Prepare;
    protected int statusCode = -1;
    protected String statusMessage = "";
    protected Thread thread = null;
    protected Boolean async = null;
    protected int downloadBufferSize = 65536;
    private HttpHeaders httpHeaders = null;
    protected ContentBuffer contentBuffer = null;
    protected Charset contentCharset = null;
    protected String text = null;
    protected Long contentWriterPos = null;
    protected String threadName = null;
    protected Boolean followRedirect = null;
    protected final List<HttpResponse> redirects = new ArrayList<HttpResponse>();
    protected final List<Pair<URL, URL>> redirectUrls = new ArrayList<Pair<URL, URL>>();
    protected Func4<Boolean, HttpHeaders, URL, URL, List<Pair<URL, URL>>> redirectValidate = null;
    protected HttpRequest currentRequest = null;
    protected volatile AtomicBoolean needPause = new AtomicBoolean(false);
    protected volatile AtomicBoolean continueSignal = new AtomicBoolean(false);

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(HttpResponse.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(HttpResponse.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(HttpResponse.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(HttpResponse.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(HttpResponse.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(HttpResponse.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(HttpResponse.class.getName()).log(Level.SEVERE, null, ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse(HttpResponse source, HttpRequest req, boolean cloneHeaders, boolean cloneContentBuffer) {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        this.lock = new ReentrantLock();
        try {
            source.lock.lock();
            this.request = req != null ? req : source.request;
            this.state = source.state;
            this.errors.clear();
            this.errors.addAll(source.errors);
            this.async = source.async;
            this.downloadBufferSize = source.downloadBufferSize;
            this.contentBuffer = source.contentBuffer != null ? (cloneContentBuffer ? source.contentBuffer.clone() : source.contentBuffer) : this.contentBuffer;
            this.contentCharset = source.contentCharset;
            this.contentWriterPos = source.contentWriterPos;
            this.downloadedSize = source.downloadedSize;
            this.httpHeaders = source.httpHeaders != null ? (cloneHeaders ? source.httpHeaders.clone() : source.httpHeaders) : this.httpHeaders;
            this.started = source.started;
            this.finished = source.finished;
            this.statusCode = source.statusCode;
            this.statusMessage = source.statusMessage;
            this.followRedirect = source.followRedirect;
            this.currentRequest = source.currentRequest;
            this.text = source.text;
            this.data = source.getData();
        }
        finally {
            source.lock.unlock();
        }
    }

    public HttpResponse(HttpResponse source, boolean cloneHeaders, boolean cloneContentBuffer) {
        this(source, null, true, true);
    }

    public HttpResponse(HttpRequest request, Throwable error) {
        if (request == null) {
            throw new IllegalArgumentException("request==null");
        }
        if (error == null) {
            throw new IllegalArgumentException("error==null");
        }
        this.lock = new ReentrantLock();
        this.request = request;
        this.errors.add(error);
        this.setState(State.Finished);
        this.sendFinishedOnAddListener = true;
        this.data = request.getData();
    }

    public HttpResponse(HttpRequest request, URLConnection connection) {
        if (request == null) {
            throw new IllegalArgumentException("request==null");
        }
        this.lock = new ReentrantLock();
        this.request = request;
        this.connection = connection;
        try {
            request.lock.lock();
            this.contentBuffer = request.contentBuffer;
            this.followRedirect = request.followRedirect;
            this.contentWriterPos = request.contentOffsetStart;
            if (this.contentWriterPos != null && this.contentWriterPos < 0L) {
                this.contentWriterPos = 0L;
            }
            this.async = request.async;
            this.maxDownloadSize = request.maxDownloadSize;
            this.data = request.getData();
        }
        finally {
            request.lock.unlock();
        }
    }

    public Lock getLock() {
        return this.lock;
    }

    public final long getId() {
        return this.id;
    }

    public HttpResponse clone() {
        return new HttpResponse(this, true, true);
    }

    public HttpResponse clone(boolean cloneHeaders, boolean cloneBuffer) {
        return new HttpResponse(this, cloneHeaders, cloneBuffer);
    }

    protected HttpResponse clone(HttpRequest req, boolean cloneHeaders, boolean cloneBuffer) {
        return new HttpResponse(this, req, cloneHeaders, cloneBuffer);
    }

    public void start() {
        State s = this.getState();
        if (!State.Prepare.equals((Object)s)) {
            throw new IllegalStateException("state is not prepare");
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (HttpResponse.this.connection == null) {
                    try {
                        HttpResponse.this.connection = HttpResponse.this.request.openURLConnection();
                        HttpResponse.this.start(HttpResponse.this.request, HttpResponse.this.request.getUrl(), HttpResponse.this.connection);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(HttpResponse.class.getName()).log(Level.SEVERE, null, ex);
                        HttpResponse.this.addError(ex);
                        HttpResponse.this.setState(State.Finished);
                    }
                } else {
                    HttpResponse.this.start(HttpResponse.this.request, HttpResponse.this.request.getUrl(), HttpResponse.this.connection);
                }
            }
        };
        if (this.isAsync()) {
            if (this.thread != null && this.thread.isAlive()) {
                this.stop();
            }
            this.thread = (Thread)this.request.getHttpClient().createResponseThread().apply((Object)this, (Object)r);
            String thName = this.getThreadName();
            if (thName != null) {
                this.thread.setName(thName);
            }
            this.setState(State.Started);
            this.thread.start();
        } else {
            this.setState(State.Started);
            r.run();
        }
    }

    public Func1<Object, URLConnection> getData() {
        try {
            this.lock.lock();
            Func1<Object, URLConnection> func1 = this.data;
            return func1;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setData(Func1<Object, URLConnection> data) {
        try {
            this.lock.lock();
            this.data = data;
        }
        finally {
            this.lock.unlock();
        }
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public List<Throwable> getErrors() {
        try {
            this.lock.lock();
            ArrayList<Throwable> l = new ArrayList<Throwable>();
            l.addAll(this.errors);
            ArrayList<Throwable> arrayList = l;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void addError(Throwable err) {
        try {
            this.lock.lock();
            this.errors.add(err);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Set<HttpListener> getListeners() {
        return this.httpListenerHelper.getListeners();
    }

    public Closeable addListener(HttpListener listener) {
        Closeable c = this.httpListenerHelper.addListener(listener);
        if (this.sendFinishedOnAddListener && listener != null) {
            listener.httpEvent(new StateChangedEvent(this, State.Prepare, State.Finished));
        }
        return c;
    }

    public Closeable addListener(HttpListener listener, boolean weakLink) {
        Closeable c = this.httpListenerHelper.addListener(listener, weakLink);
        if (this.sendFinishedOnAddListener && listener != null) {
            listener.httpEvent(new StateChangedEvent(this, State.Prepare, State.Finished));
        }
        return c;
    }

    public void removeListener(HttpListener listener) {
        this.httpListenerHelper.removeListener(listener);
    }

    protected void fireEvent(HttpEvent event) {
        this.httpListenerHelper.fireEvent(event);
    }

    public long getDownloadedSize() {
        try {
            this.lock.lock();
            long l = this.downloadedSize;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getMaxDownloadSize() {
        try {
            this.lock.lock();
            if (this.maxDownloadSize == null) {
                this.maxDownloadSize = this.request.getMaxDownloadSize();
            }
            long l = this.maxDownloadSize;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setMaxDownloadSize(long maxSize) {
        try {
            this.lock.lock();
            this.maxDownloadSize = maxSize;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Date getStarted() {
        try {
            this.lock.lock();
            Date date = this.started;
            return date;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Date getFinished() {
        try {
            this.lock.lock();
            Date date = this.finished;
            return date;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isErrorsNotExists() {
        try {
            this.lock.lock();
            if (this.errors != null && !this.errors.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            if (this.httpHeaders == null) {
                boolean bl = false;
                return bl;
            }
            if (this.statusCode < 200 || this.statusCode > 299) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public State getState() {
        try {
            this.lock.lock();
            State state = this.state;
            return state;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(State newState) {
        State old = null;
        boolean fire = false;
        try {
            this.lock.lock();
            old = this.state;
            this.state = newState;
            if (old != newState) {
                if (State.Started.equals((Object)newState)) {
                    this.started = new Date();
                }
                if (State.Finished.equals((Object)newState)) {
                    this.finished = new Date();
                }
                fire = true;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (fire) {
            this.fireEvent(new StateChangedEvent(this, old, newState));
        }
    }

    @Override
    public boolean isFinished() {
        try {
            this.lock.lock();
            boolean bl = State.Finished.equals((Object)this.state);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getStatusCode() {
        try {
            this.lock.lock();
            int n = this.statusCode;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void setStatusCode(int newStatusCode) {
        try {
            this.lock.lock();
            this.statusCode = newStatusCode;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getStatusMessage() {
        try {
            this.lock.lock();
            String string = this.statusMessage;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void setStatusMessage(String statusMessage) {
        try {
            this.lock.lock();
            this.statusMessage = statusMessage;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Thread getThread() {
        try {
            this.lock.lock();
            Thread thread = this.thread;
            return thread;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isAsync() {
        try {
            this.lock.lock();
            if (this.async == null) {
                this.async = this.request != null ? Boolean.valueOf(this.request.isAsync()) : Boolean.valueOf(false);
            }
            boolean bl = this.async;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getDownloadBufferSize() {
        try {
            this.lock.lock();
            int n = this.downloadBufferSize;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setDownloadBufferSize(int buffSize) {
        try {
            this.lock.lock();
            if (buffSize < 1) {
                throw new IllegalArgumentException("buffSize < 1");
            }
            this.downloadBufferSize = buffSize;
        }
        finally {
            this.lock.unlock();
        }
    }

    public HttpHeaders getHttpHeaders() {
        try {
            this.lock.lock();
            HttpHeaders httpHeaders = this.httpHeaders;
            return httpHeaders;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void setHttpHeaders(HttpHeaders headers) {
        try {
            this.lock.lock();
            this.httpHeaders = headers;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ContentBuffer getContentBuffer() {
        try {
            this.lock.lock();
            if (this.contentBuffer == null) {
                ContentBuffer cb;
                this.contentBuffer = this.request != null ? ((cb = this.request.getContentBuffer()) != null ? cb : new MemContentBuffer()) : new MemContentBuffer();
            }
            ContentBuffer contentBuffer = this.contentBuffer;
            return contentBuffer;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Charset getContentCharset() {
        try {
            HttpClient hc;
            this.lock.lock();
            if (this.contentCharset != null) {
                Charset charset = this.contentCharset;
                return charset;
            }
            if (this.httpHeaders != null) {
                Charset cs = this.httpHeaders.getContentTypeCharset();
                if (cs != null) {
                    this.contentCharset = cs;
                    Charset charset = cs;
                    return charset;
                }
            } else if (this.request != null && (hc = this.request.getHttpClient()) != null) {
                Charset cs;
                Charset charset = cs = hc.getDefaultCharset();
                return charset;
            }
            Charset charset = Charset.forName("ISO-8859-1");
            return charset;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText() {
        try {
            this.lock.lock();
            if (this.text != null) {
                String string = this.text;
                return string;
            }
            Charset cs = this.getContentCharset();
            if (cs == null) {
                String string = null;
                return string;
            }
            StringBuilder buff = new StringBuilder();
            char[] cbuf = new char[this.getDownloadBufferSize()];
            InputStreamReader reader = new InputStreamReader((InputStream)new ContentBufferInputStream(this.getContentBuffer(), 0L, this.getDownloadedSize()), cs);
            while (true) {
                int r;
                try {
                    r = reader.read(cbuf);
                }
                catch (IOException ex) {
                    Logger.getLogger(HttpResponse.class.getName()).log(Level.SEVERE, null, ex);
                    break;
                }
                if (r < 0) break;
                if (r <= 0) continue;
                buff.append(cbuf, 0, r);
            }
            String txt = buff.toString();
            if (this.isFinished()) {
                this.text = txt;
            }
            String string = txt;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getContentWriterPos() {
        try {
            this.lock.lock();
            if (this.contentWriterPos == null) {
                if (this.request != null) {
                    this.contentWriterPos = this.request.getContentOffsetStart();
                    if (this.contentWriterPos < 0L) {
                        this.contentWriterPos = 0L;
                    }
                } else {
                    this.contentWriterPos = 0L;
                }
            }
            long l = this.contentWriterPos;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void setContentWriterPos(long pos) {
        try {
            this.lock.lock();
            this.contentWriterPos = pos;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getThreadName() {
        try {
            this.lock.lock();
            String string = this.threadName;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setThreadName(String threadName) {
        try {
            this.lock.lock();
            this.threadName = threadName;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isFollowRedirect() {
        try {
            this.lock.lock();
            if (this.followRedirect == null) {
                this.followRedirect = this.request.isFollowRedirect();
            }
            boolean bl = this.followRedirect;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setFollowRedirect(boolean followRedirect) {
        try {
            this.lock.lock();
            this.followRedirect = followRedirect;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<HttpResponse> getRedirectResponses() {
        ArrayList<HttpResponse> res = new ArrayList<HttpResponse>();
        try {
            this.lock.lock();
            res.addAll(this.redirects);
        }
        finally {
            this.lock.unlock();
        }
        return res;
    }

    public List<Pair<URL, URL>> getRedirectUrls() {
        ArrayList<Pair<URL, URL>> res = new ArrayList<Pair<URL, URL>>();
        try {
            this.lock.lock();
            res.addAll(this.redirectUrls);
        }
        finally {
            this.lock.unlock();
        }
        return res;
    }

    public Pair<URL, URL> getLastRedirectUrl() {
        try {
            this.lock.lock();
            int s = this.redirectUrls.size();
            if (s < 1) {
                Pair<URL, URL> pair = null;
                return pair;
            }
            Pair<URL, URL> pair = this.redirectUrls.get(s - 1);
            return pair;
        }
        finally {
            this.lock.unlock();
        }
    }

    public URL getLastRedirectUrlTo() {
        try {
            this.lock.lock();
            Pair<URL, URL> purl = this.getLastRedirectUrl();
            if (purl != null) {
                URL uRL = (URL)purl.B();
                return uRL;
            }
            URL uRL = null;
            return uRL;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRedirect(HttpResponse response, URL from, URL to) {
        try {
            this.lock.lock();
            this.redirects.add(response);
            this.redirectUrls.add((Pair<URL, URL>)new BasicPair((Object)from, (Object)to));
        }
        finally {
            this.lock.unlock();
        }
    }

    public Func4<Boolean, HttpHeaders, URL, URL, List<Pair<URL, URL>>> getRedirectValidate() {
        try {
            this.lock.lock();
            if (this.redirectValidate == null) {
                Func4<Boolean, HttpHeaders, URL, URL, List<Pair<URL, URL>>> func4 = this.redirectValidate;
                return func4;
            }
            Func4<Boolean, HttpHeaders, URL, URL, List<Pair<URL, URL>>> func4 = this.redirectValidate;
            return func4;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setRedirectValidate(Func4<Boolean, HttpHeaders, URL, URL, List<Pair<URL, URL>>> redirectValidate) {
        try {
            this.lock.lock();
            this.redirectValidate = redirectValidate;
        }
        finally {
            this.lock.unlock();
        }
    }

    public HttpRequest getCurrentRequest() {
        try {
            this.lock.lock();
            if (this.currentRequest == null) {
                HttpRequest httpRequest = this.request;
                return httpRequest;
            }
            HttpRequest httpRequest = this.currentRequest;
            return httpRequest;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void setCurrentRequest(HttpRequest currentRequest) {
        try {
            this.lock.lock();
            this.currentRequest = currentRequest;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(HttpRequest sourceRequest, URL urlFrom, URLConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection==null");
        }
        URLConnection conn = connection;
        this.setCurrentRequest(sourceRequest);
        try {
            this.lock.lock();
            if (this.data != null) {
                try {
                    this.data.apply((Object)conn);
                }
                catch (Throwable err) {
                    HttpResponse.logException(err);
                    this.setState(State.Finished);
                    this.errors.add(err);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        if (Thread.interrupted()) {
            this.setState(State.Finished);
            return;
        }
        if (this.hasPauseSignal()) {
            this.setState(State.Pause);
            while (true) {
                if (this.hasContinueSignal()) {
                    this.setState(State.Started);
                    break;
                }
                Thread.yield();
            }
        }
        HttpResponse.logFine("start {0}", this.getRequest().getUrl());
        InputStream inputStream = null;
        int statusCodeL = -1;
        String statusMessageL = null;
        if (conn instanceof HttpURLConnection) {
            HttpURLConnection httpConnection = (HttpURLConnection)conn;
            try {
                statusCodeL = httpConnection.getResponseCode();
            }
            catch (IOException ex) {
                Logger.getLogger(HttpResponse.class.getName()).log(Level.SEVERE, null, ex);
                this.addError(ex);
                this.setState(State.Finished);
                return;
            }
            this.setStatusCode(statusCodeL);
            try {
                statusMessageL = httpConnection.getResponseMessage();
            }
            catch (IOException ex) {
                Logger.getLogger(HttpResponse.class.getName()).log(Level.SEVERE, null, ex);
                this.addError(ex);
                this.setState(State.Finished);
                return;
            }
            this.setStatusMessage(statusMessageL);
            if (statusCodeL >= 400) {
                inputStream = httpConnection.getErrorStream();
            }
        }
        Map<String, List<String>> hhz = conn.getHeaderFields();
        HttpHeaders hh = HttpHeaders.createFromMultiMap(hhz);
        this.setHttpHeaders(hh);
        if (this.isFollowRedirect() && httpStatusHelper.isRedirect(statusCodeL)) {
            try {
                String loc = hh.getLocation();
                if (loc != null) {
                    URL urlTo = new URL(loc);
                    boolean validRedirect = true;
                    Func4<Boolean, HttpHeaders, URL, URL, List<Pair<URL, URL>>> redirectValidFun = this.getRedirectValidate();
                    if (redirectValidFun != null) {
                        validRedirect = (Boolean)redirectValidFun.apply((Object)hh, (Object)urlFrom, (Object)urlTo, this.getRedirectUrls());
                    }
                    if (validRedirect) {
                        HttpRequest req = sourceRequest.clone();
                        req.setUrl(urlTo);
                        req.getHttpHeaders().setReferer(urlFrom.toString());
                        this.addRedirect(this.clone(sourceRequest.clone(), true, false), urlFrom, urlTo);
                        try {
                            URLConnection uconn = req.openURLConnection();
                            this.fireEvent(new RedirectEvent(this, urlFrom, urlTo));
                            this.start(req, urlTo, uconn);
                            return;
                        }
                        catch (IOException ex) {
                            Logger.getLogger(HttpResponse.class.getName()).log(Level.SEVERE, null, ex);
                            this.addError(ex);
                            this.setState(State.Finished);
                            return;
                        }
                    }
                }
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(HttpResponse.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (inputStream == null) {
            try {
                inputStream = conn.getInputStream();
            }
            catch (IOException ex) {
                Logger.getLogger(HttpResponse.class.getName()).log(Level.SEVERE, null, ex);
                this.addError(ex);
                this.setState(State.Finished);
                return;
            }
        }
        HttpResponse.logFine("response:\nstatus {0} {1}\nheaders\n{2}", statusCodeL, statusMessageL, Text.indent((String)hh.toString(), (String)"\n", (String)"[Response] "));
        try {
            this.startDownloading(inputStream);
        }
        catch (IOException ex) {
            Logger.getLogger(HttpResponse.class.getName()).log(Level.SEVERE, null, ex);
            this.addError(ex);
            this.setState(State.Finished);
            return;
        }
        this.getContentBuffer().flush();
        this.setState(State.Finished);
    }

    public void pause() {
        try {
            this.lock.lock();
            this.needPause.set(true);
            this.continueSignal.set(false);
            HttpResponse.logFine("pause thread.isAlive={0}", this.thread != null ? this.thread.isAlive() : false);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean hasPauseSignal() {
        try {
            this.lock.lock();
            if (this.needPause.get()) {
                this.needPause.set(false);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void resume() {
        try {
            this.lock.lock();
            this.needPause.set(false);
            this.continueSignal.set(true);
            HttpResponse.logFine("resume thread.isAlive={0}", this.thread != null ? this.thread.isAlive() : false);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean hasContinueSignal() {
        try {
            this.lock.lock();
            if (this.continueSignal.get()) {
                this.continueSignal.set(false);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acceptDownloaded(byte[] buffer, int off, int len) {
        try {
            long overload;
            long targetDownloaded;
            this.lock.lock();
            boolean skipWrite = false;
            long maxDownload = this.getMaxDownloadSize();
            int writeLen = len;
            if (maxDownload >= 0L && (targetDownloaded = this.downloadedSize + (long)writeLen) > maxDownload && (writeLen = (int)(targetDownloaded - (overload = targetDownloaded - maxDownload))) < 0) {
                skipWrite = true;
            }
            if (!skipWrite) {
                long pos = this.getContentWriterPos();
                this.getContentBuffer().set(pos, buffer, off, writeLen);
                this.setContentWriterPos(pos += (long)writeLen);
                this.downloadedSize += (long)writeLen;
            }
        }
        finally {
            this.lock.unlock();
        }
        this.fireEvent(new ProgressEvent(this));
    }

    protected void startDownloading(InputStream inputStream) throws IOException {
        this.setState(State.Downloading);
        HttpResponse.logFine("State.Downloading", new Object[0]);
        int st = 0;
        boolean stopCycle = false;
        block4: while (!stopCycle) {
            switch (st) {
                case 0: {
                    long maxSize = this.getMaxDownloadSize();
                    long downloaded = this.getDownloadedSize();
                    if (maxSize >= 0L && downloaded >= maxSize) {
                        stopCycle = true;
                        HttpResponse.logFine("stop download", new Object[0]);
                        break;
                    }
                    byte[] buff = new byte[this.getDownloadBufferSize()];
                    int readed = inputStream.read(buff);
                    if (readed < 0) {
                        stopCycle = true;
                        HttpResponse.logFine("stop reading ", new Object[0]);
                        break;
                    }
                    if (readed > 0) {
                        this.acceptDownloaded(buff, 0, readed);
                        HttpResponse.logFine("readed {0}", readed);
                    }
                    if (Thread.interrupted()) {
                        stopCycle = true;
                        HttpResponse.logFine("stop download", new Object[0]);
                        break;
                    }
                    if (!this.hasPauseSignal()) continue block4;
                    st = 1;
                    this.setState(State.Pause);
                    HttpResponse.logFine("set State.Pause", new Object[0]);
                    break;
                }
                case 1: {
                    if (this.hasContinueSignal()) {
                        st = 0;
                        this.setState(State.Downloading);
                        HttpResponse.logFine("set State.Downloading", new Object[0]);
                        break;
                    }
                    if (Thread.interrupted()) {
                        stopCycle = true;
                        HttpResponse.logFine("stop download", new Object[0]);
                        break;
                    }
                    Thread.yield();
                }
            }
        }
        HttpResponse.logFine("end work trhead, close stream downloaded {0}", this.getDownloadedSize());
        inputStream.close();
    }

    public void stop(long waitStopMS, long forceStopMS, long sleepTimeMS) {
        if (waitStopMS < 0L) {
            throw new IllegalArgumentException("waitStopMS<0");
        }
        if (forceStopMS < 0L) {
            throw new IllegalArgumentException("forceStopMS<0");
        }
        Thread t = this.thread;
        if (t == null) {
            return;
        }
        t.interrupt();
        Date d1 = new Date();
        while (t.isAlive()) {
            Date d2 = new Date();
            long ddiff = d2.getTime() - d1.getTime();
            if (ddiff >= waitStopMS) {
                t.interrupt();
            }
            if (ddiff >= forceStopMS) {
                t.stop();
            }
            if (sleepTimeMS <= 0L) {
                Thread.yield();
                continue;
            }
            try {
                Thread.sleep(sleepTimeMS);
                Thread.yield();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(HttpResponse.class.getName()).log(Level.FINE, null, ex);
                break;
            }
        }
    }

    public void stop() {
        int readtimeout = this.request.getReadTimeout();
        if (readtimeout > 0) {
            this.stop(100L, readtimeout * 3, 50L);
        } else {
            this.stop(100L, 5000L, 50L);
        }
    }

    public void waitForFinished() {
        Thread tt = Thread.currentThread();
        Thread t = null;
        try {
            if (this.lock != null) {
                this.lock.lock();
            }
            t = this.thread;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
        if (t == null) {
            throw new IllegalStateException("not async started");
        }
        if (t.equals(tt)) {
            throw new Error("thread can be locked");
        }
        while (!this.isFinished() || t.isAlive()) {
            Thread.yield();
        }
    }

    public Closeable onFinished(final Func1<Object, HttpResponse> runOnFinsihed) {
        if (runOnFinsihed == null) {
            throw new IllegalArgumentException("runOnFinsihed==null");
        }
        final CloseableSet cset = new CloseableSet();
        HttpListenerAdapter listener = new HttpListenerAdapter(){
            private CloseableSet cs;
            private Func1<Object, HttpResponse> call;
            {
                this.cs = cset;
                this.call = runOnFinsihed;
            }

            @Override
            protected void responseStateChanged(StateChangedEvent event, HttpResponse response, State oldState, State newState) {
                if (State.Finished.equals((Object)newState)) {
                    if (this.cs != null) {
                        this.cs.closeAll();
                        this.cs = null;
                    }
                    if (this.call != null) {
                        this.call.apply((Object)response);
                        this.call = null;
                    }
                }
            }
        };
        cset.add(this.addListener(listener, false));
        Closeable cl = new Closeable(){

            @Override
            public void close() throws IOException {
                cset.closeAll();
            }
        };
        return cl;
    }

    public static class RedirectEvent
    extends HttpEvent {
        protected HttpResponse response = null;
        protected URL from = null;
        protected URL to = null;

        public RedirectEvent(HttpResponse response, URL from, URL to) {
            this.response = response;
            this.from = from;
            this.to = to;
        }

        public HttpResponse getHttpResponse() {
            return this.response;
        }

        public URL getFrom() {
            return this.from;
        }

        public URL getTo() {
            return this.to;
        }
    }

    public static class StateChangedEvent
    extends HttpEvent {
        protected HttpResponse httpResponse = null;
        protected State oldState = null;
        protected State newState = null;

        public StateChangedEvent(HttpResponse downloader, State oldState, State newState) {
            this.httpResponse = downloader;
            this.oldState = oldState;
            this.newState = newState;
        }

        public HttpResponse getHttpResponse() {
            return this.httpResponse;
        }

        public State getOldState() {
            return this.oldState;
        }

        public State getNewState() {
            return this.newState;
        }
    }

    public static enum State {
        Prepare,
        Started,
        Downloading,
        Pause,
        Finished;

    }

    public static class ProgressEvent
    extends HttpEvent {
        protected HttpResponse httpResponse = null;

        public ProgressEvent(HttpResponse httpResponse) {
            this.httpResponse = httpResponse;
        }

        public HttpResponse getHttpResponse() {
            return this.httpResponse;
        }
    }
}

