/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http;

import java.net.InetSocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InetAddress
implements Comparable<InetAddress> {
    private static final Logger logger = Logger.getLogger(InetAddress.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private String host;
    private int port;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public InetAddress() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress(InetAddress src) {
        if (src == null) {
            throw new IllegalArgumentException("src==null");
        }
        InetAddress inetAddress = src;
        synchronized (inetAddress) {
            this.host = src != null ? src.host : this.host;
            this.port = src != null ? src.port : this.port;
        }
    }

    public InetAddress(InetSocketAddress src) {
        if (src != null) {
            this.host = src.getAddress().getHostAddress();
            this.port = src.getPort();
        }
    }

    public InetAddress(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public InetAddress clone() {
        return new InetAddress(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getHost() {
        InetAddress inetAddress = this;
        synchronized (inetAddress) {
            return this.host;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setHost(String host) {
        InetAddress inetAddress = this;
        synchronized (inetAddress) {
            this.host = host;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getPort() {
        InetAddress inetAddress = this;
        synchronized (inetAddress) {
            return this.port;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPort(int port) {
        InetAddress inetAddress = this;
        synchronized (inetAddress) {
            this.port = port;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetSocketAddress getInetSocketAddress() {
        InetAddress inetAddress = this;
        synchronized (inetAddress) {
            if (this.host == null) {
                throw new IllegalStateException("host property not set");
            }
            if (this.port < 0) {
                throw new IllegalStateException("port property less then 0");
            }
            if (this.port > 65535) {
                throw new IllegalStateException("port property more then 65535");
            }
            return InetSocketAddress.createUnresolved(this.host, this.port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        InetAddress inetAddress = this;
        synchronized (inetAddress) {
            int hash = 3;
            hash = 59 * hash + (this.host != null ? this.host.hashCode() : 0);
            hash = 59 * hash + this.port;
            return hash;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InetAddress other = (InetAddress)obj;
        InetAddress inetAddress = this;
        synchronized (inetAddress) {
            InetAddress inetAddress2 = other;
            synchronized (inetAddress2) {
                if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                    return false;
                }
                return this.port == other.port;
                {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compareTo(InetAddress adr) {
        if (adr == null) {
            return -1;
        }
        InetAddress inetAddress = this;
        synchronized (inetAddress) {
            InetAddress inetAddress2 = adr;
            synchronized (inetAddress2) {
                int cmpp;
                String h1 = this.host;
                String h2 = adr.host;
                int n = this.port == adr.port ? 0 : (cmpp = this.port < adr.port ? -1 : 1);
                if (h1 == null && h2 == null) {
                    return cmpp;
                }
                if (h1 != null && h2 == null) {
                    return -1;
                }
                if (h1 == null && h2 != null) {
                    return 1;
                }
                int cmph = h1.compareToIgnoreCase(h2);
                int n2 = cmph == 0 ? cmpp : cmph;
                return n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        InetAddress inetAddress = this;
        synchronized (inetAddress) {
            return "InetAddress{host=" + this.host + ", port=" + this.port + '}';
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

