/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.map.ICaseStringMap;

public class MimeTypes {
    protected final Map<String, Qualifier> mime2qualifier;
    protected final Map<String, String> extension2mime;
    protected final Lock lock = new ReentrantLock();

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(MimeTypes.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(MimeTypes.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(MimeTypes.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(MimeTypes.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(MimeTypes.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(MimeTypes.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(MimeTypes.class.getName()).log(Level.SEVERE, null, ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimeTypes() {
        ICaseStringMap icaseMap2;
        ICaseStringMap icaseMap;
        this.mime2qualifier = icaseMap = new ICaseStringMap(true);
        this.extension2mime = icaseMap2 = new ICaseStringMap(true);
        boolean propsReaded = false;
        URL uProps = MimeTypes.class.getResource("mime.properties");
        if (uProps != null) {
            InputStream instr = null;
            try {
                instr = uProps.openStream();
                Properties p = new Properties();
                p.load(instr);
                this.read(p);
                propsReaded = true;
            }
            catch (IOException ex) {
                Logger.getLogger(MimeTypes.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    instr.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(MimeTypes.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        this.initDefault();
    }

    protected void initDefault() {
        this.mime2qualifier.put("text/plain", new Qualifier().text(true));
        this.mime2qualifier.put("text/php", new Qualifier().text(true));
        this.mime2qualifier.put("text/xml", new Qualifier().text(true));
        this.mime2qualifier.put("text/javascript", new Qualifier().text(true));
        this.mime2qualifier.put("text/html", new Qualifier().text(true).html(true));
        this.mime2qualifier.put("text/csv", new Qualifier().text(true));
        this.mime2qualifier.put("text/css", new Qualifier().text(true));
        this.mime2qualifier.put("text/cmd", new Qualifier().text(true));
        this.mime2qualifier.put("text/markdown", new Qualifier().text(true));
        this.mime2qualifier.put("text/rtf", new Qualifier().text(true));
        this.mime2qualifier.put("text/x-markdown", new Qualifier().text(true));
        this.mime2qualifier.put("application/atom+xml", new Qualifier().text(true));
        this.mime2qualifier.put("application/json", new Qualifier().text(true));
        this.mime2qualifier.put("application/javascript", new Qualifier().text(true));
        this.mime2qualifier.put("application/soap+xml", new Qualifier().text(true));
        this.mime2qualifier.put("application/x-javascript", new Qualifier().text(true));
        this.mime2qualifier.put("application/rdf+xml", new Qualifier().text(true));
        this.mime2qualifier.put("application/rss+xml", new Qualifier().text(true));
        this.mime2qualifier.put("application/xhtml+xml", new Qualifier().text(true));
        this.mime2qualifier.put("application/xml", new Qualifier().text(true));
        this.mime2qualifier.put("application/xml-dtd", new Qualifier().text(true));
        this.mime2qualifier.put("application/smil+xml", new Qualifier().text(true));
        this.mime2qualifier.put("application/xml", new Qualifier().text(true));
        this.mime2qualifier.put("application/xml", new Qualifier().text(true));
        this.mime2qualifier.put("image/svg+xml", new Qualifier().text(true));
        this.mime2qualifier.put("message/http", new Qualifier().text(true));
        this.mime2qualifier.put("message/imdn+xml", new Qualifier().text(true));
        this.mime2qualifier.put("model/vrml", new Qualifier().text(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Properties props) {
        if (props == null) {
            throw new IllegalArgumentException("props==null");
        }
        try {
            this.lock.lock();
            LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
            for (String k : props.stringPropertyNames()) {
                m.put(k, props.getProperty(k));
            }
            this.read(m);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Map<String, String> props) {
        if (props == null) {
            throw new IllegalArgumentException("props==null");
        }
        try {
            this.lock.lock();
            this.mime2qualifier.clear();
            this.extension2mime.clear();
            for (String k : props.keySet()) {
                if (k.startsWith("qualifier.")) {
                    String mime = k.substring("qualifier.".length());
                    String qualStr = props.get(k);
                    String[] qual = qualStr.split("\\s*,\\s*");
                    Qualifier q = new Qualifier();
                    for (String qu : qual) {
                        if (qu.equalsIgnoreCase("text")) {
                            q.text = true;
                        }
                        if (qu.equalsIgnoreCase("html")) {
                            q.html = true;
                        }
                        if (qu.equalsIgnoreCase("javascript")) {
                            q.javascript = true;
                        }
                        if (!qu.equalsIgnoreCase("xml")) continue;
                        q.xml = true;
                    }
                    this.mime2qualifier.put(mime, q);
                }
                if (!k.startsWith("extension.")) continue;
                String ext = k.substring("extension.".length());
                String mime = props.get(k);
                this.extension2mime.put(ext, mime);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getMimeForExtension(String ext) {
        if (ext == null) {
            throw new IllegalArgumentException("ext==null");
        }
        try {
            this.lock.lock();
            String string = this.extension2mime.get(ext);
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isText(String mime) {
        if (mime == null) {
            throw new IllegalArgumentException("mime==null");
        }
        try {
            this.lock.lock();
            Qualifier q = this.mime2qualifier.get(mime);
            if (q == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = q.text;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJavascript(String mime) {
        if (mime == null) {
            throw new IllegalArgumentException("mime==null");
        }
        try {
            this.lock.lock();
            Qualifier q = this.mime2qualifier.get(mime);
            if (q == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = q.javascript;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isXml(String mime) {
        if (mime == null) {
            throw new IllegalArgumentException("mime==null");
        }
        try {
            this.lock.lock();
            Qualifier q = this.mime2qualifier.get(mime);
            if (q == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = q.xml;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHtml(String mime) {
        if (mime == null) {
            throw new IllegalArgumentException("mime==null");
        }
        try {
            this.lock.lock();
            Qualifier q = this.mime2qualifier.get(mime);
            if (q == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = q.html;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasQualifier(String mime) {
        if (mime == null) {
            throw new IllegalArgumentException("mime==null");
        }
        try {
            this.lock.lock();
            Qualifier q = this.mime2qualifier.get(mime);
            if (q == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static class Qualifier {
        public boolean text = false;
        public boolean html = false;
        public boolean xml = false;
        public boolean javascript = false;

        public Qualifier text(boolean text) {
            this.text = text;
            return this;
        }

        public Qualifier html(boolean html) {
            this.html = html;
            return this;
        }
    }
}

