/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http;

import java.io.IOException;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.http.InetAddress;
import xyz.cofe.http.Proxy;
import xyz.cofe.http.UrlPattern;

public class MultiProxy
extends ProxySelector {
    private static final Logger logger = Logger.getLogger(MultiProxy.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private Proxy defaultProxy;
    private Map<UrlPattern, Proxy> urlMap;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public MultiProxy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiProxy(MultiProxy src) {
        if (src != null) {
            MultiProxy multiProxy = src;
            synchronized (multiProxy) {
                this.getUrlMap().putAll(src.getUrlMap());
                this.defaultProxy = src.getDefaultProxy().clone();
            }
        }
    }

    public MultiProxy clone() {
        return new MultiProxy(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Proxy getDefaultProxy() {
        MultiProxy multiProxy = this;
        synchronized (multiProxy) {
            if (this.defaultProxy == null) {
                this.defaultProxy = new Proxy(Proxy.Type.direct, new InetAddress("localhost", 0));
            }
            return this.defaultProxy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultProxy(Proxy proxy) {
        MultiProxy multiProxy = this;
        synchronized (multiProxy) {
            this.defaultProxy = proxy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<UrlPattern, Proxy> getUrlMap() {
        MultiProxy multiProxy = this;
        synchronized (multiProxy) {
            if (this.urlMap == null) {
                this.urlMap = new LinkedHashMap<UrlPattern, Proxy>();
            }
            return this.urlMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUrlMap(Map<UrlPattern, Proxy> urlMap) {
        MultiProxy multiProxy = this;
        synchronized (multiProxy) {
            this.urlMap = urlMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<java.net.Proxy> select(URI uri) {
        ArrayList<java.net.Proxy> lp = new ArrayList<java.net.Proxy>();
        Proxy defprx = null;
        Map<UrlPattern, Proxy> umap = null;
        Map.Entry[] entryArray = this;
        synchronized (this) {
            defprx = this.getDefaultProxy().clone();
            umap = this.getUrlMap();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (uri == null) {
                lp.add(defprx);
                return lp;
            }
            for (Map.Entry me : umap.entrySet().toArray(new Map.Entry[0])) {
                UrlPattern uptr = (UrlPattern)me.getKey();
                Proxy prx = (Proxy)me.getValue();
                if (uptr == null || prx == null) continue;
                uptr = uptr.clone();
                prx = prx.clone();
                if (!uptr.matched(uri)) continue;
                lp.add(prx);
            }
            if (lp.isEmpty()) {
                lp.add(defprx);
            }
            return lp;
        }
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

