/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http;

import java.io.IOException;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.http.InetAddress;
import xyz.cofe.http.Proxy;
import xyz.cofe.http.UrlPattern;

public class OneProxy
extends ProxySelector {
    private static final Logger logger = Logger.getLogger(OneProxy.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private volatile Proxy proxy;
    private Collection<UrlPattern> excepts = new LinkedHashSet<UrlPattern>();

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public OneProxy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OneProxy(OneProxy src) {
        if (src != null) {
            OneProxy oneProxy = src;
            synchronized (oneProxy) {
                this.getExcepts().addAll(src.getExcepts());
                this.proxy = src.getProxy().clone();
            }
        }
    }

    public OneProxy clone() {
        return new OneProxy(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Proxy getProxy() {
        OneProxy oneProxy = this;
        synchronized (oneProxy) {
            if (this.proxy == null) {
                this.proxy = new Proxy(Proxy.Type.direct, new InetAddress("localhost", 0));
            }
            return this.proxy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProxy(Proxy proxy) {
        OneProxy oneProxy = this;
        synchronized (oneProxy) {
            this.proxy = proxy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<UrlPattern> getExcepts() {
        OneProxy oneProxy = this;
        synchronized (oneProxy) {
            if (this.excepts == null) {
                this.excepts = new LinkedHashSet<UrlPattern>();
            }
            return this.excepts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExcepts(Collection<UrlPattern> exceptSet) {
        OneProxy oneProxy = this;
        synchronized (oneProxy) {
            this.excepts = exceptSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<java.net.Proxy> select(URI uri) {
        ArrayList<java.net.Proxy> lp = new ArrayList<java.net.Proxy>();
        Proxy tprx = null;
        ArrayList<UrlPattern> urls = new ArrayList<UrlPattern>();
        OneProxy oneProxy = this;
        synchronized (oneProxy) {
            tprx = this.getProxy().clone();
            Collection<UrlPattern> exc = this.getExcepts();
            for (UrlPattern uptr : exc.toArray(new UrlPattern[0])) {
                if (uptr == null) continue;
                urls.add(uptr.clone());
            }
        }
        if (uri == null) {
            lp.add(tprx);
            return lp;
        }
        for (UrlPattern up : urls) {
            if (up == null || !up.matched(uri)) continue;
            lp.add(java.net.Proxy.NO_PROXY);
            return lp;
        }
        if (lp.isEmpty()) {
            lp.add(tprx);
        }
        return lp;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
    }

    public String toString() {
        return "OneProxy{proxy=" + this.proxy + ", excepts=" + this.excepts + "}";
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

