/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.http.InetAddress;

public class Proxy
extends java.net.Proxy {
    private static final Logger logger = Logger.getLogger(Proxy.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private Type type;
    private InetAddress address;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public Proxy() {
        super(Proxy.Type.HTTP, new InetSocketAddress("localhost", 3128));
        this.address = new InetAddress("localhost", 3128);
        this.type = Type.direct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Proxy(Proxy src) {
        super(src == null ? Proxy.Type.DIRECT : src.type(), src == null ? null : src.address());
        if (src != null) {
            Proxy proxy = src;
            synchronized (proxy) {
                this.type = src.getType();
                this.address = src.getAddress().clone();
            }
        }
    }

    protected Proxy clone() {
        return new Proxy(this);
    }

    public Proxy(Type type, InetAddress address) {
        super(type == null ? Proxy.Type.DIRECT : type.get(), address == null ? null : address.getInetSocketAddress());
        this.type = type;
        this.address = address;
    }

    public Proxy(java.net.Proxy src) {
        super(src == null ? Proxy.Type.DIRECT : src.type(), src == null ? null : src.address());
        if (src != null) {
            Proxy.Type t;
            SocketAddress oaddr = src.address();
            if (oaddr instanceof InetSocketAddress) {
                this.address = new InetAddress((InetSocketAddress)oaddr);
            }
            if ((t = src.type()) == Proxy.Type.DIRECT) {
                this.type = Type.direct;
            }
            if (t == Proxy.Type.HTTP) {
                this.type = Type.http;
            }
            if (t == Proxy.Type.SOCKS) {
                this.type = Type.socks;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getType() {
        Proxy proxy = this;
        synchronized (proxy) {
            if (this.type == null) {
                this.type = Type.direct;
            }
            return this.type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(Type type) {
        Proxy proxy = this;
        synchronized (proxy) {
            this.type = type;
        }
    }

    @Override
    public Proxy.Type type() {
        return this.getType().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getAddress() {
        Proxy proxy = this;
        synchronized (proxy) {
            return this.address;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAddress(InetAddress address) {
        Proxy proxy = this;
        synchronized (proxy) {
            this.address = address;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress address() {
        Proxy proxy = this;
        synchronized (proxy) {
            if (this.address == null) {
                return null;
            }
            InetAddress inetAddress = this.address;
            synchronized (inetAddress) {
                InetSocketAddress sa = this.address.getInetSocketAddress();
                return sa;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Proxy proxy = this;
        synchronized (proxy) {
            return "Proxy{type=" + (Object)((Object)this.type) + ", address=" + this.address + '}';
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    public static enum Type {
        direct,
        http,
        socks;


        public Proxy.Type get() {
            switch (this) {
                case direct: {
                    return Proxy.Type.DIRECT;
                }
                case http: {
                    return Proxy.Type.HTTP;
                }
                case socks: {
                    return Proxy.Type.SOCKS;
                }
            }
            return Proxy.Type.DIRECT;
        }

        public static Type get(Proxy.Type t) {
            if (t == null) {
                return null;
            }
            switch (t) {
                case HTTP: {
                    return http;
                }
                case SOCKS: {
                    return socks;
                }
            }
            return direct;
        }
    }
}

