/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.http.IsFinished;

public class WaitPool {
    protected final Set waitObjects;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(WaitPool.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(WaitPool.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(WaitPool.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(WaitPool.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(WaitPool.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(WaitPool.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(WaitPool.class.getName()).log(Level.SEVERE, null, ex);
    }

    public WaitPool() {
        HashSet s = new HashSet();
        this.waitObjects = Collections.synchronizedSet(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IsFinished response) {
        if (response == null) {
            throw new IllegalArgumentException("response==null");
        }
        Set set = this.waitObjects;
        synchronized (set) {
            this.waitObjects.add(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object o) {
        Set set = this.waitObjects;
        synchronized (set) {
            this.waitObjects.remove(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        Set set = this.waitObjects;
        synchronized (set) {
            return this.waitObjects.contains(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] items() {
        Set set = this.waitObjects;
        synchronized (set) {
            return this.waitObjects.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count() {
        Set set = this.waitObjects;
        synchronized (set) {
            return this.waitObjects.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitAll(boolean removeAll) {
        ArrayList<IsFinished> waits = new ArrayList<IsFinished>();
        Set set = this.waitObjects;
        synchronized (set) {
            for (Object o : this.waitObjects) {
                if (!(o instanceof IsFinished)) continue;
                waits.add((IsFinished)o);
            }
        }
        while (true) {
            ArrayList<IsFinished> removeList = new ArrayList<IsFinished>();
            int wc = 0;
            for (IsFinished finishObj : waits) {
                if (!finishObj.isFinished()) {
                    ++wc;
                    continue;
                }
                removeList.add(finishObj);
            }
            if (!removeList.isEmpty()) {
                waits.removeAll(removeList);
            }
            if (wc < 1) break;
            Thread.yield();
        }
        set = this.waitObjects;
        synchronized (set) {
            if (removeAll) {
                this.waitObjects.clear();
            }
        }
    }
}

