/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http;

import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import xyz.cofe.http.UrlPattern;
import xyz.cofe.text.Text;

public class WildcardUrlPattern
implements UrlPattern {
    private static final Logger logger = Logger.getLogger(WildcardUrlPattern.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private String pattern = "";
    private Pattern regex;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public WildcardUrlPattern() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WildcardUrlPattern(WildcardUrlPattern src) {
        if (src != null) {
            WildcardUrlPattern wildcardUrlPattern = src;
            synchronized (wildcardUrlPattern) {
                this.pattern = src.getPattern();
            }
        }
    }

    public WildcardUrlPattern(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern==null");
        }
        this.pattern = pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPattern() {
        WildcardUrlPattern wildcardUrlPattern = this;
        synchronized (wildcardUrlPattern) {
            if (this.pattern == null) {
                this.pattern = "";
            }
            return this.pattern;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPattern(String pattern) {
        WildcardUrlPattern wildcardUrlPattern = this;
        synchronized (wildcardUrlPattern) {
            this.pattern = pattern;
            this.regex = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pattern getRegex() {
        WildcardUrlPattern wildcardUrlPattern = this;
        synchronized (wildcardUrlPattern) {
            if (this.regex != null) {
                return this.regex;
            }
            String wc = this.getPattern();
            this.regex = Text.wildcard((String)wc, (boolean)false, (boolean)true);
            return this.regex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean matched(URI uri) {
        WildcardUrlPattern wildcardUrlPattern = this;
        synchronized (wildcardUrlPattern) {
            if (uri == null) {
                return false;
            }
            String str = uri.toString();
            return this.getRegex().matcher(str).matches();
        }
    }

    @Override
    public WildcardUrlPattern clone() {
        return new WildcardUrlPattern(this);
    }

    public String toString() {
        return "WildcardUrlPattern{pattern=" + this.pattern + '}';
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

