/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http.download;

import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.http.ContentFragment;
import xyz.cofe.http.HttpDownloader;
import xyz.cofe.http.HttpHeaders;
import xyz.cofe.http.HttpRequest;
import xyz.cofe.http.HttpResponse;
import xyz.cofe.http.download.BindHttpDownloader;
import xyz.cofe.http.download.Counter;
import xyz.cofe.http.download.FragmentValidator;
import xyz.cofe.http.download.GetCounters;
import xyz.cofe.http.download.GetPart;
import xyz.cofe.http.download.GetPartMirror;
import xyz.cofe.http.download.LongCounter;
import xyz.cofe.http.download.Mirrors;
import xyz.cofe.http.download.OverflowAction;
import xyz.cofe.http.download.OverflowCounter;
import xyz.cofe.http.download.ResetCounters;

public class BasicFragmentValidator
implements FragmentValidator,
ResetCounters,
GetCounters,
BindHttpDownloader {
    private static final Logger logger = Logger.getLogger(BasicFragmentValidator.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final Lock lock;
    protected static final String COUNTER_PREFIX = "fv.";
    private WeakHashMap<HttpDownloader, Boolean> bindedDownloaders = new WeakHashMap();
    private Map<String, Counter> counters;
    protected OverflowCounter errors;
    protected OverflowCounter statusCodeInvalid;
    protected OverflowCounter nullHttpHeaders;
    protected OverflowCounter notPartialContent;
    protected OverflowCounter invalidRangeContentStart;
    protected OverflowCounter downloadedNotMatchRequired;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public BasicFragmentValidator() {
        this.lock = new ReentrantLock();
    }

    public BasicFragmentValidator(Lock lock) {
        this.lock = lock == null ? new ReentrantLock() : lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicFragmentValidator(BasicFragmentValidator src, Lock lock) {
        Lock lock2 = this.lock = lock == null ? new ReentrantLock() : lock;
        if (src != null) {
            Lock lck = src.lock;
            try {
                if (lck != null) {
                    lck.lock();
                }
                this.errors = src.getErrors().clone(this.lock);
                this.downloadedNotMatchRequired = src.getDownloadedNotMatchRequired().clone(this.lock);
                this.invalidRangeContentStart = src.getInvalidRangeContentStart().clone(this.lock);
                this.notPartialContent = src.getNotPartialContent().clone(this.lock);
                this.nullHttpHeaders = src.getNullHttpHeaders().clone(this.lock);
                this.statusCodeInvalid = src.getStatusCodeInvalid().clone(this.lock);
            }
            finally {
                if (lck != null) {
                    lck.unlock();
                }
            }
        }
    }

    @Override
    public BasicFragmentValidator clone() {
        try {
            this.lock.lock();
            BasicFragmentValidator basicFragmentValidator = new BasicFragmentValidator(this, null);
            return basicFragmentValidator;
        }
        finally {
            this.lock.unlock();
        }
    }

    public BasicFragmentValidator clone(Lock lock) {
        try {
            lock.lock();
            BasicFragmentValidator basicFragmentValidator = new BasicFragmentValidator(this, lock);
            return basicFragmentValidator;
        }
        finally {
            lock.unlock();
        }
    }

    protected boolean isFinished(GetPart gp) {
        if (gp == null) {
            return false;
        }
        if (!gp.isFinished()) {
            return false;
        }
        HttpResponse res = gp.getResponse();
        if (res == null) {
            throw new IllegalStateException("HttpResponse not exists for GetPart id=" + gp.id + " from=" + gp.getFragment().getBegin() + " size=" + gp.getFragment().getSize());
        }
        return res.isFinished();
    }

    @Override
    public Closeable bindHttpDownloader(final HttpDownloader downloader) {
        if (downloader != null) {
            Map<String, Counter> cntrs = this.getCounters();
            final LinkedHashSet<String> cntNames = new LinkedHashSet<String>();
            for (Map.Entry<String, Counter> me : cntrs.entrySet()) {
                String cname = me.getKey();
                Counter cnt = me.getValue();
                if (cname == null || cnt == null) continue;
                cname = COUNTER_PREFIX + cname;
                cntNames.add(cname);
                downloader.getCounters().put(cname, cnt);
            }
            this.bindedDownloaders.put(downloader, true);
            return new Closeable(){

                @Override
                public void close() throws IOException {
                    Map<String, Counter> cnts = downloader.getCounters();
                    for (String n : cntNames) {
                        cnts.remove(n);
                    }
                    BasicFragmentValidator.this.bindedDownloaders.remove(downloader);
                }
            };
        }
        return null;
    }

    @Override
    public Map<String, Counter> getCounters() {
        try {
            this.lock.lock();
            if (this.counters != null) {
                Map<String, Counter> map = this.counters;
                return map;
            }
            this.counters = new LinkedHashMap<String, Counter>();
            this.counters.put("errors", this.getErrors());
            this.counters.put("statusCodeInvalid", this.getStatusCodeInvalid());
            this.counters.put("nullHttpHeaders", this.getNullHttpHeaders());
            this.counters.put("notPartialContent", this.getNotPartialContent());
            this.counters.put("invalidRangeContentStart", this.getInvalidRangeContentStart());
            this.counters.put("downloadedNotMatchRequired", this.getDownloadedNotMatchRequired());
            Map<String, Counter> map = this.counters;
            return map;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void resetCounters() {
        try {
            this.lock.lock();
            this.getErrors().reset();
            this.getStatusCodeInvalid().reset();
            this.getNullHttpHeaders().reset();
            this.getNotPartialContent().reset();
            this.getInvalidRangeContentStart().reset();
            this.getDownloadedNotMatchRequired().reset();
        }
        finally {
            this.lock.unlock();
        }
    }

    public OverflowCounter getErrors() {
        try {
            this.lock.lock();
            if (this.errors == null) {
                this.errors = new OverflowCounter(0, -1, this.lock);
            }
            OverflowCounter overflowCounter = this.errors;
            return overflowCounter;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setErrors(OverflowCounter cnt) {
        try {
            this.lock.lock();
            this.getErrors().assign(cnt);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean hasErrors(GetPart gp, ContentFragment cf) {
        HttpResponse res = gp.getResponse();
        if (res == null) {
            throw new IllegalStateException("HttpResponse not exists for GetPart id=" + gp.id + " from=" + gp.getFragment().getBegin() + " size=" + gp.getFragment().getSize());
        }
        HttpRequest req = res.getRequest();
        URL reqUrl = req != null ? req.getUrl() : null;
        List<Throwable> resErrs = res.getErrors();
        if (resErrs.size() > 0) {
            int errcnt = 0;
            if (isLogFine) {
                for (Throwable err : resErrs) {
                    if (err == null) continue;
                    BasicFragmentValidator.logFine("{0}. HttpResponse error{class={2} message={1}} status={{3} {4}} id={5} url={6}", ++errcnt, err.getMessage(), err.getClass().getName(), res.getStatusCode(), res.getStatusMessage(), res.id, reqUrl);
                }
            }
            if (errcnt > 0) {
                if (gp instanceof GetPartMirror) {
                    this.markFailMirror((GetPartMirror)gp);
                }
                OverflowCounter cnt = this.getErrors().increment();
                int max = cnt.getMax();
                int cur = (Integer)cnt.get();
                OverflowAction act = cnt.getOverflowAction();
                if (cnt.overflow()) {
                    switch (act) {
                        case Skip: {
                            break;
                        }
                        default: {
                            throw new Error("Overflow HttpResponse errors count (current=" + cur + " max=" + max + ")");
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    public OverflowCounter getStatusCodeInvalid() {
        try {
            this.lock.lock();
            if (this.statusCodeInvalid == null) {
                this.statusCodeInvalid = new OverflowCounter(0, -1, this.lock);
            }
            OverflowCounter overflowCounter = this.statusCodeInvalid;
            return overflowCounter;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void seStatusCodeInvalid(OverflowCounter cnt) {
        try {
            this.lock.lock();
            this.getStatusCodeInvalid().assign(cnt);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean statusCodeInvalid(GetPart gp, ContentFragment cf) {
        HttpResponse res = gp.getResponse();
        if (res == null) {
            throw new IllegalStateException("HttpResponse not exists for GetPart id=" + gp.id + " from=" + gp.getFragment().getBegin() + " size=" + gp.getFragment().getSize());
        }
        int statusCode = res.getStatusCode();
        if (statusCode < 200 || statusCode >= 300) {
            if (gp instanceof GetPartMirror) {
                this.markFailMirror((GetPartMirror)gp);
            }
            OverflowCounter cnt = this.getStatusCodeInvalid().increment();
            OverflowAction act = cnt.getOverflowAction();
            int max = cnt.getMax();
            int cur = (Integer)cnt.get();
            if (max > 0 && cur > max) {
                switch (act) {
                    case Skip: {
                        break;
                    }
                    default: {
                        throw new Error("Overflow HttpResponse invalid status code count  (current=" + cur + " max=" + max + ")");
                    }
                }
            }
            return true;
        }
        return false;
    }

    public OverflowCounter getNullHttpHeaders() {
        try {
            this.lock.lock();
            if (this.nullHttpHeaders == null) {
                this.nullHttpHeaders = new OverflowCounter(0, -1, this.lock);
            }
            OverflowCounter overflowCounter = this.nullHttpHeaders;
            return overflowCounter;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setNullHttpHeaders(OverflowCounter cnt) {
        try {
            this.lock.lock();
            this.getNullHttpHeaders().assign(cnt);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean nullHttpHeaders(GetPart gp, ContentFragment cf) {
        HttpResponse res = gp.getResponse();
        if (res == null) {
            throw new IllegalStateException("HttpResponse not exists for GetPart id=" + gp.id + " from=" + gp.getFragment().getBegin() + " size=" + gp.getFragment().getSize());
        }
        HttpHeaders hh = res.getHttpHeaders();
        if (hh == null) {
            if (gp instanceof GetPartMirror) {
                this.markFailMirror((GetPartMirror)gp);
            }
            OverflowCounter cnt = this.getNullHttpHeaders().increment();
            OverflowAction act = cnt.getOverflowAction();
            int max = cnt.getMax();
            int cur = (Integer)cnt.get();
            if (max > 0 && cur > max) {
                switch (act) {
                    case Skip: {
                        break;
                    }
                    default: {
                        throw new Error("Overflow HttpResponse null HttpHeaders count (current=" + cur + " max=" + max + ")");
                    }
                }
            }
            return true;
        }
        return false;
    }

    public OverflowCounter getNotPartialContent() {
        try {
            this.lock.lock();
            if (this.notPartialContent == null) {
                this.notPartialContent = new OverflowCounter(0, -1, this.lock);
            }
            OverflowCounter overflowCounter = this.notPartialContent;
            return overflowCounter;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setNotPartialContent(OverflowCounter cnt) {
        try {
            this.lock.lock();
            this.getNotPartialContent().assign(cnt);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean notPartialContent(GetPart gp, ContentFragment cf) {
        HttpResponse res = gp.getResponse();
        if (res == null) {
            throw new IllegalStateException("HttpResponse not exists for GetPart id=" + gp.id + " from=" + gp.getFragment().getBegin() + " size=" + gp.getFragment().getSize());
        }
        int statusCode = res.getStatusCode();
        HttpHeaders hh = res.getHttpHeaders();
        if (hh == null) {
            throw new IllegalStateException("HttpResponse HttpHeaders not exists for GetPart id=" + gp.id + " from=" + gp.getFragment().getBegin() + " size=" + gp.getFragment().getSize());
        }
        boolean statcode_partialContent = statusCode == 206;
        HttpHeaders.ContentRange contentRange = hh.getContentRange();
        boolean contentRange_exists = contentRange != null & statcode_partialContent;
        if (!contentRange_exists) {
            if (gp instanceof GetPartMirror) {
                this.markFailMirror((GetPartMirror)gp);
            }
            OverflowCounter cnt = this.getNotPartialContent().increment();
            int max = cnt.getMax();
            int cur = (Integer)cnt.get();
            if (max > 0 && cur > max && OverflowAction.Stop.equals((Object)cnt.getOverflowAction())) {
                throw new Error("Overflow HttpResponse notPartialContent count (current=" + cur + " max=" + max + ")");
            }
            return true;
        }
        return false;
    }

    public OverflowCounter getInvalidRangeContentStart() {
        try {
            this.lock.lock();
            if (this.invalidRangeContentStart == null) {
                this.invalidRangeContentStart = new OverflowCounter(0, -1, this.lock);
            }
            OverflowCounter overflowCounter = this.invalidRangeContentStart;
            return overflowCounter;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setInvalidRangeContentStart(OverflowCounter cnt) {
        try {
            this.lock.lock();
            this.getInvalidRangeContentStart().assign(cnt);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean invalidRangeContentStart(GetPart gp, ContentFragment cf) {
        HttpResponse res = gp.getResponse();
        if (res == null) {
            throw new IllegalStateException("HttpResponse not exists for GetPart id=" + gp.id + " from=" + gp.getFragment().getBegin() + " size=" + gp.getFragment().getSize());
        }
        HttpHeaders hh = res.getHttpHeaders();
        if (hh == null) {
            throw new IllegalStateException("HttpResponse HttpHeaders not exists for GetPart id=" + gp.id + " from=" + gp.getFragment().getBegin() + " size=" + gp.getFragment().getSize());
        }
        HttpHeaders.ContentRange contentRange = hh.getContentRange();
        if (contentRange == null) {
            throw new IllegalStateException("HttpResponse Content-range not exists for GetPart id=" + gp.id + " from=" + gp.getFragment().getBegin() + " size=" + gp.getFragment().getSize());
        }
        if (contentRange.from != gp.getFragment().getBegin()) {
            if (gp instanceof GetPartMirror) {
                this.markFailMirror((GetPartMirror)gp);
            }
            OverflowCounter cnt = this.getInvalidRangeContentStart().increment();
            int max = cnt.getMax();
            int cur = (Integer)cnt.get();
            if (max > 0 && cur > max && OverflowAction.Stop.equals((Object)cnt.getOverflowAction())) {
                throw new Error("Overflow HttpResponse invalidRangeContentStart count (current=" + cur + " max=" + max + ")");
            }
            return true;
        }
        return false;
    }

    public OverflowCounter getDownloadedNotMatchRequired() {
        try {
            this.lock.lock();
            if (this.downloadedNotMatchRequired == null) {
                this.downloadedNotMatchRequired = new OverflowCounter(0, -1, this.lock);
            }
            OverflowCounter overflowCounter = this.downloadedNotMatchRequired;
            return overflowCounter;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setDownloadedNotMatchRequired(OverflowCounter cnt) {
        try {
            this.lock.lock();
            this.getDownloadedNotMatchRequired().assign(cnt);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean downloadedNotMatchRequired(GetPart gp, ContentFragment cf) {
        long downloaded = gp.getDownloadedSize();
        if (downloaded > Integer.MAX_VALUE) {
            throw new IllegalStateException("fetched more then Integer.max_value");
        }
        long cfsize = cf.getSize();
        if (downloaded != cfsize) {
            if (gp instanceof GetPartMirror) {
                this.markFailMirror((GetPartMirror)gp);
            }
            OverflowCounter cnt = this.getDownloadedNotMatchRequired().increment();
            int max = cnt.getMax();
            int cur = (Integer)cnt.get();
            if (max > 0 && cur > max && OverflowAction.Stop.equals((Object)cnt.getOverflowAction())) {
                throw new Error("Overflow HttpResponse downloadedNotMatchRequired count (current=" + cur + " max=" + max + ")");
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean validate(GetPart gp, ContentFragment cf) {
        if (gp == null) {
            return false;
        }
        if (cf == null) {
            return false;
        }
        if (!this.isFinished(gp)) {
            return false;
        }
        if (this.hasErrors(gp, cf)) {
            return false;
        }
        if (this.statusCodeInvalid(gp, cf)) {
            return false;
        }
        if (this.nullHttpHeaders(gp, cf)) {
            return false;
        }
        if (this.notPartialContent(gp, cf)) {
            return false;
        }
        if (this.invalidRangeContentStart(gp, cf)) {
            return false;
        }
        if (this.downloadedNotMatchRequired(gp, cf)) {
            return false;
        }
        if (gp instanceof GetPartMirror) {
            this.markSuccessMirror((GetPartMirror)gp);
        }
        return true;
    }

    protected void markFailMirror(GetPartMirror gpm) {
        Mirrors.NRequest nreq = gpm.getNRequest();
        if (nreq == null) {
            return;
        }
        long mirrorID = nreq.getMirrorId();
        String cntName = "fv.mirror(id=" + mirrorID + ").fail";
        for (HttpDownloader downl : this.bindedDownloaders.keySet().toArray(new HttpDownloader[0])) {
            Counter ocnt = downl.getCounters().get(cntName);
            LongCounter cnt = null;
            if (!(ocnt instanceof LongCounter)) {
                cnt = new LongCounter(this.lock);
                downl.getCounters().put(cntName, cnt);
            } else {
                cnt = (LongCounter)ocnt;
            }
            cnt.increment();
        }
    }

    protected void markSuccessMirror(GetPartMirror gpm) {
        Mirrors.NRequest nreq = gpm.getNRequest();
        if (nreq == null) {
            return;
        }
        long mirrorID = nreq.getMirrorId();
        String cntName = "fv.mirror(id=" + mirrorID + ").fetch";
        for (HttpDownloader downl : this.bindedDownloaders.keySet().toArray(new HttpDownloader[0])) {
            Counter ocnt = downl.getCounters().get(cntName);
            LongCounter cnt = null;
            if (!(ocnt instanceof LongCounter)) {
                cnt = new LongCounter(this.lock);
                downl.getCounters().put(cntName, cnt);
            } else {
                cnt = (LongCounter)ocnt;
            }
            cnt.increment();
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

