/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http.download;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Counter<T extends Number> {
    private static final Logger logger = Logger.getLogger(Counter.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final Lock lock;
    protected T value;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public Counter() {
        this.lock = new ReentrantLock();
    }

    public Counter(T cnt) {
        this.lock = new ReentrantLock();
        this.value = cnt;
    }

    public Counter(Lock lock) {
        this.lock = lock == null ? new ReentrantLock() : lock;
    }

    public Counter(T cnt, Lock lock) {
        this.lock = lock == null ? new ReentrantLock() : lock;
        this.value = cnt;
    }

    public Counter(Counter<T> src) {
        this.lock = new ReentrantLock();
        if (src != null) {
            this.value = src.value;
        }
    }

    public Counter(Counter<T> src, Lock lock) {
        Lock lock2 = this.lock = lock == null ? new ReentrantLock() : lock;
        if (src != null) {
            try {
                src.lock.lock();
                this.value = src.value;
            }
            finally {
                src.lock.unlock();
            }
        }
    }

    public abstract Counter<T> clone();

    public abstract Counter<T> clone(Lock var1);

    public abstract Class<T> getType();

    public T get() {
        try {
            this.lock.lock();
            T t = this.value;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public T set(T v) {
        try {
            this.lock.lock();
            T t = this.value = v;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void assign(Counter<T> cnt) {
        try {
            this.lock.lock();
            if (cnt != null) {
                T v = cnt.get();
                this.set(v);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

