/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http.download;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.http.ContentFragment;
import xyz.cofe.http.ContentFragments;
import xyz.cofe.http.HttpDownloader;
import xyz.cofe.http.HttpResponse;
import xyz.cofe.http.download.InitFragments;

public class EqualsFragments
implements InitFragments {
    private static final Logger logger = Logger.getLogger(EqualsFragments.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final ReentrantLock lock = new ReentrantLock();
    protected int fragmentSize = 65536;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public int getFragmentSize() {
        try {
            this.lock.lock();
            int n = this.fragmentSize;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setFragmentSize(int defFragmentSize) {
        if (defFragmentSize < 1) {
            throw new IllegalArgumentException("defFragmentSize<1");
        }
        try {
            this.lock.lock();
            this.fragmentSize = defFragmentSize;
        }
        finally {
            this.lock.unlock();
        }
    }

    public EqualsFragments() {
    }

    public EqualsFragments(int fragmentSize) {
        if (fragmentSize < 1) {
            throw new IllegalArgumentException("fragmentSize<1");
        }
        this.fragmentSize = fragmentSize;
    }

    public EqualsFragments(HttpDownloader downloader) {
        if (downloader == null) {
            throw new IllegalArgumentException("downloader==null");
        }
        this.fragmentSize = downloader.getDefaultFragmentSize();
    }

    protected ContentFragment createFragment(ContentFragments cfragments, long begin, long end) {
        Lock lock = cfragments.getLock();
        if (lock != null) {
            return new ContentFragment(begin, end, lock);
        }
        return new ContentFragment(begin, end);
    }

    @Override
    public void initFragments(ContentFragments cfragments, HttpResponse firstRes, long contentLength) {
        long diff;
        if (firstRes == null) {
            throw new IllegalArgumentException("firstRes==null");
        }
        cfragments.clear();
        if (contentLength <= 0L) {
            return;
        }
        int partSize = this.getFragmentSize();
        EqualsFragments.logFine("build fragments, def fragment size = {0}", partSize);
        long initPosF = 0L;
        while ((diff = contentLength - initPosF) > 0L) {
            long end = -1L;
            end = diff >= (long)partSize ? initPosF + (long)partSize : initPosF + (long)((int)diff);
            ContentFragment cf = this.createFragment(cfragments, initPosF, end);
            cf.setDownloadedSize(0L);
            cfragments.add(cf);
            initPosF = end;
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

