/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http.download;

import java.io.Closeable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func1;
import xyz.cofe.http.ContentFragment;
import xyz.cofe.http.HttpHeaders;
import xyz.cofe.http.HttpListener;
import xyz.cofe.http.HttpRequest;
import xyz.cofe.http.HttpResponse;
import xyz.cofe.http.HttpStatusHelper;

public class GetPart {
    private static final Logger logger = Logger.getLogger(GetPart.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected static HttpStatusHelper httpStatusHelper;
    public static final AtomicLong idseq;
    public final long id = idseq.incrementAndGet();
    private final ContentFragment fragemnt;
    protected final HttpRequest request;
    protected final HttpResponse response;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public GetPart(ContentFragment fragment, HttpRequest request, HttpResponse response) {
        if (request == null) {
            throw new IllegalArgumentException("request==null");
        }
        if (response == null) {
            throw new IllegalArgumentException("response==null");
        }
        if (fragment == null) {
            throw new IllegalArgumentException("fragment==null");
        }
        if (fragment.getBegin() < 0L) {
            throw new IllegalArgumentException("fragment.begin(" + fragment.getBegin() + ")<0");
        }
        if (fragment.getSize() < 1L) {
            throw new IllegalArgumentException("fragment.size(" + fragment.getSize() + ")<1");
        }
        if (fragment.getSize() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("fragment.size(" + fragment.getSize() + ")>Integer.MAX");
        }
        this.fragemnt = fragment;
        this.request = request;
        this.response = response;
    }

    public ContentFragment getFragment() {
        return this.fragemnt;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public long getDownloadedSize() {
        return this.response.getDownloadedSize();
    }

    public boolean isFinished() {
        if (this.response == null) {
            throw new IllegalStateException("response==null");
        }
        return this.response.isFinished();
    }

    public GetPart addResponseListener(HttpListener listener, boolean weak, Func1<Object, Closeable> closeableReciver) {
        if (listener != null) {
            Closeable c = this.response.addListener(listener, weak);
            if (closeableReciver != null) {
                closeableReciver.apply((Object)c);
            }
        }
        return this;
    }

    public Closeable addResponseListener(HttpListener listener, boolean weak) {
        Closeable c = this.response.addListener(listener, weak);
        return c;
    }

    public GetPart start() {
        this.response.start();
        return this;
    }

    public void stop() {
        GetPart.logFiner("stop {0}-{1}", this.fragemnt.getBegin(), this.fragemnt.getEnd());
        this.response.stop();
    }

    public void pause() {
        GetPart.logFiner("pause {0}-{1}", this.fragemnt.getBegin(), this.fragemnt.getEnd());
        this.response.pause();
    }

    public void resume() {
        GetPart.logFiner("resume {0}-{1}", this.fragemnt.getBegin(), this.fragemnt.getEnd());
        this.response.resume();
    }

    public boolean isPaused() {
        return HttpResponse.State.Pause.equals((Object)this.response.getState());
    }

    public boolean isServerResponse() {
        return !HttpResponse.State.Prepare.equals((Object)this.response.getState());
    }

    public boolean isSuccessResponse() {
        if (!this.isServerResponse()) {
            throw new IllegalStateException("server not response");
        }
        int sc = this.response.getStatusCode();
        return httpStatusHelper.isSuccess(sc);
    }

    public boolean isPartialContent() {
        if (!this.isServerResponse()) {
            throw new IllegalStateException("server not response");
        }
        int sc = this.response.getStatusCode();
        boolean statcode = sc == 206;
        boolean cr = this.getContentRange() != null;
        return cr & statcode;
    }

    public HttpHeaders.ContentRange getContentRange() {
        if (!this.isServerResponse()) {
            throw new IllegalStateException("server not response");
        }
        return this.response.getHttpHeaders().getContentRange();
    }

    public boolean isRangeFragmentValid() {
        if (!this.isFinished()) {
            throw new IllegalStateException("response not finished");
        }
        if (!this.isPartialContent()) {
            return false;
        }
        long lDownloaded = this.getDownloadedSize();
        if (lDownloaded > Integer.MAX_VALUE) {
            throw new IllegalStateException("fetched more then Integer.max_value");
        }
        int downloaded = (int)lDownloaded;
        if ((long)downloaded != this.fragemnt.getSize()) {
            return false;
        }
        HttpHeaders.ContentRange contentRange = this.getContentRange();
        if (contentRange == null) {
            return false;
        }
        return contentRange.from == this.fragemnt.getBegin();
    }

    public void waitForFinished() {
        while (!this.isFinished()) {
            Thread.yield();
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
        httpStatusHelper = new HttpStatusHelper();
        idseq = new AtomicLong(0L);
    }
}

