/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http.download;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cbuffer.ContentBuffer;
import xyz.cofe.http.ContentFragment;
import xyz.cofe.http.HttpDownloader;
import xyz.cofe.http.HttpListenerAdapter;
import xyz.cofe.http.HttpRequest;
import xyz.cofe.http.HttpResponse;
import xyz.cofe.http.download.GetPart;
import xyz.cofe.http.download.GetPartMirror;
import xyz.cofe.http.download.Mirrors;

public class GetPartBuilder {
    private static final Logger logger = Logger.getLogger(GetPartBuilder.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected HttpDownloader downloader = null;
    protected Mirrors mirrors = null;
    protected HttpRequest request = null;
    protected ContentBuffer buffer = null;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public GetPartBuilder(HttpDownloader downloader, Mirrors mirrors, HttpRequest request, ContentBuffer contentBuffer) {
        if (request == null) {
            throw new IllegalArgumentException("request==null");
        }
        if (contentBuffer == null) {
            throw new IllegalArgumentException("contentBuffer==null");
        }
        this.mirrors = mirrors;
        this.request = request;
        this.buffer = contentBuffer;
        this.downloader = downloader;
    }

    public GetPart getPart(ContentFragment fragment) {
        GetPart gp;
        Mirrors.NRequest nreq;
        if (fragment == null) {
            throw new IllegalArgumentException("fragment==null");
        }
        HttpRequest req = null;
        boolean createGetPartMirror = false;
        if (this.mirrors != null) {
            nreq = this.mirrors.getNRequest();
            req = nreq.getRequest();
            if (req == null) {
                req = this.request.clone();
            } else {
                createGetPartMirror = true;
            }
        } else {
            req = this.request.clone();
            nreq = null;
        }
        req.setAsync(true);
        req.setContentBuffer(this.buffer);
        req.setContentOffsetStart(fragment.getBegin());
        req.getHttpHeaders().setRange(fragment.getBegin(), fragment.getBegin() + fragment.getSize() - 1L);
        HttpResponse response = req.createResponse();
        response.setFollowRedirect(this.downloader != null ? this.downloader.isFollowRedirect() : true);
        response.setThreadName((this.downloader != null ? "Downloader(" + this.downloader.id + ") " : "") + "GetPart " + Long.toString(fragment.getBegin()) + "-" + Long.toString(fragment.getEnd()) + "/" + Long.toString(fragment.getSize()));
        final Mirrors mmrs = this.mirrors;
        HttpListenerAdapter redirectListener = new HttpListenerAdapter(){

            @Override
            protected void responseRedirect(HttpResponse.RedirectEvent event, HttpResponse response, URL from, URL to) {
                HttpDownloader downl = GetPartBuilder.this.downloader;
                if (downl != null) {
                    HttpDownloader.RedirectEvent re = new HttpDownloader.RedirectEvent(GetPartBuilder.this.downloader, from, to);
                    downl.fireEvent(re);
                    if (mmrs != null && nreq != null) {
                        mmrs.redirect(nreq.getMirrorId(), from, to);
                    }
                }
            }
        };
        response.addListener(redirectListener);
        GetPart getPart = gp = createGetPartMirror ? new GetPartMirror(fragment, req, response) : new GetPart(fragment, req, response);
        if (gp instanceof GetPartMirror) {
            GetPart gpm = gp;
            ((GetPartMirror)gpm).setMirrors(this.mirrors);
            ((GetPartMirror)gpm).setNRequest(nreq);
        }
        return gp;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

