/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http.download;

import java.io.Closeable;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cbuffer.ContentBuffer;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.Iterators;
import xyz.cofe.common.Fragment;
import xyz.cofe.common.Hash;
import xyz.cofe.common.ListenersHelper;
import xyz.cofe.http.ContentFragment;
import xyz.cofe.http.ContentFragments;
import xyz.cofe.http.download.ContentValidation;
import xyz.cofe.http.download.ContentValidator;
import xyz.cofe.http.download.ContentValidatorEvent;
import xyz.cofe.http.download.ContentValidatorListener;
import xyz.cofe.http.download.ContentValidatorProgressEvent;
import xyz.cofe.http.download.ContentValidatorSender;

public class HashContentValidator
implements ContentValidator,
ContentValidatorSender {
    private static final Logger logger = Logger.getLogger(HashContentValidator.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private final ListenersHelper<ContentValidatorListener, ContentValidatorEvent> listeners = new ListenersHelper((Func2)new Func2<Object, ContentValidatorListener, ContentValidatorEvent>(){

        public Object apply(ContentValidatorListener listener, ContentValidatorEvent ev) {
            if (listener != null) {
                listener.contentValidatorEvent(ev);
            }
            return null;
        }
    });
    protected volatile ContentFragments validFragments;
    protected volatile boolean outside = true;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    @Override
    public boolean hasListener(ContentValidatorListener listener) {
        return this.listeners.hasListener((Object)listener);
    }

    @Override
    public Set<ContentValidatorListener> getListeners() {
        return this.listeners.getListeners();
    }

    @Override
    public Closeable addListener(ContentValidatorListener listener) {
        return this.listeners.addListener((Object)listener);
    }

    @Override
    public Closeable addListener(ContentValidatorListener listener, boolean weakLink) {
        return this.listeners.addListener((Object)listener, weakLink);
    }

    @Override
    public void removeListener(ContentValidatorListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    @Override
    public void fireEvent(ContentValidatorEvent event) {
        this.listeners.fireEvent((Object)event);
    }

    public HashContentValidator() {
    }

    public HashContentValidator(HashContentValidator src) {
        if (src != null) {
            ContentFragments scf = src.validFragments;
            if (scf != null) {
                this.validFragments = scf.clone();
            }
            this.outside = src.outside;
        }
    }

    @Override
    public HashContentValidator clone() {
        return new HashContentValidator(this);
    }

    public ContentFragments getValidFragments() {
        return this.validFragments;
    }

    public void setValidFragments(ContentFragments validFragments) {
        this.validFragments = validFragments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOutside() {
        HashContentValidator hashContentValidator = this;
        synchronized (hashContentValidator) {
            return this.outside;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutside(boolean outside) {
        HashContentValidator hashContentValidator = this;
        synchronized (hashContentValidator) {
            this.outside = outside;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentValidation validate(ContentBuffer cbuff, ContentFragments fragments) {
        boolean incOutside;
        LinkedHashSet<ContentFragment> succMd5;
        LinkedHashSet<ContentFragment> failedAdds;
        LinkedHashSet<ContentFragment> failed;
        block11: {
            if (cbuff == null) {
                throw new IllegalArgumentException("cbuff==null");
            }
            if (fragments == null) {
                throw new IllegalArgumentException("fragments==null");
            }
            ContentFragments valids = this.validFragments;
            if (valids == null) {
                throw new IllegalStateException("property 'validFragments' not set");
            }
            failed = new LinkedHashSet<ContentFragment>();
            failedAdds = new LinkedHashSet<ContentFragment>();
            succMd5 = new LinkedHashSet<ContentFragment>();
            incOutside = this.outside;
            Lock lock1 = fragments.getLock();
            Lock lock2 = valids.getLock();
            if (lock1 != null && lock2 != null) {
                try {
                    lock1.lock();
                    try {
                        lock2.lock();
                        this.validate(cbuff, fragments, valids, failed, failedAdds, succMd5);
                        break block11;
                    }
                    finally {
                        lock2.unlock();
                    }
                }
                finally {
                    lock1.unlock();
                }
            }
            this.validate(cbuff, fragments, valids, failed, failedAdds, succMd5);
        }
        if (incOutside) {
            failed.addAll(failedAdds);
        }
        ContentValidation cv = new ContentValidation(){

            @Override
            public Iterable<ContentFragment> getGood() {
                return succMd5;
            }

            @Override
            public Iterable<ContentFragment> getBad() {
                return failed;
            }
        };
        return cv;
    }

    protected void validate(ContentBuffer cbuff, ContentFragments fragments, ContentFragments valids, LinkedHashSet<ContentFragment> failed, LinkedHashSet<ContentFragment> failedAdds, LinkedHashSet<ContentFragment> successSrcMD5Res) {
        Hash hash = new Hash();
        long cbuffSize = cbuff.getSize();
        int blockSize = 8192;
        LinkedHashSet<ContentFragment> rightOutsideOfBuffer = new LinkedHashSet<ContentFragment>();
        LinkedHashSet<ContentFragment> leftOutsideOfBuffer = new LinkedHashSet<ContentFragment>();
        LinkedHashSet<ContentFragment> md5Null = new LinkedHashSet<ContentFragment>();
        LinkedHashSet<ContentFragment> md5LengthInvalid = new LinkedHashSet<ContentFragment>();
        LinkedHashSet<ContentFragment> beginMoreThenEnd = new LinkedHashSet<ContentFragment>();
        LinkedHashSet<ContentFragment> zeroLen = new LinkedHashSet<ContentFragment>();
        LinkedHashSet<ContentFragment> failEvalMD5 = new LinkedHashSet<ContentFragment>();
        LinkedHashSet<ContentFragment> successMD5 = new LinkedHashSet<ContentFragment>();
        LinkedHashSet<ContentFragment> successSrcMD5 = new LinkedHashSet<ContentFragment>();
        LinkedHashSet<ContentFragment> failMD5 = new LinkedHashSet<ContentFragment>();
        int sampleNum = 0;
        int sampleTot = valids.size();
        for (Fragment ovalid : valids) {
            ++sampleNum;
            if (!(ovalid instanceof ContentFragment)) continue;
            ContentFragment samplecf = (ContentFragment)ovalid;
            String sampleMd5 = samplecf.getMd5();
            long l = samplecf.getEnd();
            long sampleBegin = samplecf.getBegin();
            if (sampleBegin > l) {
                beginMoreThenEnd.add(samplecf);
                this.fireEvent(new ContentValidatorProgressEvent(this, cbuff, valids, samplecf, sampleNum, sampleTot, false));
                continue;
            }
            long sampleSize = l - sampleBegin;
            if (sampleSize < 1L) {
                zeroLen.add(samplecf);
                this.fireEvent(new ContentValidatorProgressEvent(this, cbuff, valids, samplecf, sampleNum, sampleTot, false));
                continue;
            }
            if (sampleBegin < 0L) {
                leftOutsideOfBuffer.add(samplecf);
                this.fireEvent(new ContentValidatorProgressEvent(this, cbuff, valids, samplecf, sampleNum, sampleTot, false));
                continue;
            }
            if (cbuffSize < l) {
                rightOutsideOfBuffer.add(samplecf);
                this.fireEvent(new ContentValidatorProgressEvent(this, cbuff, valids, samplecf, sampleNum, sampleTot, false));
                continue;
            }
            if (sampleMd5 == null) {
                md5Null.add(samplecf);
                this.fireEvent(new ContentValidatorProgressEvent(this, cbuff, valids, samplecf, sampleNum, sampleTot, false));
                continue;
            }
            if (sampleMd5.length() != 32) {
                md5LengthInvalid.add(samplecf);
                this.fireEvent(new ContentValidatorProgressEvent(this, cbuff, valids, samplecf, sampleNum, sampleTot, false));
                continue;
            }
            byte[] md5data = hash.md5(cbuff, samplecf, blockSize);
            if (md5data == null) {
                failEvalMD5.add(samplecf);
                this.fireEvent(new ContentValidatorProgressEvent(this, cbuff, valids, samplecf, sampleNum, sampleTot, false));
                continue;
            }
            String md5str = hash.toString(md5data);
            if (md5str == null) {
                failEvalMD5.add(samplecf);
                this.fireEvent(new ContentValidatorProgressEvent(this, cbuff, valids, samplecf, sampleNum, sampleTot, false));
                continue;
            }
            if (!md5str.equalsIgnoreCase(sampleMd5)) {
                failMD5.add(samplecf);
                this.fireEvent(new ContentValidatorProgressEvent(this, cbuff, valids, samplecf, sampleNum, sampleTot, false));
                continue;
            }
            successMD5.add(samplecf);
            this.fireEvent(new ContentValidatorProgressEvent(this, cbuff, valids, samplecf, sampleNum, sampleTot, true));
        }
        Iterable failedSamples = Iterators.sequence((Iterable[])new Iterable[]{rightOutsideOfBuffer, failMD5});
        for (ContentFragment failedcf : failedSamples) {
            for (Fragment fragment : fragments) {
                if (!(fragment instanceof ContentFragment)) continue;
                ContentFragment cf = (ContentFragment)fragment;
                if (cf.equalsRange(failedcf)) {
                    failed.add(cf);
                    continue;
                }
                if (cf.include(failedcf)) {
                    failed.add(cf);
                    continue;
                }
                if (!cf.hasIntersection(failedcf)) continue;
                failed.add(cf);
            }
        }
        for (Object osrcf : fragments) {
            for (Fragment fragment : successMD5) {
                ContentFragment srccf;
                ContentFragment succf;
                if (!(osrcf instanceof ContentFragment) || !(fragment instanceof ContentFragment) || !(succf = (ContentFragment)fragment).include(srccf = (ContentFragment)osrcf) && !succf.equalsRange(srccf)) continue;
                successSrcMD5.add(srccf);
            }
        }
        for (ContentFragment failedcf : failedSamples) {
            if (failed.contains(failedcf)) continue;
            failedAdds.add(failedcf);
        }
        if (successSrcMD5Res != null) {
            successSrcMD5Res.addAll(successSrcMD5);
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

