/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http.download;

import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.http.download.Counter;
import xyz.cofe.http.download.ResetCounter;
import xyz.cofe.http.download.SetCounter;

public class IntCounter
extends Counter<Integer>
implements ResetCounter,
SetCounter<Integer> {
    private static final Logger logger = Logger.getLogger(IntCounter.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public IntCounter() {
        this.value = 0;
    }

    public IntCounter(int cnt) {
        this.value = cnt;
    }

    public IntCounter(Lock lock) {
        super(lock);
        this.value = 0;
    }

    public IntCounter(int cnt, Lock lock) {
        super(cnt, lock);
    }

    public IntCounter(IntCounter src) {
        super(src);
        if (src == null) {
            this.value = 0;
        }
    }

    public IntCounter(IntCounter src, Lock lock) {
        super(src, lock);
        if (src == null) {
            this.value = 0;
        }
    }

    @Override
    public IntCounter clone() {
        try {
            this.lock.lock();
            IntCounter intCounter = new IntCounter(this);
            return intCounter;
        }
        finally {
            this.lock.unlock();
        }
    }

    public IntCounter clone(Lock lock) {
        try {
            this.lock.lock();
            IntCounter intCounter = new IntCounter(this, lock);
            return intCounter;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Class<Integer> getType() {
        return Integer.class;
    }

    @Override
    public void reset() {
        try {
            this.lock.lock();
            this.value = 0;
        }
        finally {
            this.lock.unlock();
        }
    }

    public IntCounter increment() {
        try {
            this.lock.lock();
            Object object = (Integer)this.value;
            this.value = (Integer)this.value + 1;
            Integer n = this.value;
            object = this.clone();
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

