/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http.download;

import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.http.download.Counter;
import xyz.cofe.http.download.IntCounter;

public class MaxCounter
extends IntCounter {
    private static final Logger logger = Logger.getLogger(MaxCounter.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private int max = -1;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public MaxCounter() {
        this.max = 100;
    }

    public MaxCounter(int cnt, int max) {
        super(cnt);
        this.max = max;
    }

    public MaxCounter(Lock lock) {
        super(lock);
        this.max = 100;
    }

    public MaxCounter(int cnt, int max, Lock lock) {
        super(cnt, lock);
        this.max = max;
    }

    public MaxCounter(MaxCounter src) {
        super(src);
        this.max = src != null ? src.max : 100;
    }

    public MaxCounter(MaxCounter src, Lock lock) {
        super(src, lock);
        if (src != null) {
            try {
                src.lock.lock();
                this.max = src.max;
            }
            finally {
                src.lock.unlock();
            }
        } else {
            this.max = 100;
        }
    }

    @Override
    public MaxCounter clone() {
        try {
            this.lock.lock();
            MaxCounter maxCounter = new MaxCounter(this);
            return maxCounter;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public MaxCounter clone(Lock lock) {
        try {
            this.lock.lock();
            MaxCounter maxCounter = new MaxCounter(this, lock);
            return maxCounter;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getMax() {
        try {
            this.lock.lock();
            int n = this.max;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setMax(int m) {
        try {
            this.lock.lock();
            this.max = m;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public MaxCounter increment() {
        try {
            this.lock.lock();
            if (this.value == null) {
                this.value = 0;
            }
            Object object = (Integer)this.value;
            this.value = (Integer)this.value + 1;
            Integer n = this.value;
            object = this.clone();
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean overflow() {
        try {
            this.lock.lock();
            if (this.max >= 0 && (Integer)this.value > this.max) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void assign(Counter<Integer> cnt) {
        try {
            this.lock.lock();
            if (cnt instanceof MaxCounter) {
                this.setMax(((MaxCounter)cnt).getMax());
            }
            super.assign(cnt);
        }
        finally {
            this.lock.unlock();
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

