/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http.download;

import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.list.LockList;
import xyz.cofe.http.HttpRequest;

public class Mirrors {
    private static final Logger logger = Logger.getLogger(Mirrors.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final Lock lock;
    private final Random rnd;
    private final List<HttpRequest> mirrors;
    protected final Map<HttpRequest, HttpRequest> redirects = new WeakHashMap<HttpRequest, HttpRequest>();

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public Mirrors() {
        this.lock = new ReentrantLock();
        SecureRandom secrnd = new SecureRandom();
        this.rnd = new Random(secrnd.nextLong());
        LockList list = new ArrayList();
        this.mirrors = list = new LockList(list, this.lock);
    }

    public Mirrors(Lock lock) {
        this.lock = lock == null ? new ReentrantLock() : lock;
        SecureRandom secrnd = new SecureRandom();
        this.rnd = new Random(secrnd.nextLong());
        LockList list = new ArrayList();
        this.mirrors = list = new LockList(list, lock);
    }

    public Mirrors(HttpRequest ... requests) {
        this.lock = new ReentrantLock();
        SecureRandom secrnd = new SecureRandom();
        this.rnd = new Random(secrnd.nextLong());
        LockList list = new ArrayList();
        this.mirrors = list = new LockList(list, this.lock);
        if (requests != null) {
            for (HttpRequest req : requests) {
                if (req == null) continue;
                this.mirrors.add(req);
            }
        }
    }

    public Mirrors(Lock lock, HttpRequest ... requests) {
        this.lock = lock == null ? new ReentrantLock() : lock;
        SecureRandom secrnd = new SecureRandom();
        this.rnd = new Random(secrnd.nextLong());
        LockList list = new ArrayList();
        this.mirrors = list = new LockList(list, lock);
        if (requests != null) {
            for (HttpRequest req : requests) {
                if (req == null) continue;
                this.mirrors.add(req);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mirrors(Mirrors src) {
        this.lock = new ReentrantLock();
        SecureRandom secrnd = new SecureRandom();
        this.rnd = new Random(secrnd.nextLong());
        LockList list = new ArrayList();
        this.mirrors = list = new LockList(list, this.lock);
        if (src != null) {
            try {
                src.lock.lock();
                this.mirrors.addAll(src.mirrors);
            }
            finally {
                src.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mirrors(Mirrors src, Lock lock) {
        this.lock = lock == null ? new ReentrantLock() : lock;
        SecureRandom secrnd = new SecureRandom();
        this.rnd = new Random(secrnd.nextLong());
        LockList list = new ArrayList();
        this.mirrors = list = new LockList(list, lock);
        if (src != null) {
            try {
                src.lock.lock();
                this.mirrors.addAll(src.mirrors);
            }
            finally {
                src.lock.unlock();
            }
        }
    }

    public Mirrors clone() {
        return new Mirrors(this);
    }

    public Mirrors clone(Lock lock) {
        return new Mirrors(this, lock);
    }

    public HttpRequest[] getMirrors() {
        return this.mirrors.toArray(new HttpRequest[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getMirrorIds() {
        try {
            this.lock.lock();
            long[] ids = new long[]{};
            for (HttpRequest req : this.mirrors) {
                if (req == null) continue;
                ids = Arrays.copyOf(ids, ids.length + 1);
                ids[ids.length - 1] = req.id;
            }
            Object object = ids;
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpRequest getMirrorById(long id) {
        try {
            this.lock.lock();
            for (HttpRequest req : this.mirrors) {
                if (req == null) continue;
                if (req.id != id) continue;
                HttpRequest httpRequest = req;
                return httpRequest;
            }
            Iterator<HttpRequest> iterator = null;
            return iterator;
        }
        finally {
            this.lock.unlock();
        }
    }

    public NRequest getNRequest() {
        return this.getNRequest(this.rnd.nextInt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NRequest getNRequest(int n) {
        try {
            this.lock.lock();
            int msize = this.mirrors.size();
            if (msize < 0) {
                msize = -msize;
            }
            if (msize == 0) {
                NRequest nRequest = null;
                return nRequest;
            }
            int mod = 0;
            if (msize == 1) {
                mod = 0;
            } else {
                mod = n % msize;
                if (mod < 0) {
                    mod = msize + mod;
                }
                if (mod < 0) {
                    mod = msize - mod;
                }
            }
            HttpRequest req = this.mirrors.get(mod);
            HttpRequest redirect = this.redirects.get(req);
            NRequest nRequest = new NRequest(redirect != null ? redirect : req, req.id);
            return nRequest;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void redirect(long mirrorId, URL from, URL target) {
        if (from == null) {
            throw new IllegalArgumentException("from==null");
        }
        if (target == null) {
            throw new IllegalArgumentException("target==null");
        }
        HttpRequest req = this.getMirrorById(mirrorId);
        if (req != null) {
            HttpRequest rrq = req.clone();
            rrq.setUrl(target);
            rrq.getHttpHeaders().setReferer(from.toString());
            this.redirects.put(req, rrq);
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    public static class NRequest {
        private HttpRequest request;
        private long mirrorId;

        public NRequest(HttpRequest req, long mirrorId) {
            this.request = req;
            this.mirrorId = mirrorId;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public long getMirrorId() {
            return this.mirrorId;
        }
    }
}

