/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http.download;

import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.http.download.Counter;
import xyz.cofe.http.download.MaxCounter;
import xyz.cofe.http.download.OverflowAction;

public class OverflowCounter
extends MaxCounter {
    private static final Logger logger = Logger.getLogger(OverflowCounter.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected OverflowAction overflowAction;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public OverflowCounter() {
    }

    public OverflowCounter(int cnt, int max) {
        super(cnt, max);
    }

    public OverflowCounter(int cnt, int max, OverflowAction overflow) {
        super(cnt, max);
        this.overflowAction = overflow;
    }

    public OverflowCounter(Lock lock) {
        super(lock);
    }

    public OverflowCounter(int cnt, int max, Lock l) {
        super(cnt, max, l);
    }

    public OverflowCounter(int cnt, int max, OverflowAction overflow, Lock l) {
        super(cnt, max, l);
        this.overflowAction = overflow;
    }

    public OverflowCounter(MaxCounter src) {
        super(src);
        this.overflowAction = src instanceof OverflowCounter ? ((OverflowCounter)src).overflowAction : this.overflowAction;
    }

    public OverflowCounter(MaxCounter src, Lock lock) {
        super(src, lock);
        this.overflowAction = src instanceof OverflowCounter ? ((OverflowCounter)src).overflowAction : this.overflowAction;
    }

    @Override
    public OverflowCounter clone(Lock lock) {
        try {
            this.lock.lock();
            OverflowCounter overflowCounter = new OverflowCounter(this, lock);
            return overflowCounter;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public OverflowCounter clone() {
        try {
            this.lock.lock();
            OverflowCounter overflowCounter = new OverflowCounter(this);
            return overflowCounter;
        }
        finally {
            this.lock.unlock();
        }
    }

    public OverflowAction getOverflowAction() {
        try {
            this.lock.lock();
            if (this.overflowAction == null) {
                this.overflowAction = OverflowAction.Stop;
            }
            OverflowAction overflowAction = this.overflowAction;
            return overflowAction;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setOverflowAction(OverflowAction overflowAction) {
        try {
            this.lock.lock();
            this.overflowAction = overflowAction;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OverflowCounter increment() {
        try {
            this.lock.lock();
            MaxCounter cnt = super.increment();
            if (cnt instanceof OverflowCounter) {
                OverflowCounter overflowCounter = (OverflowCounter)cnt;
                return overflowCounter;
            }
            OverflowCounter ocnt = new OverflowCounter(cnt);
            ocnt.overflowAction = this.overflowAction;
            OverflowCounter overflowCounter = ocnt;
            return overflowCounter;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void assign(Counter<Integer> cnt) {
        try {
            this.lock.lock();
            if (cnt instanceof OverflowCounter) {
                this.setOverflowAction(((OverflowCounter)cnt).getOverflowAction());
            }
            super.assign(cnt);
        }
        finally {
            this.lock.unlock();
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

