/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http.download;

import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.set.EventSet;
import xyz.cofe.common.Fragment;
import xyz.cofe.http.ContentFragment;
import xyz.cofe.http.HttpDownloader;
import xyz.cofe.http.HttpListenerAdapter;
import xyz.cofe.http.download.DoubleCounter;
import xyz.cofe.http.download.IntCounter;
import xyz.cofe.http.download.LongCounter;

public class ProgressCounters {
    private static final Logger logger = Logger.getLogger(ProgressCounters.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected double pct = -2.0;
    protected long total = -1L;
    protected long downloaded = -1L;
    protected Date lastStateChangedDate;
    protected HttpDownloader.State lastStateChangedValue;
    protected Date lastProgressDate;
    protected Long lastProgressSize;
    protected double bytesPerSecond;
    protected double kBytesPerSecond;
    protected double mBytesPerSecond;
    protected WeakReference<HttpDownloader> downloader;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    protected ProgressCounters() {
    }

    public ProgressCounters(HttpDownloader downl) {
        if (downl == null) {
            throw new IllegalArgumentException("downl==null");
        }
        this.registerCounters(downl);
    }

    protected void registerCounters(HttpDownloader downl) {
        if (downl == null) {
            throw new IllegalArgumentException("downl==null");
        }
        HttpListenerAdapter lProgress = new HttpListenerAdapter(){

            @Override
            protected void downloaderProgress(HttpDownloader.ProgressEvent event, HttpDownloader downloader) {
                ProgressCounters.this.onProgress(downloader, event);
            }
        };
        HttpListenerAdapter lState = new HttpListenerAdapter(){

            @Override
            protected void downloaderStateChanged(HttpDownloader.StateChangedEvent event, HttpDownloader downloader, HttpDownloader.State oldState, HttpDownloader.State newState) {
                ProgressCounters.this.onStateChanged(downloader, event, oldState, newState);
            }
        };
        Closeable clProgress = downl.addListener(lProgress);
        Closeable clState = downl.addListener(lState);
        this.registerContentLength(downl);
        this.registerTotalLength(downl);
        this.registerDownloaded(downl);
        this.registerDownloadedPct(downl);
        this.registerDownloadedSpeedBytes(downl);
        this.registerDownloadedSpeedKBytes(downl);
        this.registerDownloadedSpeedMBytes(downl);
        this.registerTotalFragments(downl);
        this.registerValidatedFragments(downl);
        this.registerDownloadedFragments(downl);
    }

    protected void onProgress(HttpDownloader downloader, HttpDownloader.ProgressEvent event) {
        this.updateProgress(downloader);
    }

    protected void onStateChanged(HttpDownloader downloader, HttpDownloader.StateChangedEvent event, HttpDownloader.State oldState, HttpDownloader.State newState) {
        this.lastStateChangedDate = new Date();
        this.lastStateChangedValue = newState;
        this.updateProgress(downloader);
    }

    protected long getTotal(HttpDownloader downloader) {
        long total = downloader.getTotalSize();
        return total;
    }

    protected long getDownloaded(HttpDownloader downloader) {
        long downloaded = downloader.getDownloadedSize();
        return downloaded;
    }

    public boolean updateProgress() {
        HttpDownloader d;
        WeakReference<HttpDownloader> wdownloader = this.downloader;
        HttpDownloader httpDownloader = d = wdownloader == null ? null : (HttpDownloader)wdownloader.get();
        if (d == null) {
            return false;
        }
        this.updateProgress(d);
        return true;
    }

    protected void updateProgress(HttpDownloader downloader) {
        this.total = this.getTotal(downloader);
        this.downloaded = this.getDownloaded(downloader);
        this.pct = this.total > 0L ? (double)this.downloaded / (double)this.total : -1.0;
        this.pct *= 1000000.0;
        int ipct = (int)this.pct;
        this.pct = (double)ipct / 10000.0;
        Date now = new Date();
        if (this.lastProgressDate != null && this.lastProgressSize != null) {
            long tDelta = now.getTime() - this.lastProgressDate.getTime();
            long sDelta = this.downloaded - this.lastProgressSize;
            if (tDelta >= 1000L) {
                double speed;
                double k = 1000.0 / (double)tDelta;
                this.bytesPerSecond = speed = k * (double)sDelta;
                this.kBytesPerSecond = k * ((double)sDelta / 1024.0);
                this.mBytesPerSecond = k * ((double)sDelta / 1048576.0);
                this.lastProgressDate = now;
                this.lastProgressSize = this.downloaded;
            }
        } else {
            this.lastProgressDate = now;
            this.lastProgressSize = this.downloaded;
        }
    }

    public void resetCounters() {
        this.bytesPerSecond = -1.0;
        this.kBytesPerSecond = -1.0;
        this.mBytesPerSecond = -1.0;
        this.lastProgressSize = null;
        this.lastStateChangedDate = null;
        this.lastStateChangedDate = null;
        this.lastStateChangedValue = null;
        this.total = -1L;
        this.pct = -2.0;
        this.downloaded = -1L;
    }

    protected LongCounter registerContentLength(final HttpDownloader downl) {
        if (downl == null) {
            throw new IllegalArgumentException("downl==null");
        }
        String cntname = "progress.contentLength";
        LongCounter lcntr = new LongCounter(downl.getLock()){

            @Override
            public Long get() {
                return downl.getContentLength();
            }

            @Override
            public void reset() {
                ProgressCounters.this.resetCounters();
            }
        };
        downl.getCounters().put(cntname, lcntr);
        return lcntr;
    }

    protected LongCounter registerTotalLength(HttpDownloader downl) {
        if (downl == null) {
            throw new IllegalArgumentException("downl==null");
        }
        String cntname = "progress.totalLength";
        LongCounter lcntr = new LongCounter(downl.getLock()){

            @Override
            public Long get() {
                return ProgressCounters.this.total;
            }

            @Override
            public void reset() {
                ProgressCounters.this.resetCounters();
            }
        };
        downl.getCounters().put(cntname, lcntr);
        return lcntr;
    }

    protected LongCounter registerDownloaded(HttpDownloader downl) {
        if (downl == null) {
            throw new IllegalArgumentException("downl==null");
        }
        String cntname = "progress.downloadedBytes";
        LongCounter lcntr = new LongCounter(downl.getLock()){

            @Override
            public Long get() {
                return ProgressCounters.this.downloaded;
            }

            @Override
            public void reset() {
                ProgressCounters.this.resetCounters();
            }
        };
        downl.getCounters().put(cntname, lcntr);
        return lcntr;
    }

    protected DoubleCounter registerDownloadedPct(HttpDownloader downl) {
        if (downl == null) {
            throw new IllegalArgumentException("downl==null");
        }
        String cntname = "progress.downloadedPct";
        DoubleCounter cntr = new DoubleCounter(downl.getLock()){

            @Override
            public Double get() {
                return ProgressCounters.this.pct;
            }

            @Override
            public void reset() {
                ProgressCounters.this.resetCounters();
            }
        };
        downl.getCounters().put(cntname, cntr);
        return cntr;
    }

    protected DoubleCounter registerDownloadedSpeedBytes(HttpDownloader downl) {
        if (downl == null) {
            throw new IllegalArgumentException("downl==null");
        }
        String cntname = "progress.downloadedSpeedBytes";
        DoubleCounter cntr = new DoubleCounter(downl.getLock()){

            @Override
            public Double get() {
                return ProgressCounters.this.bytesPerSecond;
            }

            @Override
            public void reset() {
                ProgressCounters.this.resetCounters();
            }
        };
        downl.getCounters().put(cntname, cntr);
        return cntr;
    }

    protected DoubleCounter registerDownloadedSpeedKBytes(HttpDownloader downl) {
        if (downl == null) {
            throw new IllegalArgumentException("downl==null");
        }
        String cntname = "progress.downloadedSpeedKBytes";
        DoubleCounter cntr = new DoubleCounter(downl.getLock()){

            @Override
            public Double get() {
                return ProgressCounters.this.kBytesPerSecond;
            }

            @Override
            public void reset() {
                ProgressCounters.this.resetCounters();
            }
        };
        downl.getCounters().put(cntname, cntr);
        return cntr;
    }

    protected DoubleCounter registerDownloadedSpeedMBytes(HttpDownloader downl) {
        if (downl == null) {
            throw new IllegalArgumentException("downl==null");
        }
        String cntname = "progress.downloadedSpeedMBytes";
        DoubleCounter cntr = new DoubleCounter(downl.getLock()){

            @Override
            public Double get() {
                return ProgressCounters.this.mBytesPerSecond;
            }

            @Override
            public void reset() {
                ProgressCounters.this.resetCounters();
            }
        };
        downl.getCounters().put(cntname, cntr);
        return cntr;
    }

    protected IntCounter registerTotalFragments(final HttpDownloader downl) {
        if (downl == null) {
            throw new IllegalArgumentException("downl==null");
        }
        String cntname = "progress.totalFragments";
        IntCounter cntr = new IntCounter(downl.getLock()){

            @Override
            public Integer get() {
                return downl == null ? 0 : downl.getFragments().size();
            }
        };
        downl.getCounters().put(cntname, cntr);
        return cntr;
    }

    protected IntCounter registerDownloadedFragments(final HttpDownloader downl) {
        if (downl == null) {
            throw new IllegalArgumentException("downl==null");
        }
        String cntname = "progress.downloadedFragments";
        IntCounter cntr = new IntCounter(downl.getLock()){

            @Override
            public Integer get() {
                if (downl == null) {
                    return 0;
                }
                int c = 0;
                for (Fragment of : downl.getFragments()) {
                    ContentFragment cf;
                    if (!(of instanceof ContentFragment) || (cf = (ContentFragment)of).getDownloadedSize() != cf.getSize()) continue;
                    ++c;
                }
                return c;
            }
        };
        downl.getCounters().put(cntname, cntr);
        return cntr;
    }

    protected IntCounter registerValidatedFragments(final HttpDownloader downl) {
        if (downl == null) {
            throw new IllegalArgumentException("downl==null");
        }
        String cntname = "progress.validatedFragments";
        IntCounter cntr = new IntCounter(downl.getLock()){

            @Override
            public Integer get() {
                if (downl == null) {
                    return 0;
                }
                EventSet<ContentFragment> set = downl.getValidatedFragments();
                return set == null ? 0 : set.size();
            }
        };
        downl.getCounters().put(cntname, cntr);
        return cntr;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

