/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http.web;

import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.fs.UnixPath;

public class FollowLink {
    public final URL from;
    public final URL link;
    public final String href;
    public final String text;
    public final Map<String, String> attributes;
    public final boolean linkStartAsFrom;
    public final boolean sameHost;
    public final boolean samePort;
    public final boolean isChildPath;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(FollowLink.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(FollowLink.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(FollowLink.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(FollowLink.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(FollowLink.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(FollowLink.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(FollowLink.class.getName()).log(Level.SEVERE, null, ex);
    }

    public FollowLink(URL from, URL link, String href) {
        this(from, link, null, null);
    }

    public FollowLink(URL from, URL link, String href, String text) {
        this(from, link, href, text, null);
    }

    public FollowLink(URL from, URL link, String text, String href, Map<String, String> attrs) {
        if (href == null) {
            throw new IllegalArgumentException("href==null");
        }
        if (link == null) {
            throw new IllegalArgumentException("link==null");
        }
        if (from == null) {
            throw new IllegalArgumentException("from==null");
        }
        this.link = link;
        this.from = from;
        this.href = href;
        this.text = text == null ? "" : text;
        this.attributes = attrs == null ? new LinkedHashMap() : attrs;
        this.sameHost = link.getHost().equals(from.getHost());
        this.samePort = link.getPort() == from.getPort();
        this.linkStartAsFrom = link.toString().startsWith(from.toString());
        this.isChildPath = FollowLink.isChildPath(from, link);
    }

    protected static boolean isSiblingPath(URL parent, URL child) {
        String parentPathStr = parent.getPath();
        String childPathStr = child.getPath();
        if (parentPathStr != null && parentPathStr.length() > 0 && childPathStr != null && childPathStr.length() > 0) {
            UnixPath parentPath = new UnixPath(parentPathStr);
            parentPath = parentPath.getCanonical();
            UnixPath childPath = new UnixPath(childPathStr);
            childPath = childPath.getCanonical();
            if (parentPath.isAbsolute() && childPath.isAbsolute() && parentPath.compareTo(childPath) != 0) {
                String c2;
                String c1;
                String[] parentComponents = parentPath.getComponents();
                String[] childComponents = childPath.getComponents();
                ArrayList<String> common = new ArrayList<String>();
                int minIdx = parentComponents.length > childComponents.length ? childComponents.length - 1 : parentComponents.length;
                for (int i = 0; i <= minIdx && (c1 = parentComponents[i]).equals(c2 = childComponents[i]); ++i) {
                    common.add(c1);
                }
                if (common.size() < parentComponents.length && common.size() < childComponents.length) {
                    return true;
                }
            }
        }
        return false;
    }

    protected static boolean isChildPath(URL parent, URL child) {
        String parentPathStr = parent.getPath();
        String childPathStr = child.getPath();
        if ((parentPathStr == null || parentPathStr.length() == 0) && childPathStr != null && childPathStr.length() > 0) {
            return true;
        }
        if (parentPathStr != null && parentPathStr.length() > 0 && childPathStr != null && childPathStr.length() > 0) {
            UnixPath parentPath = new UnixPath(parentPathStr);
            parentPath = parentPath.getCanonical();
            UnixPath childPath = new UnixPath(childPathStr);
            childPath = childPath.getCanonical();
            if (parentPath.isAbsolute() && childPath.isAbsolute() && parentPath.compareTo(childPath) != 0) {
                String c2;
                String c1;
                String[] parentComponents = parentPath.getComponents();
                String[] childComponents = childPath.getComponents();
                ArrayList<String> common = new ArrayList<String>();
                int minIdx = parentComponents.length > childComponents.length ? childComponents.length - 1 : parentComponents.length - 1;
                for (int i = 0; i <= minIdx && (c1 = parentComponents[i]).equals(c2 = childComponents[i]); ++i) {
                    common.add(c1);
                }
                if (common.size() == parentComponents.length && childComponents.length > parentComponents.length) {
                    return true;
                }
            }
        }
        return false;
    }
}

