/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http.web;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jsoup.Jsoup;
import org.jsoup.helper.W3CDom;
import org.jsoup.nodes.Document;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import xyz.cofe.http.HttpResponse;
import xyz.cofe.http.web.FollowLink;
import xyz.cofe.xml.XMLUtil;

public class HtmlPage {
    public final URL url;
    public final String html;
    public final org.w3c.dom.Document document;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(HtmlPage.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(HtmlPage.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(HtmlPage.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(HtmlPage.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(HtmlPage.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(HtmlPage.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(HtmlPage.class.getName()).log(Level.SEVERE, null, ex);
    }

    public HtmlPage(String html, URL url) {
        if (html == null) {
            throw new IllegalArgumentException("html==null");
        }
        if (url == null) {
            throw new IllegalArgumentException("url==null");
        }
        this.url = url;
        this.html = html;
        Document doc = Jsoup.parse((String)this.html);
        W3CDom w3cdom = new W3CDom();
        this.document = w3cdom.fromJsoup(doc);
    }

    public HtmlPage(HttpResponse response) {
        if (response == null) {
            throw new IllegalArgumentException("response==null");
        }
        this.url = response.getCurrentRequest().getUrl();
        this.html = response.getText();
        Document doc = Jsoup.parse((String)this.html);
        W3CDom w3cdom = new W3CDom();
        this.document = w3cdom.fromJsoup(doc);
    }

    public List<FollowLink> getFollowLinks() {
        return this.getFollowLinks_xpath();
    }

    private List<FollowLink> getFollowLinks_xpath() {
        ArrayList<FollowLink> links = new ArrayList<FollowLink>();
        NodeList nl = XMLUtil.xpathNodeSet((String)"//a", (Node)this.document);
        if (nl != null) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (!(n instanceof Element)) continue;
                Element el = (Element)n;
                String href = el.getAttribute("href");
                String text = XMLUtil.getText((Node)n);
                LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
                NamedNodeMap nnm = el.getAttributes();
                if (nnm != null) {
                    for (int ai = 0; ai < nnm.getLength(); ++ai) {
                        Node na = nnm.item(ai);
                        if (!(na instanceof Attr)) continue;
                        Attr attr = (Attr)na;
                        String name = attr.getName();
                        String val = attr.getValue();
                        if (name == null || val == null) continue;
                        attrs.put(name, val);
                    }
                }
                if (href == null) continue;
                try {
                    URI baseAddr = this.url.toURI();
                    URI toAddr = baseAddr.resolve(href);
                    FollowLink flink = new FollowLink(this.url, toAddr.toURL(), text, href, attrs);
                    links.add(flink);
                    continue;
                }
                catch (URISyntaxException ex) {
                    Logger.getLogger(HtmlPage.class.getName()).log(Level.SEVERE, null, ex);
                    continue;
                }
                catch (MalformedURLException ex) {
                    Logger.getLogger(HtmlPage.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return links;
    }
}

