/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http.web;

import java.net.URL;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Pair;
import xyz.cofe.http.web.HtmlPage;

public class Resource {
    public final Lock lock = new ReentrantLock();
    private URL url = null;
    private int statusCode = -2;
    private String statusMessage = null;
    private String contentType = null;
    private long contentLength = -1L;
    private List<Pair<URL, URL>> redirects = null;
    private URL lastRedirect = null;
    private boolean partialContentSupport = false;
    private HtmlPage htmlPage = null;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(Resource.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(Resource.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(Resource.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(Resource.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(Resource.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(Resource.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(Resource.class.getName()).log(Level.SEVERE, null, ex);
    }

    public URL getUrl() {
        try {
            this.lock.lock();
            URL uRL = this.url;
            return uRL;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setUrl(URL url) {
        try {
            this.lock.lock();
            this.url = url;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getStatusCode() {
        try {
            this.lock.lock();
            int n = this.statusCode;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setStatusCode(int statusCode) {
        try {
            this.lock.lock();
            this.statusCode = statusCode;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getStatusMessage() {
        try {
            this.lock.lock();
            String string = this.statusMessage;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setStatusMessage(String statusMessage) {
        try {
            this.lock.lock();
            this.statusMessage = statusMessage;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getContentType() {
        try {
            this.lock.lock();
            String string = this.contentType;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setContentType(String contentType) {
        try {
            this.lock.lock();
            this.contentType = contentType;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getContentLength() {
        try {
            this.lock.lock();
            long l = this.contentLength;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setContentLength(long contentLength) {
        try {
            this.lock.lock();
            this.contentLength = contentLength;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<Pair<URL, URL>> getRedirects() {
        try {
            this.lock.lock();
            List<Pair<URL, URL>> list = this.redirects;
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setRedirects(List<Pair<URL, URL>> redirects) {
        try {
            this.lock.lock();
            this.redirects = redirects;
        }
        finally {
            this.lock.unlock();
        }
    }

    public URL getLastRedirect() {
        try {
            this.lock.lock();
            URL uRL = this.lastRedirect;
            return uRL;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setLastRedirect(URL lastRedirect) {
        try {
            this.lock.lock();
            this.lastRedirect = lastRedirect;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isPartialContentSupport() {
        try {
            this.lock.lock();
            boolean bl = this.partialContentSupport;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setPartialContentSupport(boolean partialContentSupport) {
        try {
            this.lock.lock();
            this.partialContentSupport = partialContentSupport;
        }
        finally {
            this.lock.unlock();
        }
    }

    public HtmlPage getHtmlPage() {
        try {
            this.lock.lock();
            HtmlPage htmlPage = this.htmlPage;
            return htmlPage;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setHtmlPage(HtmlPage htmlPage) {
        try {
            this.lock.lock();
            this.htmlPage = htmlPage;
        }
        finally {
            this.lock.unlock();
        }
    }

    public URL getCurrentUrl() {
        URL u = this.getUrl();
        URL lu = this.getLastRedirect();
        List<Pair<URL, URL>> lr = this.getRedirects();
        if (lr != null && !lr.isEmpty()) {
            return (URL)lr.get(lr.size() - 1).B();
        }
        if (lu != null) {
            return lu;
        }
        return u;
    }
}

