/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.http.web;

import java.io.Closeable;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.Func4;
import xyz.cofe.collection.Pair;
import xyz.cofe.common.ListenersHelper;
import xyz.cofe.common.State;
import xyz.cofe.common.StateChangedEvent;
import xyz.cofe.http.HttpClient;
import xyz.cofe.http.HttpHeaders;
import xyz.cofe.http.HttpListenerAdapter;
import xyz.cofe.http.HttpRequest;
import xyz.cofe.http.HttpResponse;
import xyz.cofe.http.HttpStatusHelper;
import xyz.cofe.http.IsFinished;
import xyz.cofe.http.MimeTypes;
import xyz.cofe.http.web.CanceledRedirectEvent;
import xyz.cofe.http.web.FollowLink;
import xyz.cofe.http.web.FollowLinkEvent;
import xyz.cofe.http.web.HtmlPage;
import xyz.cofe.http.web.NoFollowLinkEvent;
import xyz.cofe.http.web.RedirectEvent;
import xyz.cofe.http.web.Resource;
import xyz.cofe.http.web.ScanBeginEvent;
import xyz.cofe.http.web.ScanEndEvent;

public class SiteScanner
implements IsFinished {
    protected final Lock lock;
    protected final ListenersHelper<Listener, Object> listeners = new ListenersHelper((Func2)new Func2<Object, Listener, Object>(){

        public Object apply(Listener listener, Object ev) {
            listener.siteScannerEvent(ev);
            return null;
        }
    });
    protected HttpClient httpClient = null;
    protected MimeTypes mimeTypes = null;
    protected Set<URL> history = new LinkedHashSet<URL>();
    protected State state = State.Ready;
    protected Boolean async = null;
    protected Thread thread = null;
    protected Func4<Boolean, HttpHeaders, URL, URL, List<Pair<URL, URL>>> redirectValidate = new Func4<Boolean, HttpHeaders, URL, URL, List<Pair<URL, URL>>>(){

        public Boolean apply(HttpHeaders hh, URL from, URL to, List<Pair<URL, URL>> arg4) {
            if (!SiteScanner.this.allowRedirect(from, to)) {
                SiteScanner.this.fireEvent(new CanceledRedirectEvent(SiteScanner.this, from, to));
                return false;
            }
            return true;
        }
    };
    private boolean nullContentTypeAsHtml = true;
    private int maxNullContentTypeSize = 0x100000;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(SiteScanner.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(SiteScanner.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(SiteScanner.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(SiteScanner.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(SiteScanner.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(SiteScanner.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(SiteScanner.class.getName()).log(Level.SEVERE, null, ex);
    }

    public SiteScanner() {
        this.lock = new ReentrantLock();
    }

    public boolean hasListener(Listener listener) {
        return this.listeners.hasListener((Object)listener);
    }

    public Set<Listener> getListeners() {
        return this.listeners.getListeners();
    }

    public Closeable addListener(Listener listener) {
        return this.listeners.addListener((Object)listener);
    }

    public Closeable addListener(Listener listener, boolean weakLink) {
        return this.listeners.addListener((Object)listener, weakLink);
    }

    public void removeListener(Listener listener) {
        this.listeners.removeListener((Object)listener);
    }

    public void fireEvent(Object event) {
        this.listeners.fireEvent(event);
    }

    public HttpClient getHttpClient() {
        try {
            this.lock.lock();
            if (this.httpClient == null) {
                this.httpClient = new HttpClient();
            }
            HttpClient httpClient = this.httpClient;
            return httpClient;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setHttpClient(HttpClient client) {
        if (client == null) {
            throw new IllegalArgumentException("client==null");
        }
        try {
            this.lock.lock();
            this.httpClient = client;
        }
        finally {
            this.lock.unlock();
        }
    }

    public MimeTypes getMimeTypes() {
        try {
            this.lock.lock();
            if (this.mimeTypes == null) {
                this.mimeTypes = new MimeTypes();
            }
            MimeTypes mimeTypes = this.mimeTypes;
            return mimeTypes;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void preview(HttpResponse response) {
        List<Pair<URL, URL>> redirects;
        if (response == null) {
            throw new IllegalArgumentException("response==null");
        }
        List<Throwable> errors = response.getErrors();
        if (errors != null && !errors.isEmpty()) {
            for (Throwable throwable : errors) {
                System.out.println("error " + throwable.getMessage());
            }
        }
        if ((redirects = response.getRedirectUrls()) != null && !redirects.isEmpty()) {
            for (Pair<URL, URL> pair : redirects) {
                System.out.println("redirect " + pair.A() + " -> " + pair.B());
            }
        }
        int n = response.getStatusCode();
        String string = response.getStatusMessage();
        System.out.println("status " + n + " " + string);
        System.out.println("response headers:");
        System.out.println(response.getHttpHeaders());
        long prevBytesLenLong = response.getDownloadedSize();
        int prevBytesLenMax = 512;
        int prevBytesLen = prevBytesLenLong > (long)prevBytesLenMax ? prevBytesLenMax : (int)prevBytesLenLong;
        byte[] prevBytes = response.getContentBuffer().get(0L, prevBytesLen);
        Charset cs = response.getHttpHeaders().getContentTypeCharset();
        if (cs == null) {
            cs = response.getRequest().getHttpClient().getDefaultCharset();
        }
        String prevText = new String(prevBytes, cs);
        System.out.println("preview:");
        System.out.println(prevText);
    }

    public Set<URL> getHistory() {
        try {
            this.lock.lock();
            LinkedHashSet<URL> copy = new LinkedHashSet<URL>();
            copy.addAll(this.history);
            LinkedHashSet<URL> linkedHashSet = copy;
            return linkedHashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void addHistory(URL url) {
        try {
            this.lock.lock();
            this.history.add(url);
        }
        finally {
            this.lock.unlock();
        }
    }

    public State getState() {
        try {
            this.lock.lock();
            State state = this.state;
            return state;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setState(State state) {
        try {
            this.lock.lock();
            this.state = state;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isAsync() {
        try {
            this.lock.lock();
            if (this.async == null) {
                this.async = false;
            }
            boolean bl = this.async;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setAsync(boolean async) {
        try {
            this.lock.lock();
            this.async = async;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Thread getThread() {
        try {
            this.lock.lock();
            Thread thread = this.thread;
            return thread;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop(long waitStopMS, long forceStopMS, long sleepTimeMS) {
        if (waitStopMS < 0L) {
            throw new IllegalArgumentException("waitStopMS<0");
        }
        if (forceStopMS < 0L) {
            throw new IllegalArgumentException("forceStopMS<0");
        }
        Thread t = this.thread;
        if (t == null) {
            return;
        }
        t.interrupt();
        Date d1 = new Date();
        while (t.isAlive()) {
            Date d2 = new Date();
            long ddiff = d2.getTime() - d1.getTime();
            if (ddiff >= waitStopMS) {
                t.interrupt();
            }
            if (ddiff >= forceStopMS) {
                t.stop();
            }
            if (sleepTimeMS <= 0L) {
                Thread.yield();
                continue;
            }
            try {
                Thread.sleep(sleepTimeMS);
                Thread.yield();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(HttpResponse.class.getName()).log(Level.SEVERE, null, ex);
                break;
            }
        }
    }

    public void stop() {
        int readtimeout = 30000;
        if (readtimeout > 0) {
            this.stop(100L, readtimeout * 3, 50L);
        } else {
            this.stop(100L, 5000L, 50L);
        }
    }

    public void waitForFinished() {
        Thread tt = Thread.currentThread();
        Thread t = null;
        try {
            if (this.lock != null) {
                this.lock.lock();
            }
            t = this.thread;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
        if (t == null) {
            throw new IllegalStateException("not async started");
        }
        if (t.equals(tt)) {
            throw new Error("thread can be locked");
        }
        while (!this.isFinished() || t.isAlive()) {
            Thread.yield();
        }
    }

    @Override
    public boolean isFinished() {
        try {
            this.lock.lock();
            boolean bl = State.Finished.equals((Object)this.state);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(final URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        StateChangedEvent<SiteScanner> e = null;
        if (!this.isAsync()) {
            State s = this.getState();
            if (!State.Ready.equals((Object)s) && !State.Finished.equals((Object)s)) {
                throw new IllegalStateException("state (" + (Object)((Object)s) + ") not ( ready | finished )");
            }
            this.setState(State.Running);
            e = new StateChangedEvent<SiteScanner>(this, s, this.getState());
            this.fireEvent(e);
            this.scan(url, null);
            State olds = this.getState();
            this.setState(State.Finished);
            this.fireEvent(new StateChangedEvent<SiteScanner>(this, olds, this.getState()));
        } else {
            try {
                this.lock.lock();
                State s = this.getState();
                if (!State.Ready.equals((Object)s) && !State.Finished.equals((Object)s)) {
                    throw new IllegalStateException("state (" + (Object)((Object)s) + ") not ( ready | finished )");
                }
                this.setState(State.Running);
                e = new StateChangedEvent<SiteScanner>(this, s, this.getState());
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        SiteScanner.this.scan(url, null);
                        State s = SiteScanner.this.getState();
                        SiteScanner.this.setState(State.Finished);
                        SiteScanner.this.fireEvent(new StateChangedEvent<SiteScanner>(SiteScanner.this, s, SiteScanner.this.getState()));
                    }
                };
                this.thread = new Thread(r);
                this.thread.setDaemon(true);
                this.thread.setPriority(1);
                this.thread.start();
            }
            finally {
                this.lock.unlock();
            }
            if (e != null) {
                this.fireEvent(e);
            }
        }
    }

    protected void scan(URL url, Resource parent) {
        Resource r;
        if (parent == null) {
            this.getHistory().clear();
        }
        if ((r = this.inspectResource(url)) != null) {
            this.addHistory(url);
            List<Pair<URL, URL>> lredirects = r.getRedirects();
            if (lredirects != null && !lredirects.isEmpty()) {
                for (Pair<URL, URL> p : lredirects) {
                    this.addHistory((URL)p.A());
                    this.addHistory((URL)p.B());
                }
            }
            this.scan(url, r, parent);
        }
    }

    protected void scan(URL url, Resource resource, Resource referer) {
        this.fireEvent(new ScanBeginEvent(this, url, resource, referer));
        if (!Thread.interrupted()) {
            this.scanLinks(resource);
        }
        this.fireEvent(new ScanEndEvent(this, url, resource, referer));
    }

    protected void scanLinks(Resource r) {
        HtmlPage page = r.getHtmlPage();
        if (page == null) {
            return;
        }
        for (FollowLink fl : page.getFollowLinks()) {
            if (this.allowFollow(r, fl)) {
                this.fireEvent(new FollowLinkEvent(this, r, fl.link));
                this.scan(fl.link, r);
                continue;
            }
            this.fireEvent(new NoFollowLinkEvent(this, r, fl.link));
        }
    }

    protected boolean isVisited(URL url) {
        return this.getHistory().contains(url);
    }

    protected boolean allowRedirect(URL from, URL to) {
        if (this.isVisited(to)) {
            return false;
        }
        return from.getHost().equals(to.getHost());
    }

    protected boolean allowFollow(Resource res, FollowLink flink) {
        if (flink == null) {
            return false;
        }
        if (this.isVisited(flink.link)) {
            return false;
        }
        return flink.sameHost;
    }

    private void catchResponse(HttpResponse res1, Resource resource, URL url, HttpStatusHelper httpStatusHelper, AtomicBoolean stopSignal) {
        int statusCode = res1.getStatusCode();
        resource.setStatusCode(statusCode);
        resource.setStatusMessage(res1.getStatusMessage());
        URL rurl = res1.getLastRedirectUrlTo();
        resource.setLastRedirect(rurl);
        resource.setRedirects(res1.getRedirectUrls());
        String contentType = res1.getHttpHeaders().getContentType();
        if (contentType == null) {
            int i;
            URL ur = rurl;
            if (ur == null) {
                ur = url;
            }
            String ext = null;
            String file = null;
            String path = ur.getPath();
            if (path.contains("/")) {
                if (!path.endsWith("/")) {
                    i = path.indexOf("/");
                    file = path.substring(i, path.length());
                }
            } else if (path.length() != 0) {
                file = path;
            }
            if (file != null && file.length() > 0 && file.contains(".") && !file.endsWith(".")) {
                i = file.indexOf(".");
                ext = file.substring(i, file.length());
            }
            if (ext != null) {
                contentType = this.getMimeTypes().getMimeForExtension(ext);
            }
        }
        resource.setContentType(contentType);
        long contentLength = res1.getHttpHeaders().getContentLength();
        resource.setContentLength(contentLength);
        String acceptRanges = res1.getHttpHeaders().getAcceptRanges();
        if (statusCode == 206 || acceptRanges != null && acceptRanges.equalsIgnoreCase("bytes") && contentLength >= 0L) {
            resource.setPartialContentSupport(true);
        } else {
            resource.setPartialContentSupport(false);
        }
        if (!httpStatusHelper.isSuccess(statusCode) && !res1.isFinished()) {
            SiteScanner.logInfo("send stop", new Object[0]);
            stopSignal.set(true);
        }
        if (contentType != null && !this.getMimeTypes().isHtml(contentType) && !res1.isFinished()) {
            SiteScanner.logInfo("send stop - contt", new Object[0]);
            stopSignal.set(true);
        }
    }

    protected Resource inspectResource(final URL url) {
        HttpClient client = this.getHttpClient();
        HttpRequest req = client.createRequest(url);
        if (req == null) {
            return null;
        }
        final Resource resource = new Resource();
        resource.setUrl(url);
        req.setAsync(true);
        req.setFollowRedirect(true);
        final HttpStatusHelper httpStatusHelper = new HttpStatusHelper();
        HttpResponse res = req.createResponse();
        res.setRedirectValidate(this.redirectValidate);
        HttpListenerAdapter redirectListener = new HttpListenerAdapter(){

            @Override
            protected void responseRedirect(HttpResponse.RedirectEvent event, HttpResponse response, URL from, URL to) {
                SiteScanner.this.fireEvent(new RedirectEvent(SiteScanner.this, from, to));
            }
        };
        final AtomicBoolean stopSignal = new AtomicBoolean(false);
        final AtomicBoolean dlStateCatched = new AtomicBoolean(false);
        HttpListenerAdapter downloadStateListener = new HttpListenerAdapter(){

            @Override
            protected void responseStateChanged(HttpResponse.StateChangedEvent event, HttpResponse res, HttpResponse.State oldState, HttpResponse.State newState) {
                if (newState == HttpResponse.State.Downloading) {
                    SiteScanner.this.catchResponse(res, resource, url, httpStatusHelper, stopSignal);
                    dlStateCatched.set(true);
                }
            }
        };
        res.addListener(redirectListener);
        res.addListener(downloadStateListener);
        res.start();
        boolean fireInterupt = false;
        while (!res.isFinished()) {
            Thread.yield();
            if (stopSignal.get()) {
                res.stop();
            }
            if (!Thread.interrupted()) continue;
            res.stop();
            fireInterupt = true;
        }
        if (!dlStateCatched.get()) {
            this.catchResponse(res, resource, url, httpStatusHelper, stopSignal);
        }
        if (!res.isErrorsNotExists()) {
            this.preview(res);
            if (fireInterupt) {
                Thread.currentThread().interrupt();
            }
            return resource;
        }
        HttpHeaders hh = res.getHttpHeaders();
        long contentLength = hh == null ? -1L : hh.getContentLength();
        String ct = resource.getContentType();
        if (ct == null) {
            if (!this.nullContentTypeAsHtml) {
                if (fireInterupt) {
                    Thread.currentThread().interrupt();
                }
                return resource;
            }
            if (contentLength < 0L || contentLength > (long)this.maxNullContentTypeSize) {
                if (fireInterupt) {
                    Thread.currentThread().interrupt();
                }
                return resource;
            }
        } else if (!this.getMimeTypes().isHtml(ct)) {
            if (fireInterupt) {
                Thread.currentThread().interrupt();
            }
            return resource;
        }
        try {
            HtmlPage htmlPage = new HtmlPage(res);
            resource.setHtmlPage(htmlPage);
        }
        catch (Throwable err) {
            SiteScanner.logFine("html parse error {0} url = {1}", err.getMessage(), url);
        }
        if (fireInterupt) {
            Thread.currentThread().interrupt();
        }
        return resource;
    }

    public static class ListenerAdapter
    implements Listener {
        @Override
        public void siteScannerEvent(Object e) {
            Object fe;
            if (e instanceof CanceledRedirectEvent) {
                fe = (CanceledRedirectEvent)e;
                this.canceledRedirect((CanceledRedirectEvent)fe, ((CanceledRedirectEvent)fe).siteScanner, ((CanceledRedirectEvent)fe).from, ((CanceledRedirectEvent)fe).to);
            }
            if (e instanceof RedirectEvent) {
                fe = (RedirectEvent)e;
                this.redirect((RedirectEvent)fe, ((RedirectEvent)fe).siteScanner, ((RedirectEvent)fe).from, ((RedirectEvent)fe).to);
            }
            if (e instanceof FollowLinkEvent) {
                fe = (FollowLinkEvent)e;
                this.follow((FollowLinkEvent)fe, ((FollowLinkEvent)fe).siteScanner, ((FollowLinkEvent)fe).resource, ((FollowLinkEvent)fe).url);
            }
            if (e instanceof NoFollowLinkEvent) {
                fe = (NoFollowLinkEvent)e;
                this.noFollow((NoFollowLinkEvent)fe, ((NoFollowLinkEvent)fe).siteScanner, ((NoFollowLinkEvent)fe).resource, ((NoFollowLinkEvent)fe).url);
            }
            if (e instanceof ScanBeginEvent) {
                fe = (ScanBeginEvent)e;
                this.beginScan((ScanBeginEvent)fe, ((ScanBeginEvent)fe).siteScanner, ((ScanBeginEvent)fe).resource);
            }
            if (e instanceof ScanEndEvent) {
                fe = (ScanEndEvent)e;
                this.endScan((ScanEndEvent)fe, ((ScanEndEvent)fe).siteScanner, ((ScanEndEvent)fe).resource);
            }
        }

        protected void follow(FollowLinkEvent ev, SiteScanner si, Resource res, URL url) {
        }

        protected void noFollow(NoFollowLinkEvent ev, SiteScanner si, Resource res, URL url) {
        }

        protected void beginScan(ScanBeginEvent ev, SiteScanner si, Resource res) {
        }

        protected void endScan(ScanEndEvent ev, SiteScanner si, Resource res) {
        }

        protected void redirect(RedirectEvent ev, SiteScanner si, URL from, URL to) {
        }

        protected void canceledRedirect(CanceledRedirectEvent ev, SiteScanner si, URL from, URL to) {
        }
    }

    public static interface Listener {
        public void siteScannerEvent(Object var1);
    }
}

