/*
 * The MIT License
 *
 * Copyright 2015 user.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package xyz.cofe.text.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.Func2;
import xyz.cofe.text.Align;
import xyz.cofe.text.EndLine;
import xyz.cofe.text.Text;
import xyz.cofe.text.table.TextCell;
import xyz.cofe.text.table.TextCellBuilder;

/**
 * Создание форматирования - выравнивания
 * @author user
 */
public class AlignFormatBuilder 
implements FormatBuilder
{
    private TextCellBuilder buildTextCell( String formatting ){
        TextCellBuilder tcb = new TextCellBuilder();
        Pattern ptrn = Pattern.compile("(?is)^"+formattingRegex+".*");
        Matcher m = ptrn.matcher(formatting);
        if( m.matches() ){
            String align = m.group(2);
            String width = m.group(3);

            if( align.equals("") || align.equals("<") ){ tcb.setHorzAlign(Align.Begin); }
            if( align.equals("=") ){ tcb.setHorzAlign(Align.Center); }
            if( align.equals(">") ){ tcb.setHorzAlign(Align.End); }

            tcb.setWidth(Integer.parseInt(width));
            tcb.setMultiLine(true);
        }
        return tcb;
    }
    
    private final String formattingRegex = "((<?|=|>)(\\d+))";

    @Override
    public <T> Func1<String,T> build( 
            final BasicTemplate template, 
            final Func1<Object,T> setContext,
            final Func1<String,String> evalCode 
    ){
        final List rows = new ArrayList();
        final List cells = new ArrayList();
        final Map<Object,TextCellBuilder> codeFormat = new LinkedHashMap<Object, TextCellBuilder>();

        template.getParser().eval(
            template.getAst(), 

            // eval text
            new Func1() {
                @Override
                public Object apply(final Object text) {
                    int i = -1;
                    for( String line : Text.splitNewLines(text.toString()) ){
                        final String fline = line;
                        i++;
                        if( i>0 ){
                            rows.add(
                                Arrays.asList(cells.toArray())
                            );
                            cells.clear();
                        }

                        Func1 cellFun = new Func1(){
                            @Override
                            public Object apply(Object context) {
                                return fline;
                            }
                        };
                        cells.add( cellFun );
                    }

                    return text;
                }
            }, 

            // eval code
            new Func1() {
                @Override
                public Object apply(Object code) {
                    Pattern ptrn = Pattern.compile("(?s)^(.*?)\\:("+formattingRegex+")$");
                    Matcher m = ptrn.matcher(code.toString());

                    String srccode = code.toString();
                    TextCellBuilder tcb = null;
                    if( m.matches() ){
                        srccode = m.group(1);
                        String format = m.group(2);
                        tcb = buildTextCell(format);
                    }

                    final String fsrccode = srccode;
                    Func1 cellFun = new Func1(){
                        @Override
                        public Object apply(Object context) {
                            setContext.apply((T)context);
                            return evalCode.apply(fsrccode);
                        }
                    };
                    cells.add( cellFun );
                    codeFormat.put( cellFun, tcb);

                    return fsrccode;
                }
            }, 

            // init res
            new Func0(){
                @Override
                public Object apply() {
                    return "";
                }
            }, 

            // append text
            new Func2(){
                @Override
                public Object apply(Object res, Object text) {
                    return "";
                }
            },

            // append code
            new Func2(){
                @Override
                public Object apply(Object res, Object code) {
                    return "";
                }
            }
        ).apply();

        if( !cells.isEmpty() )rows.add(cells);

        Func1 evalCtx = new Func1(){
            @Override
            public Object apply(Object ctx) {
                List<String> strings = new ArrayList<String>();
                for( Object ocells : rows ){
                    if( ocells instanceof List ){
                        List<TextCell> ltc = new ArrayList<TextCell>();

                        for( Object ocell : ((List)ocells) ){
                            String txtval = "";
                            if( ocell instanceof Func1 ){
                                Object cellval = ((Func1)ocell).apply(ctx);
                                if( cellval!=null ){
                                    txtval = cellval.toString();
                                }
                            }
                            TextCellBuilder tcb = codeFormat.get(ocell);
                            if( tcb!=null ){
                                TextCell tc = tcb.build(txtval);
                                ltc.add(tc);
                            }else{
                                tcb = new TextCellBuilder();
                                tcb.setWidth(txtval.length());
                                TextCell tc = tcb.build(txtval);
                                ltc.add(tc);
                            }
                        }

                        List<String> lstr = TextCell.joinAsList(ltc);
                        if( lstr!=null && lstr.isEmpty() ){
                            strings.add("");
                        }else{
                            strings.addAll(lstr);
                        }
                    }
                }
                return Text.join(strings, EndLine.Default.get());
            }
        };

        return evalCtx;
    }
}
