/*
 * The MIT License
 *
 * Copyright 2015 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"),
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ,
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ,
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.text.template;


import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.text.parser.ListLexer;
import xyz.cofe.text.parser.TokenParser;
import xyz.cofe.text.parser.lex.AnyCharParser;
import xyz.cofe.text.parser.lex.Keywords;
import xyz.cofe.text.parser.lex.KeywordsParser;

/**
 * Лексический анализатор
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class TemplateLexer extends ListLexer
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static void logFine(String message,Object ... args){
        Logger.getLogger(TemplateLexer.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message,Object ... args){
        Logger.getLogger(TemplateLexer.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message,Object ... args){
        Logger.getLogger(TemplateLexer.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message,Object ... args){
        Logger.getLogger(TemplateLexer.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        Logger.getLogger(TemplateLexer.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message,Object ... args){
        Logger.getLogger(TemplateLexer.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        Logger.getLogger(TemplateLexer.class.getName()).log(Level.SEVERE, null, ex);
    }
    //</editor-fold>

    public TemplateLexer(){
        Keywords keywords = new Keywords(false);
        keywords
            .put("${", "codeBegin")
            .put("\\$", "escape")
            .put("\\\\", "escape")
            .put("\\${", "escape")
            .put("{", "blockBegin")
            .put("}", "blockEnd")
            ;

        KeywordsParser keyWords = new KeywordsParser(keywords);
        AnyCharParser anyChar = new AnyCharParser(keywords.getKeywords());

        List<TokenParser> parsers = getParsers();
        parsers.add(keyWords);
        parsers.add(anyChar);
    }

    protected TemplateLexer(String[] codeBegin, String[] escape, String[] blockBegin, String[] blockEnd){
        Keywords keywords = new Keywords(false);

        for( String k : codeBegin )keywords.put(k, "codeBegin");
        for( String k : escape )keywords.put(k, "escape");
        for( String k : blockBegin )keywords.put(k, "blockBegin");
        for( String k : blockEnd )keywords.put(k, "blockEnd");

//        keywords
//            .put("${", "codeBegin")
//            .put("\\$", "escape")
//            .put("\\\\", "escape")
//            .put("\\${", "escape")
//            .put("{", "blockBegin")
//            .put("}", "blockEnd")
//            ;

        KeywordsParser keyWords = new KeywordsParser(keywords);
        AnyCharParser anyChar = new AnyCharParser(keywords.getKeywords());

        List<TokenParser> parsers = getParsers();
        parsers.add(keyWords);
        parsers.add(anyChar);
    }
}
