/*
 * The MIT License
 *
 * Copyright 2015 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"),
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ,
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ,
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.text.template.ctx;


import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Описание времени, используется совместно с BasicTemplate . <br>
 * <pre>
 * SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
 * DateVar dv1 = new DateVar(sdf.parse("2015-07-28 13:34:05"));
 *
 * BasicTemplate bt = new BasicTemplate("<b>${yyyy}-${MM}-${dd} ${HH}:${mm}:${ss}</b>");
 * String txt = bt.context(DateVar.class).build().eval(dv1);
 * System.out.println(txt);
 * // выведет
 * // <b>2015-07-28 13:34:05</b>
 *
 * bt = new BasicTemplate(
 *   "<b>${yyyy}-${MM} ${MMM}-${dd} "+
 *   "${e} ${ee} ${u} ${HH}:${mm}:${ss}.${SSS} ${z} ${x} ${GZ}</b>");
 * txt = bt.context(DateVar.class).build().eval(dv1);
 * System.out.println(txt);
 * // выведет
 * // <b>2015-07 Июль-28 Вт вторник 2 13:34:05 000 +0500 +05:00 YEKT</b>
 * </pre>
 *
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class DateVar {
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static void logFine(String message,Object ... args){
        Logger.getLogger(DateVar.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message,Object ... args){
        Logger.getLogger(DateVar.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message,Object ... args){
        Logger.getLogger(DateVar.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message,Object ... args){
        Logger.getLogger(DateVar.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        Logger.getLogger(DateVar.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message,Object ... args){
        Logger.getLogger(DateVar.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        Logger.getLogger(DateVar.class.getName()).log(Level.SEVERE, null, ex);
    }
    //</editor-fold>

    private transient GregorianCalendar cal = new GregorianCalendar();
    private Date date = null;

    public DateVar(){
        this.date = new Date();
        cal.setTime(date);
    }

    public DateVar(Date date){
        if( date==null )throw new IllegalArgumentException( "date==null" );
        this.date = date;
        cal.setTime(date);
    }

    //<editor-fold defaultstate="collapsed" desc="date">
    public Date getDate() {
        if( date==null ){
            date = new Date();
            cal.setTime(date);
        }
        return date;
    }

    public void setDate( Date date ) {
        if( date==null )throw new IllegalArgumentException( "date==null" );
        this.date = date;
        cal.setTime(date);
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="year">
    public int getYear(){
        return cal.get(GregorianCalendar.YEAR);
    }
//        public void setYear(int y){}
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="yyyy">
    public String getYyyy(){
        int y = getYear();
        if( y<10 )return "000"+Integer.toString(y);
        if( y<100 )return "00"+Integer.toString(y);
        if( y<1000 )return "0"+Integer.toString(y);
        return Integer.toString(y);
    }
//
//        public void setYyyy(String y){
//        }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="month">
    public int getMonth(){
        return cal.get(GregorianCalendar.MONTH)+1;
    }
//        public void setMonth(int y){}
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="MM - month: 01">
    public String getMM(){
        int m = getMonth();
        String s = Integer.toString(m);
        if( s.length()==1 ){
            s = "0"+s;
        }
        return s;
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="MMM - month: Июль">
    public String getMMM(){
        SimpleDateFormat sdf = new SimpleDateFormat("MMM");
        return sdf.format(getDate());
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="day - day of month: 4">
    public int getDay(){
        return cal.get(GregorianCalendar.DAY_OF_MONTH);
    }
//        public void setDay(int y){}
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="dd - day of month: 04">
    public String getDd(){
        String s = Integer.toString(getDay());
        if( s.length()==1 ) s = "0" + s;
        return s;
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="ee - day of week: вторник">
    public String getEe(){
        SimpleDateFormat sdf = new SimpleDateFormat("EEEEEE");
        return sdf.format(getDate());
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="e - day of week: Вт">
    public String getE(){
        SimpleDateFormat sdf = new SimpleDateFormat("E");
        return sdf.format(getDate());
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="hour">
    public int getHour(){
        return cal.get(GregorianCalendar.HOUR_OF_DAY);
    }
//        public void setHour(int y){}
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="HH">
    public String getHH(){
        String s = Integer.toString(getHour());
        if( s.length()==1 ) s = "0" + s;
        return s;
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="minute">
    public int getMinute(){
        return cal.get(GregorianCalendar.MINUTE);
    }
//        public void setMinute(int y){}
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="mm">
    public String getMm(){
        String s = Integer.toString(getMinute());
        if( s.length()==1 ) s = "0" + s;
        return s;
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="second - Second in minute: 5">
    public int getSecond(){
        return cal.get(GregorianCalendar.SECOND);
    }
//        public void setSecond(int y){}
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="ss - Second in minute: 05">
    public String getSs(){
        String s = Integer.toString(getSecond());
        if( s.length()==1 ) s = "0" + s;
        return s;
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="SSS - Millisecond">
    public String getSSS(){
        SimpleDateFormat sdf = new SimpleDateFormat("SSS");
        return sdf.format(getDate());
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="GZ - General time zone: Pacific Standard Time; PST; GMT-08:00">
    public String getGZ(){
        SimpleDateFormat sdf = new SimpleDateFormat("z");
        return sdf.format(getDate());
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="Z - RFC 822 time zone: -0800">
    public String getZ(){
        SimpleDateFormat sdf = new SimpleDateFormat("Z");
        return sdf.format(getDate());
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="X - ISO 8601 time zone: -08; -0800; -08:00">
    public String getX(){
        SimpleDateFormat sdf = new SimpleDateFormat("XXX");
        return sdf.format(getDate());
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="ww - Week in year: 27">
    public String getWw(){
        SimpleDateFormat sdf = new SimpleDateFormat("ww");
        return sdf.format(getDate());
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="u - Day number of week (1 = Monday, ..., 7 = Sunday)">
    public String getU(){
        SimpleDateFormat sdf = new SimpleDateFormat("u");
        return sdf.format(getDate());
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="shortDT -> yyyyMMddHHmmss">
    public String getShortDT(){
        return getYyyy()+getMM()+getDd()+getHH()+getMm()+getSs();
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="DT -> yyyy-MM-dd HH:mm:ss">
    public String getDT(){
        return getYyyy()+"-"+getMM()+"-"+getDd()+" "+getHH()+":"+getMm()+":"+getSs();
    }
//</editor-fold>

    @Override
    public String toString() {
//        BasicTemplate bt = new BasicTemplate("${yyyy}-${MM}-${dd} ${HH}:${mm}:${ss}");
//        String txt = bt.context(DateVar.class).build().eval(this);
        return getDT();
    }
}
