/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func0;
import xyz.cofe.text.EndLine;
import xyz.cofe.text.EndLineReWriter;
import xyz.cofe.text.Text;
import xyz.cofe.text.UnionWriter;
import xyz.cofe.text.template.BasicTemplate;

public class Output
extends PrintWriter {
    private final boolean autoFlush;
    private EndLineReWriter endlineRewriter;
    private volatile boolean endLineWrited = true;
    private volatile Func0<String> linePrefix;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(Output.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(Output.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(Output.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(Output.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(Output.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(Output.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(Output.class.getName()).log(Level.SEVERE, null, ex);
    }

    public Output(Writer out) {
        super(out);
        this.endlineRewriter = this.createEndLineReWriter(out);
        this.out = this.endlineRewriter;
        this.autoFlush = false;
    }

    public Output(Writer out, boolean autoFlush) {
        super(out, autoFlush);
        this.endlineRewriter = this.createEndLineReWriter(out);
        this.out = this.endlineRewriter;
        this.autoFlush = autoFlush;
    }

    public Output(OutputStream out) {
        super(out);
        this.endlineRewriter = this.createEndLineReWriter(new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset()));
        this.out = this.endlineRewriter;
        this.autoFlush = false;
    }

    public Output(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
        this.endlineRewriter = this.createEndLineReWriter(new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset()));
        this.out = this.endlineRewriter;
        this.autoFlush = autoFlush;
    }

    private EndLineReWriter createEndLineReWriter(Writer wr) {
        return new EndLineReWriter(wr){

            protected void writeEndLine() throws IOException {
                super.writeEndLine();
                Output.this.endLineWrited = true;
            }

            private void wpref() throws IOException {
                if (Output.this.endLineWrited) {
                    Output.this.endLineWrited = false;
                    String pref = Output.this.getLinePrefix();
                    if (pref != null) {
                        String[] prefLines;
                        for (String prefLine : prefLines = Text.splitNewLines((String)pref)) {
                            super.write(prefLine);
                        }
                    }
                }
            }

            protected void writeChar(char c0) throws IOException {
                this.wpref();
                super.writeChar(c0);
            }

            public void write(char[] cbuf, int off, int len) throws IOException {
                this.wpref();
                super.write(cbuf, off, len);
            }

            public Writer append(char c) throws IOException {
                this.wpref();
                return super.append(c);
            }

            public Writer append(CharSequence csq, int start, int end) throws IOException {
                this.wpref();
                return super.append(csq, start, end);
            }

            public Writer append(CharSequence csq) throws IOException {
                this.wpref();
                return super.append(csq);
            }

            public void write(String str, int off, int len) throws IOException {
                this.wpref();
                super.write(str, off, len);
            }

            public void write(String str) throws IOException {
                this.wpref();
                super.write(str);
            }

            public void write(char[] cbuf) throws IOException {
                this.wpref();
                super.write(cbuf);
            }

            public void write(int c) throws IOException {
                this.wpref();
                super.write(c);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEndl() {
        Object lo = this.lock;
        if (lo != null) {
            Object object = lo;
            synchronized (object) {
                return this.getEndl0();
            }
        }
        return this.getEndl0();
    }

    private String getEndl0() {
        return this.endlineRewriter == null ? System.getProperty("line.separator", "\n") : this.endlineRewriter.getEndl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEndl(String txt) {
        Object lo = this.lock;
        if (lo != null) {
            Object object = lo;
            synchronized (object) {
                this.setEndl0(txt);
            }
        } else {
            this.setEndl0(txt);
        }
    }

    private void setEndl0(String txt) {
        if (this.endlineRewriter != null) {
            this.endlineRewriter.setEndl(txt == null ? EndLine.Default.get() : txt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(Writer output) {
        Object lo = this.lock;
        if (lo != null) {
            Object object = lo;
            synchronized (object) {
                this.flush();
                this.endlineRewriter = this.createEndLineReWriter(output == null ? new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset()) : output);
                this.out = this.endlineRewriter;
            }
        } else {
            this.flush();
            this.endlineRewriter = this.createEndLineReWriter(output == null ? new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset()) : output);
            this.out = this.endlineRewriter;
        }
    }

    public void reset() {
        this.reset(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendWriter(Writer w) {
        if (w == null) {
            throw new IllegalArgumentException("w==null");
        }
        Object lo = this.lock;
        if (lo != null) {
            Object object = lo;
            synchronized (object) {
                this.appendWriter0(w);
            }
        } else {
            this.appendWriter0(w);
        }
    }

    private void appendWriter0(Writer w) {
        if (this.out instanceof UnionWriter) {
            ((UnionWriter)this.out).getWriters().add(w);
        } else {
            UnionWriter uw = new UnionWriter(new Writer[]{this.out, w});
            this.out = uw;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWriter(Writer writer) {
        if (writer == null) {
            throw new IllegalArgumentException("writer==null");
        }
        Object lo = this.lock;
        if (lo != null) {
            Object object = lo;
            synchronized (object) {
                if (this.out instanceof UnionWriter) {
                    UnionWriter uw = (UnionWriter)this.out;
                    uw.getWriters().remove(writer);
                }
            }
        } else if (this.out instanceof UnionWriter) {
            UnionWriter uw = (UnionWriter)this.out;
            uw.getWriters().remove(writer);
        }
    }

    public BasicTemplate.EasyTemplate template(String template) {
        if (template == null) {
            throw new IllegalArgumentException("template==null");
        }
        BasicTemplate.EasyTemplate tmpl = BasicTemplate.template(template);
        tmpl.output(this);
        tmpl.align();
        tmpl.outputFlushing();
        return tmpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] buf, int off, int len) {
        Object lo = this.lock;
        if (lo != null) {
            Object object = lo;
            synchronized (object) {
                this.write0(buf, off, len);
            }
        } else {
            this.write0(buf, off, len);
        }
    }

    public boolean isEndLineWrited() {
        return this.endLineWrited;
    }

    public void setEndLineWrited(boolean endLineWrited) {
        this.endLineWrited = endLineWrited;
    }

    public void setLinePrefixFn(Func0<String> fn) {
        this.linePrefix = fn;
    }

    public Func0<String> getLinePrefixFn() {
        return this.linePrefix;
    }

    public String getLinePrefix() {
        Func0<String> lPrefix = this.linePrefix;
        if (lPrefix == null) {
            return null;
        }
        try {
            String prefix = (String)lPrefix.apply();
            return prefix;
        }
        catch (Throwable err) {
            Output.logException(err);
            return null;
        }
    }

    public void setLinePrefix(final String prefix) {
        if (prefix == null) {
            this.linePrefix = null;
            return;
        }
        this.linePrefix = new Func0<String>(){

            public String apply() {
                return prefix;
            }
        };
    }

    private void write0(char[] buf, int off, int len) {
        String s;
        super.write(buf, off, len);
        if (this.autoFlush && Text.splitNewLines((String)(s = new String(buf, off, len))).length > 1) {
            this.flush();
        }
    }
}

