/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.Func2;
import xyz.cofe.text.Align;
import xyz.cofe.text.EndLine;
import xyz.cofe.text.Text;
import xyz.cofe.text.table.TextCell;
import xyz.cofe.text.table.TextCellBuilder;
import xyz.cofe.text.template.BasicTemplate;
import xyz.cofe.text.template.FormatBuilder;

public class AlignFormatBuilder
implements FormatBuilder {
    private final String formattingRegex = "((<?|=|>)(\\d+))";

    private TextCellBuilder buildTextCell(String formatting) {
        TextCellBuilder tcb = new TextCellBuilder();
        Pattern ptrn = Pattern.compile("(?is)^((<?|=|>)(\\d+)).*");
        Matcher m = ptrn.matcher(formatting);
        if (m.matches()) {
            String align = m.group(2);
            String width = m.group(3);
            if (align.equals("") || align.equals("<")) {
                tcb.setHorzAlign(Align.Begin);
            }
            if (align.equals("=")) {
                tcb.setHorzAlign(Align.Center);
            }
            if (align.equals(">")) {
                tcb.setHorzAlign(Align.End);
            }
            tcb.setWidth(Integer.valueOf(Integer.parseInt(width)));
            tcb.setMultiLine(Boolean.valueOf(true));
        }
        return tcb;
    }

    @Override
    public <T> Func1<String, T> build(BasicTemplate template, final Func1<Object, T> setContext, final Func1<String, String> evalCode) {
        final ArrayList rows = new ArrayList();
        final ArrayList cells = new ArrayList();
        final LinkedHashMap codeFormat = new LinkedHashMap();
        template.getParser().eval(template.getAst(), new Func1(){

            public Object apply(Object text) {
                int i = -1;
                String[] stringArray = Text.splitNewLines((String)text.toString());
                int n = stringArray.length;
                for (int j = 0; j < n; ++j) {
                    String line;
                    final String fline = line = stringArray[j];
                    if (++i > 0) {
                        rows.add(Arrays.asList(cells.toArray()));
                        cells.clear();
                    }
                    Func1 cellFun = new Func1(){

                        public Object apply(Object context) {
                            return fline;
                        }
                    };
                    cells.add(cellFun);
                }
                return text;
            }
        }, new Func1(){

            public Object apply(Object code) {
                Pattern ptrn = Pattern.compile("(?s)^(.*?)\\:(((<?|=|>)(\\d+)))$");
                Matcher m = ptrn.matcher(code.toString());
                String srccode = code.toString();
                TextCellBuilder tcb = null;
                if (m.matches()) {
                    srccode = m.group(1);
                    String format = m.group(2);
                    tcb = AlignFormatBuilder.this.buildTextCell(format);
                }
                final String fsrccode = srccode;
                Func1 cellFun = new Func1(){

                    public Object apply(Object context) {
                        setContext.apply(context);
                        return evalCode.apply((Object)fsrccode);
                    }
                };
                cells.add(cellFun);
                codeFormat.put(cellFun, tcb);
                return fsrccode;
            }
        }, new Func0(){

            public Object apply() {
                return "";
            }
        }, new Func2(){

            public Object apply(Object res, Object text) {
                return "";
            }
        }, new Func2(){

            public Object apply(Object res, Object code) {
                return "";
            }
        }).apply();
        if (!cells.isEmpty()) {
            rows.add(cells);
        }
        Func1 evalCtx = new Func1(){

            public Object apply(Object ctx) {
                ArrayList<String> strings = new ArrayList<String>();
                for (Object ocells : rows) {
                    if (!(ocells instanceof List)) continue;
                    ArrayList<TextCell> ltc = new ArrayList<TextCell>();
                    for (Object ocell : (List)ocells) {
                        TextCell tc;
                        TextCellBuilder tcb;
                        Object cellval;
                        String txtval = "";
                        if (ocell instanceof Func1 && (cellval = ((Func1)ocell).apply(ctx)) != null) {
                            txtval = cellval.toString();
                        }
                        if ((tcb = (TextCellBuilder)codeFormat.get(ocell)) != null) {
                            tc = tcb.build(txtval);
                            ltc.add(tc);
                            continue;
                        }
                        tcb = new TextCellBuilder();
                        tcb.setWidth(Integer.valueOf(txtval.length()));
                        tc = tcb.build(txtval);
                        ltc.add(tc);
                    }
                    List lstr = TextCell.joinAsList(ltc);
                    if (lstr != null && lstr.isEmpty()) {
                        strings.add("");
                        continue;
                    }
                    strings.addAll(lstr);
                }
                return Text.join(strings, (String)EndLine.Default.get());
            }
        };
        return evalCtx;
    }
}

