/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.template;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.Pointer;
import xyz.cofe.text.ast.AstNode;
import xyz.cofe.text.parser.Token;
import xyz.cofe.text.template.EvalVisitor;
import xyz.cofe.text.template.TemplateLexer;
import xyz.cofe.text.template.ast.Block;
import xyz.cofe.text.template.ast.BlockBody;
import xyz.cofe.text.template.ast.Code;
import xyz.cofe.text.template.ast.Escape;
import xyz.cofe.text.template.ast.Sequence;
import xyz.cofe.text.template.ast.Text;

public class TemplateParser {
    private final String[] codeBeginLexems;
    private final String[] escapeLexems;
    private final String[] blockBeginLexems;
    private final String[] blockEndLexems;
    private LinkedHashMap<String, String> escapeRewriteMap = new LinkedHashMap();

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(TemplateParser.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(TemplateParser.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(TemplateParser.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(TemplateParser.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(TemplateParser.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(TemplateParser.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(TemplateParser.class.getName()).log(Level.SEVERE, null, ex);
    }

    public TemplateParser() {
        this.codeBeginLexems = new String[]{"${"};
        this.escapeLexems = new String[]{"\\${", "\\$", "\\\\"};
        this.blockBeginLexems = new String[]{"{"};
        this.blockEndLexems = new String[]{"}"};
        this.escapeRewriteMap.put("\\${", "${");
        this.escapeRewriteMap.put("\\$", "$");
        this.escapeRewriteMap.put("\\\\", "\\");
    }

    public <ResultType, EvalCode, EvalText> Func0<ResultType> eval(AstNode tree, Func1<EvalText, String> evalText, Func1<EvalCode, String> evalCode, final Func0<ResultType> initResult, final Func2<ResultType, ResultType, EvalText> appendText, final Func2<ResultType, ResultType, EvalCode> appendCode) {
        final ArrayList<Func0> funs = new ArrayList<Func0>();
        final LinkedHashMap<Func0, Boolean> funAsCode = new LinkedHashMap<Func0, Boolean>();
        EvalVisitor ev = new EvalVisitor();
        ev.appendCode = appendCode;
        ev.appendText = appendText;
        ev.initResult = initResult;
        ev.evalCode = evalCode;
        ev.evalText = evalText;
        ev.escapeRewriteMap = this.escapeRewriteMap;
        ev.funAsCode = funAsCode;
        ev.funs = funs;
        ev.codeContext = false;
        ev.sbCode = new StringBuilder();
        EvalVisitor.visit(tree, ev);
        return new Func0<ResultType>(){

            public ResultType apply() {
                Object res = initResult.apply();
                for (Func0 f : funs) {
                    if (((Boolean)funAsCode.get(f)).booleanValue()) {
                        res = appendCode.apply(res, f.apply());
                        continue;
                    }
                    res = appendText.apply(res, f.apply());
                }
                return res;
            }
        };
    }

    public Func0<String> evalAndPrint(AstNode tree, Func1<String, String> evalCode) {
        if (tree == null) {
            throw new IllegalArgumentException("tree==null");
        }
        if (evalCode == null) {
            throw new IllegalArgumentException("evalCode==null");
        }
        return this.eval(tree, new Func1<String, String>(){

            public String apply(String arg) {
                return arg;
            }
        }, evalCode, new Func0<String>(){

            public String apply() {
                return "";
            }
        }, new Func2<String, String, String>(){

            public String apply(String src, String append) {
                return src + append;
            }
        }, new Func2<String, String, String>(){

            public String apply(String src, String append) {
                return src + append;
            }
        });
    }

    public Func0<String> evalAndPrint(AstNode tree, Func1<String, String> evalText, Func1<String, String> evalCode) {
        if (tree == null) {
            throw new IllegalArgumentException("tree==null");
        }
        if (evalCode == null) {
            throw new IllegalArgumentException("evalCode==null");
        }
        if (evalText == null) {
            throw new IllegalArgumentException("evalText==null");
        }
        return this.eval(tree, evalText, evalCode, new Func0<String>(){

            public String apply() {
                return "";
            }
        }, new Func2<String, String, String>(){

            public String apply(String src, String append) {
                return src + append;
            }
        }, new Func2<String, String, String>(){

            public String apply(String src, String append) {
                return src + append;
            }
        });
    }

    public AstNode parse(String source) {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        TemplateLexer lexer = new TemplateLexer(this.codeBeginLexems, this.escapeLexems, this.blockBeginLexems, this.blockEndLexems);
        List tokens = lexer.parse(source);
        Pointer ptr = new Pointer(tokens);
        AstNode v = this.start((Pointer<Token>)ptr);
        return v;
    }

    private static boolean in(String id, String ... arr) {
        return xyz.cofe.text.Text.in((String)id, (String[])arr);
    }

    private AstNode start(Pointer<Token> ptr) {
        Token t = (Token)ptr.lookup(0);
        if (t == null) {
            return null;
        }
        String id = t.getId();
        if (TemplateParser.in(id, "codeBegin")) {
            AstNode c = this.code(ptr);
            if (c == null) {
                return null;
            }
            AstNode n = this.start(ptr);
            if (n == null) {
                return c;
            }
            return new Sequence(c, n);
        }
        if (TemplateParser.in(id, "anyChar", "blockBegin", "blockEnd")) {
            Text text = new Text(t);
            ptr.move(1);
            AstNode v = this.start(ptr);
            if (v == null) {
                return text;
            }
            return new Sequence(text, v);
        }
        if (TemplateParser.in(id, "escape")) {
            Escape esc = new Escape(t);
            ptr.move(1);
            AstNode v = this.start(ptr);
            if (v == null) {
                return esc;
            }
            return new Sequence(esc, v);
        }
        return null;
    }

    private AstNode code(Pointer<Token> ptr) {
        Token t = (Token)ptr.lookup(0);
        if (t == null) {
            return null;
        }
        String id = t.getId();
        if (!id.equals("codeBegin")) {
            return null;
        }
        ptr.push();
        ptr.move(1);
        BlockBody blockBody = this.blockBody(ptr);
        if (blockBody == null) {
            ptr.restore();
            return null;
        }
        Token tEnd = (Token)ptr.lookup(0);
        if (tEnd == null) {
            ptr.restore();
            return null;
        }
        if (!tEnd.getId().equals("blockEnd")) {
            ptr.restore();
            return null;
        }
        ptr.pop();
        ptr.move(1);
        return new Code(t, blockBody, tEnd);
    }

    private BlockBody blockBody(Pointer<Token> ptr) {
        Token t = (Token)ptr.lookup(0);
        if (t == null) {
            return null;
        }
        String id = t.getId();
        if (TemplateParser.in(id, "anyChar")) {
            Text txt = new Text(t);
            ptr.move(1);
            BlockBody v = this.blockBody(ptr);
            if (v == null) {
                return new BlockBody(txt);
            }
            return new BlockBody(new Sequence(txt, v));
        }
        if (TemplateParser.in(id, "escape")) {
            Escape esc = new Escape(t);
            ptr.move(1);
            BlockBody v = this.blockBody(ptr);
            if (v == null) {
                return new BlockBody(esc);
            }
            return new BlockBody(new Sequence(esc, v));
        }
        if (TemplateParser.in(id, "blockBegin")) {
            Block v = this.block(ptr);
            if (v == null) {
                return null;
            }
            BlockBody bb = this.blockBody(ptr);
            if (bb == null) {
                return new BlockBody(v);
            }
            return new BlockBody(new Sequence(v, bb));
        }
        return null;
    }

    private Block block(Pointer<Token> ptr) {
        Token t0 = (Token)ptr.lookup(0);
        if (t0 == null) {
            return null;
        }
        String id0 = t0.getId();
        if (!TemplateParser.in(id0, "blockBegin")) {
            return null;
        }
        ptr.push();
        ptr.move(1);
        BlockBody body = this.blockBody(ptr);
        if (body == null) {
            ptr.restore();
            return null;
        }
        Token t1 = (Token)ptr.lookup(0);
        String id1 = t1.getId();
        if (!TemplateParser.in(id1, "blockEnd")) {
            ptr.restore();
            return null;
        }
        ptr.pop();
        ptr.move(1);
        return new Block(t0, body, t1);
    }
}

