/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXResult;
import org.w3c.dom.Node;
import xyz.cofe.xml.OutlineXMLWriter;

public class FormatXMLWriter
implements XMLStreamWriter {
    private static XMLOutputFactory outFactory = null;
    private OutlineXMLWriter outline = null;
    private boolean escapeWriteChars = false;
    private boolean writeStartDocument = true;

    public boolean isWriteOutline() {
        if (this.outline == null) {
            return true;
        }
        return this.outline.isWriteOutline();
    }

    public void setWriteOutline(boolean writeOutline) {
        if (this.outline == null) {
            return;
        }
        this.outline.setWriteOutline(writeOutline);
    }

    public FormatXMLWriter(File file, Charset encoding) {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("encoding == null");
        }
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
        }
        catch (FileNotFoundException ex) {
            throw new Error(ex.getMessage(), ex);
        }
        OutputStreamWriter wr = new OutputStreamWriter((OutputStream)fout, encoding);
        try {
            this.outline = new OutlineXMLWriter(FormatXMLWriter.createXMLWriter(wr));
        }
        catch (XMLStreamException ex) {
            throw new Error(ex.getMessage(), ex);
        }
    }

    public FormatXMLWriter(Path file, Charset encoding) {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("encoding == null");
        }
        OutputStream fout = null;
        try {
            fout = Files.newOutputStream(file, new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new Error(ex.getMessage(), ex);
        }
        OutputStreamWriter wr = new OutputStreamWriter(fout, encoding);
        try {
            this.outline = new OutlineXMLWriter(FormatXMLWriter.createXMLWriter(wr));
        }
        catch (XMLStreamException ex) {
            throw new Error(ex.getMessage(), ex);
        }
    }

    public FormatXMLWriter(xyz.cofe.io.fs.File file, Charset encoding) {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("encoding == null");
        }
        OutputStream fout = null;
        fout = file.writeStream(new OpenOption[0]);
        OutputStreamWriter wr = new OutputStreamWriter(fout, encoding);
        try {
            this.outline = new OutlineXMLWriter(FormatXMLWriter.createXMLWriter(wr));
        }
        catch (XMLStreamException ex) {
            throw new Error(ex.getMessage(), ex);
        }
    }

    public FormatXMLWriter() {
        try {
            this.outline = new OutlineXMLWriter(FormatXMLWriter.createXMLWriter(System.out));
        }
        catch (XMLStreamException ex) {
            throw new Error(ex.getMessage(), ex);
        }
    }

    public FormatXMLWriter(XMLStreamWriter writer) {
        if (writer == null) {
            throw new IllegalArgumentException("writer==null");
        }
        this.outline = new OutlineXMLWriter(writer);
    }

    public FormatXMLWriter(Writer writer) throws XMLStreamException {
        if (writer == null) {
            throw new IllegalArgumentException("writer==null");
        }
        this.outline = new OutlineXMLWriter(FormatXMLWriter.createXMLWriter(writer));
    }

    public FormatXMLWriter(OutputStream stream, String enconding) throws XMLStreamException {
        if (stream == null) {
            throw new IllegalArgumentException("stream==null");
        }
        if (enconding == null) {
            throw new IllegalArgumentException("enconding==null");
        }
        this.outline = new OutlineXMLWriter(FormatXMLWriter.createXMLWriter(stream, enconding));
    }

    public FormatXMLWriter(OutputStream stream, Charset enconding) throws XMLStreamException {
        if (stream == null) {
            throw new IllegalArgumentException("stream==null");
        }
        if (enconding == null) {
            throw new IllegalArgumentException("enconding==null");
        }
        this.outline = new OutlineXMLWriter(FormatXMLWriter.createXMLWriter(stream, enconding));
    }

    public FormatXMLWriter(OutputStream stream) throws XMLStreamException {
        if (stream == null) {
            throw new IllegalArgumentException("stream==null");
        }
        this.outline = new OutlineXMLWriter(FormatXMLWriter.createXMLWriter(stream));
    }

    public FormatXMLWriter(Result result) throws XMLStreamException {
        if (result == null) {
            throw new IllegalArgumentException("result==null");
        }
        this.outline = new OutlineXMLWriter(FormatXMLWriter.createXMLWriter(result));
    }

    private static XMLStreamWriter createXMLWriter(OutputStream stream, String enconding) throws XMLStreamException {
        return FormatXMLWriter.outFactory().createXMLStreamWriter(stream, enconding);
    }

    private static XMLStreamWriter createXMLWriter(OutputStream stream, Charset cs) throws XMLStreamException {
        return FormatXMLWriter.outFactory().createXMLStreamWriter(stream, cs.name());
    }

    private static XMLStreamWriter createXMLWriter(OutputStream stream) throws XMLStreamException {
        return FormatXMLWriter.outFactory().createXMLStreamWriter(stream);
    }

    private static XMLStreamWriter createXMLWriter(Writer writer) throws XMLStreamException {
        return FormatXMLWriter.outFactory().createXMLStreamWriter(writer);
    }

    private static XMLStreamWriter createXMLWriter(Result result) throws XMLStreamException {
        return FormatXMLWriter.outFactory().createXMLStreamWriter(result);
    }

    private static XMLOutputFactory outFactory() {
        if (outFactory == null) {
            outFactory = XMLOutputFactory.newInstance();
        }
        return outFactory;
    }

    public boolean isEscapeWriteChars() {
        return this.escapeWriteChars;
    }

    public void setEscapeWriteChars(boolean escapeWriteChars) {
        this.escapeWriteChars = escapeWriteChars;
    }

    public static String htmlEncode(String text) {
        if (text == null) {
            return null;
        }
        String escaped = text.replace("&", "&amp;");
        escaped = escaped.replace("<", "&lt;");
        escaped = escaped.replace(">", "&gt;");
        return escaped;
    }

    public static String htmlDecode(String html) {
        if (html == null) {
            return null;
        }
        String decode = html.replace("&lt;", "<");
        decode = decode.replace("&gt;", ">");
        decode = decode.replace("&amp;", "&");
        return decode;
    }

    public void writeEscapeCharacters(String text) throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        if (text == null) {
            this.outline.writeCharacters(text);
            return;
        }
        this.outline.writeCharacters(FormatXMLWriter.htmlEncode(text));
    }

    public void writeEscapeCharacters(char[] text, int start, int len) throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        if (text == null) {
            this.outline.writeCharacters(text, start, len);
            return;
        }
        String srcText = new String(text, start, len);
        this.outline.writeCharacters(FormatXMLWriter.htmlEncode(srcText));
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        this.outline.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        this.outline.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        this.outline.writeStartElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        if (this.writeStartDocument) {
            this.outline.writeStartDocument();
        }
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        if (this.writeStartDocument) {
            this.outline.writeStartDocument(version);
        }
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        if (this.writeStartDocument) {
            this.outline.writeStartDocument(encoding, version);
        }
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        this.outline.writeProcessingInstruction(target);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        this.outline.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        this.outline.writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        this.outline.writeEntityRef(name);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        this.outline.writeEndElement();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        if (this.writeStartDocument) {
            this.outline.writeEndDocument();
        }
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        this.outline.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        this.outline.writeEmptyElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        this.outline.writeEmptyElement(localName);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        this.outline.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        this.outline.writeDTD(dtd);
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        this.outline.writeComment(data);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        if (this.isEscapeWriteChars()) {
            this.writeEscapeCharacters(text);
        } else {
            this.outline.writeCharacters(text);
        }
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        if (this.isEscapeWriteChars()) {
            this.writeEscapeCharacters(text, start, len);
        } else {
            this.outline.writeCharacters(text, start, len);
        }
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        this.outline.writeCData(data);
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        this.outline.writeAttribute(localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        this.outline.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        this.outline.writeAttribute(namespaceURI, localName, value);
    }

    public void setSpacer(String spacer) {
        if (this.outline == null) {
            return;
        }
        this.outline.setSpacer(spacer);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        this.outline.setPrefix(prefix, uri);
    }

    public void setNewline(String newline) {
        if (this.outline == null) {
            return;
        }
        this.outline.setNewline(newline);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        this.outline.setNamespaceContext(context);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        this.outline.setDefaultNamespace(uri);
    }

    public XMLStreamWriter getWriter() {
        if (this.outline == null) {
            return null;
        }
        return this.outline.getWriter();
    }

    public String getSpacer() {
        if (this.outline == null) {
            return null;
        }
        return this.outline.getSpacer();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        if (this.outline == null) {
            return null;
        }
        return this.outline.getProperty(name);
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        if (this.outline == null) {
            return null;
        }
        return this.outline.getPrefix(uri);
    }

    public String getNewline() {
        if (this.outline == null) {
            return null;
        }
        return this.outline.getNewline();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        if (this.outline == null) {
            return null;
        }
        return this.outline.getNamespaceContext();
    }

    public Integer getLevel() {
        if (this.outline == null) {
            return 0;
        }
        return this.outline.getLevel();
    }

    @Override
    public void flush() throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        this.outline.flush();
    }

    @Override
    public void close() throws XMLStreamException {
        if (this.outline == null) {
            return;
        }
        this.outline.close();
    }

    public boolean isWriteStartDocument() {
        return this.writeStartDocument;
    }

    public void setWriteStartDocument(boolean writeStartDocument) {
        this.writeStartDocument = writeStartDocument;
    }

    public static String toStringWithException(Node xmlDocument) throws XMLStreamException, TransformerConfigurationException, TransformerException, IOException {
        StAXResult sResult;
        if (xmlDocument == null) {
            throw new IllegalArgumentException("xmlDocument == null");
        }
        Transformer tr = TransformerFactory.newInstance().newTransformer();
        DOMSource domSrc = new DOMSource(xmlDocument);
        StringWriter sWiter = new StringWriter();
        FormatXMLWriter xml2format = new FormatXMLWriter(sWiter);
        StAXResult result = sResult = new StAXResult(xml2format);
        tr.transform(domSrc, result);
        xml2format.writeEndDocument();
        xml2format.flush();
        String toOutput = sWiter.toString();
        xml2format.close();
        sWiter.close();
        return toOutput;
    }

    public static String toStringWithoutException(Node xmlDocument, String defaultResult) {
        try {
            return FormatXMLWriter.toStringWithException(xmlDocument);
        }
        catch (IOException iOException) {
        }
        catch (TransformerException transformerException) {
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
        return defaultResult;
    }
}

